/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

public abstract class Validator<T> {
    public final T validate(T argument) {
        if (!this.isValid(argument)) {
            throw new IllegalArgumentException(this.invalidMessage(argument));
        }
        return argument;
    }

    public abstract boolean isValid(T var1);

    public String invalidMessage(T argument) {
        return String.format("Invalid argument %s", argument);
    }

    public final Validator<T> and(final Validator<T> other) {
        if (other == null) {
            return this;
        }
        final Validator mine = this;
        return new Validator<T>(){

            @Override
            public boolean isValid(T argument) {
                return mine.isValid(argument) && other.isValid(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return (mine.isValid(argument) ? other : mine).invalidMessage(argument);
            }
        };
    }

    public final Validator<T> or(final Validator<T> other) {
        if (other == null) {
            return this;
        }
        final Validator mine = this;
        return new Validator<T>(){

            @Override
            public boolean isValid(T argument) {
                return mine.isValid(argument) || other.isValid(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return mine.invalidMessage(argument);
            }
        };
    }

    public final Validator<T> not() {
        final Validator mine = this;
        return new Validator<T>(){

            @Override
            public boolean isValid(T argument) {
                return !mine.isValid(argument);
            }

            @Override
            public String invalidMessage(T argument) {
                return "Validation should have failed with: " + mine.invalidMessage(argument);
            }
        };
    }
}

