/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.hadoop.io.Text;

public class DefaultFormatter
implements Formatter {
    private Iterator<Map.Entry<Key, Value>> si;
    private boolean doTimestamps;
    private static final ThreadLocal<DateFormat> formatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new DefaultDateFormat();
        }
    };
    private static ThreadLocal<Date> tmpDate = new ThreadLocal<Date>(){

        @Override
        protected Date initialValue() {
            return new Date();
        }
    };

    @Override
    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        this.checkState(false);
        this.si = scanner.iterator();
        this.doTimestamps = printTimestamps;
    }

    @Override
    public boolean hasNext() {
        this.checkState(true);
        return this.si.hasNext();
    }

    @Override
    public String next() {
        DateFormat timestampFormat = null;
        if (this.doTimestamps) {
            timestampFormat = formatter.get();
        }
        return this.next(timestampFormat);
    }

    protected String next(DateFormat timestampFormat) {
        this.checkState(true);
        return DefaultFormatter.formatEntry(this.si.next(), timestampFormat);
    }

    @Override
    public void remove() {
        this.checkState(true);
        this.si.remove();
    }

    protected void checkState(boolean expectInitialized) {
        if (expectInitialized && this.si == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!expectInitialized && this.si != null) {
            throw new IllegalStateException("Already initialized");
        }
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, boolean showTimestamps) {
        DateFormat timestampFormat = null;
        if (showTimestamps) {
            timestampFormat = formatter.get();
        }
        return DefaultFormatter.formatEntry(entry, timestampFormat);
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, DateFormat timestampFormat) {
        Value value;
        StringBuilder sb = new StringBuilder();
        Key key = entry.getKey();
        Text buffer = new Text();
        DefaultFormatter.appendText(sb, key.getRow(buffer)).append(" ");
        DefaultFormatter.appendText(sb, key.getColumnFamily(buffer)).append(":");
        DefaultFormatter.appendText(sb, key.getColumnQualifier(buffer)).append(" ");
        sb.append(new ColumnVisibility(key.getColumnVisibility(buffer)));
        if (timestampFormat != null) {
            tmpDate.get().setTime(entry.getKey().getTimestamp());
            sb.append(" ").append(timestampFormat.format(tmpDate.get()));
        }
        if ((value = entry.getValue()) != null && value.getSize() > 0) {
            sb.append("\t");
            DefaultFormatter.appendValue(sb, value);
        }
        return sb.toString();
    }

    static StringBuilder appendText(StringBuilder sb, Text t) {
        return DefaultFormatter.appendBytes(sb, t.getBytes(), 0, t.getLength());
    }

    static StringBuilder appendValue(StringBuilder sb, Value value) {
        return DefaultFormatter.appendBytes(sb, value.get(), 0, value.get().length);
    }

    static StringBuilder appendBytes(StringBuilder sb, byte[] ba, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            int c = 0xFF & ba[offset + i];
            if (c == 92) {
                sb.append("\\\\");
                continue;
            }
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("\\x").append(String.format("%02X", c));
        }
        return sb;
    }

    public Iterator<Map.Entry<Key, Value>> getScannerIterator() {
        return this.si;
    }

    protected boolean isDoTimestamps() {
        return this.doTimestamps;
    }

    public static class DefaultDateFormat
    extends DateFormat {
        private static final long serialVersionUID = 1L;

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            toAppendTo.append(Long.toString(date.getTime()));
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            return new Date(Long.parseLong(source));
        }
    }
}

