/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.array;

public class Arrays {
    private Arrays() {
    }

    public static int[] ensureCapacity(int[] buffer, int capacity) {
        return Arrays.ensureCapacity(buffer, capacity, ExpansionFactor.SMALL, ExpansionOption.NONE);
    }

    public static int[] ensureCapacity(int[] buffer, int capacity, ExpansionFactor expansionFactor, ExpansionOption expansionOption) {
        int newCapacity = (int)((double)capacity * expansionFactor.expansionFactor);
        if (buffer == null) {
            buffer = new int[newCapacity];
        } else if (buffer.length < capacity) {
            buffer = expansionOption == ExpansionOption.PRESERVE ? java.util.Arrays.copyOf(buffer, newCapacity) : new int[newCapacity];
        } else if (expansionOption == ExpansionOption.INITIALIZE) {
            java.util.Arrays.fill(buffer, 0);
        }
        return buffer;
    }

    public static long[] ensureCapacity(long[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new long[(int)((double)capacity * ExpansionFactor.SMALL.expansionFactor)];
        }
        return buffer;
    }

    public static boolean[] ensureCapacity(boolean[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new boolean[(int)((double)capacity * ExpansionFactor.SMALL.expansionFactor)];
        }
        return buffer;
    }

    public static byte[] ensureCapacity(byte[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new byte[(int)((double)capacity * ExpansionFactor.SMALL.expansionFactor)];
        }
        return buffer;
    }

    public static int[][] ensureCapacity(int[][] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new int[capacity][];
        }
        return buffer;
    }

    public static boolean[][] ensureCapacity(boolean[][] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new boolean[capacity][];
        }
        return buffer;
    }

    public static byte[] ensureCapacity(byte[] buffer, int capacity, ExpansionFactor expansionFactor, ExpansionOption expansionOption) {
        int newCapacity = (int)((double)capacity * expansionFactor.expansionFactor);
        if (buffer == null) {
            buffer = new byte[newCapacity];
        } else if (buffer.length < capacity) {
            buffer = expansionOption == ExpansionOption.PRESERVE ? java.util.Arrays.copyOf(buffer, newCapacity) : new byte[newCapacity];
        } else if (expansionOption == ExpansionOption.INITIALIZE) {
            java.util.Arrays.fill(buffer, (byte)0);
        }
        return buffer;
    }

    public static enum ExpansionOption {
        PRESERVE,
        INITIALIZE,
        NONE;

    }

    public static enum ExpansionFactor {
        SMALL(1.0),
        MEDIUM(1.5),
        LARGE(2.0);

        private final double expansionFactor;

        private ExpansionFactor(double expansionFactor) {
            this.expansionFactor = expansionFactor;
        }
    }
}

