/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds;

import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tpcds.TpcdsHandleResolver;
import com.facebook.presto.tpcds.TpcdsMetadata;
import com.facebook.presto.tpcds.TpcdsNodePartitioningProvider;
import com.facebook.presto.tpcds.TpcdsRecordSetProvider;
import com.facebook.presto.tpcds.TpcdsSplitManager;
import com.facebook.presto.tpcds.TpcdsTransactionHandle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;

public class TpcdsConnectorFactory
implements ConnectorFactory {
    private final int defaultSplitsPerNode;

    public TpcdsConnectorFactory() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public TpcdsConnectorFactory(int defaultSplitsPerNode) {
        Preconditions.checkState((defaultSplitsPerNode > 0 ? 1 : 0) != 0, (Object)"default splits per node is negative");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpcds";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpcdsHandleResolver();
    }

    public Connector create(String catalogName, final Map<String, String> config, ConnectorContext context) {
        final int splitsPerNode = this.getSplitsPerNode(config);
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpcdsTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
                return new TpcdsMetadata();
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpcdsSplitManager(nodeManager, splitsPerNode, TpcdsConnectorFactory.this.isWithNoSexism(config));
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpcdsRecordSetProvider();
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpcdsNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpcds.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpcds.splits-per-node");
        }
    }

    private boolean isWithNoSexism(Map<String, String> properties) {
        return Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)properties.get("tpcds.with-no-sexism"), (Object)String.valueOf(false)));
    }
}

