/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.tpcds.TpcdsColumnHandle;
import com.facebook.presto.tpcds.TpcdsRecordSet;
import com.facebook.presto.tpcds.TpcdsSplit;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.Results;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.column.Column;
import java.util.List;

public class TpcdsRecordSetProvider
implements ConnectorRecordSetProvider {
    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        TpcdsSplit tpcdsSplit = (TpcdsSplit)split;
        String tableName = tpcdsSplit.getTableHandle().getTableName();
        Table table = Table.getTable((String)tableName);
        return this.getRecordSet(table, columns, tpcdsSplit.getTableHandle().getScaleFactor(), tpcdsSplit.getPartNumber(), tpcdsSplit.getTotalParts(), tpcdsSplit.isNoSexism());
    }

    private RecordSet getRecordSet(Table table, List<? extends ColumnHandle> columns, double scaleFactor, int partNumber, int totalParts, boolean noSexism) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = ((TpcdsColumnHandle)columnHandle).getColumnName();
            builder.add((Object)table.getColumn(columnName));
        }
        Session session = Session.getDefaultSession().withScale(scaleFactor).withParallelism(totalParts).withChunkNumber(partNumber + 1).withTable(table).withNoSexism(noSexism);
        Results results = Results.constructResults((Table)table, (Session)session);
        return new TpcdsRecordSet(results, (List<Column>)builder.build());
    }
}

