/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraClusteringPredicatesExtractor;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraInsertTableHandle;
import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraPartitionManager;
import com.facebook.presto.cassandra.CassandraPartitionResult;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraTableLayoutHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.ExtraColumnMetadata;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class CassandraMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final CassandraSession cassandraSession;
    private final CassandraPartitionManager partitionManager;
    private final boolean allowDropTable;
    private final JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec;

    @Inject
    public CassandraMetadata(CassandraConnectorId connectorId, CassandraSession cassandraSession, CassandraPartitionManager partitionManager, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec, CassandraClientConfig config) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.allowDropTable = Objects.requireNonNull(config, "config is null").getAllowDropTable();
        this.extraColumnMetadataCodec = Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.cassandraSession.getCaseSensitiveSchemaNames().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    public CassandraTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        try {
            return this.cassandraSession.getTable(tableName).getTableHandle();
        }
        catch (SchemaNotFoundException | TableNotFoundException e) {
            return null;
        }
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return ((CassandraTableHandle)tableHandle).getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        return this.getTableMetadata(CassandraMetadata.getTableName(tableHandle));
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        CassandraTable table = this.cassandraSession.getTable(tableName);
        List columns = table.getColumns().stream().map(CassandraColumnHandle::getColumnMetadata).collect(Collectors.toList());
        return new ConnectorTableMetadata(tableName, columns);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            try {
                for (String tableName : this.cassandraSession.getCaseSensitiveTableNames(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase(Locale.ENGLISH)));
                }
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        CassandraTable table = this.cassandraSession.getTable(CassandraMetadata.getTableName(tableHandle));
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (CassandraColumnHandle columnHandle : table.getColumns()) {
            columnHandles.put((Object)CassandraCqlUtils.cqlNameToSqlName(columnHandle.getName()).toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (NotFoundException notFoundException) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((CassandraColumnHandle)columnHandle).getColumnMetadata();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        TupleDomain<ColumnHandle> unenforcedConstraint;
        CassandraTableHandle handle = (CassandraTableHandle)table;
        CassandraPartitionResult partitionResult = this.partitionManager.getPartitions(handle, (TupleDomain<ColumnHandle>)constraint.getSummary());
        String clusteringKeyPredicates = "";
        if (partitionResult.isUnpartitioned()) {
            unenforcedConstraint = partitionResult.getUnenforcedConstraint();
        } else {
            CassandraClusteringPredicatesExtractor clusteringPredicatesExtractor = new CassandraClusteringPredicatesExtractor(this.cassandraSession.getTable(CassandraMetadata.getTableName(handle)).getClusteringKeyColumns(), partitionResult.getUnenforcedConstraint(), this.cassandraSession.getCassandraVersion());
            clusteringKeyPredicates = clusteringPredicatesExtractor.getClusteringKeyPredicates();
            unenforcedConstraint = clusteringPredicatesExtractor.getUnenforcedConstraints();
        }
        ConnectorTableLayout layout = this.getTableLayout(session, new CassandraTableLayoutHandle(handle, partitionResult.getPartitions(), clusteringKeyPredicates));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, unenforcedConstraint));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE not yet supported for Cassandra");
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraTableHandle), (Object)"tableHandle is not an instance of CassandraTableHandle");
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this Cassandra catalog");
        }
        CassandraTableHandle cassandraTableHandle = (CassandraTableHandle)tableHandle;
        if (this.cassandraSession.isMaterializedView(cassandraTableHandle.getSchemaTableName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Dropping materialized views not yet supported");
        }
        this.cassandraSession.execute(String.format("DROP TABLE \"%s\".\"%s\"", cassandraTableHandle.getSchemaName(), cassandraTableHandle.getTableName()), new Object[0]);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming tables not yet supported for Cassandra");
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        ImmutableList.Builder columnExtra = ImmutableList.builder();
        columnExtra.add((Object)new ExtraColumnMetadata("id", true));
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            columnNames.add((Object)column.getName());
            columnTypes.add((Object)column.getType());
            columnExtra.add((Object)new ExtraColumnMetadata(column.getName(), column.isHidden()));
        }
        SchemaTableName table = tableMetadata.getTable();
        String schemaName = this.cassandraSession.getCaseSensitiveSchemaName(table.getSchemaName());
        String tableName = table.getTableName();
        ImmutableList columns = columnNames.build();
        ImmutableList types = columnTypes.build();
        StringBuilder queryBuilder = new StringBuilder(String.format("CREATE TABLE \"%s\".\"%s\"(id uuid primary key", schemaName, tableName));
        for (int i = 0; i < columns.size(); ++i) {
            String name = (String)columns.get(i);
            Type type = (Type)types.get(i);
            queryBuilder.append(", ").append(name).append(" ").append(CassandraType.toCassandraType(type).name().toLowerCase(Locale.ENGLISH));
        }
        queryBuilder.append(") ");
        String columnMetadata = this.extraColumnMetadataCodec.toJson((Object)columnExtra.build());
        queryBuilder.append("WITH comment='").append("Presto Metadata:").append(" ").append(columnMetadata).append("'");
        this.cassandraSession.execute(queryBuilder.toString(), new Object[0]);
        return new CassandraOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build());
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        CassandraTableHandle table = (CassandraTableHandle)tableHandle;
        if (this.cassandraSession.isMaterializedView(table.getSchemaTableName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Inserting into materialized views not yet supported");
        }
        SchemaTableName schemaTableName = new SchemaTableName(table.getSchemaName(), table.getTableName());
        List<CassandraColumnHandle> columns = this.cassandraSession.getTable(schemaTableName).getColumns();
        List<String> columnNames = columns.stream().map(CassandraColumnHandle::getName).map(CassandraCqlUtils::validColumnName).collect(Collectors.toList());
        List<Type> columnTypes = columns.stream().map(CassandraColumnHandle::getType).collect(Collectors.toList());
        return new CassandraInsertTableHandle(this.connectorId, CassandraCqlUtils.validSchemaName(table.getSchemaName()), CassandraCqlUtils.validTableName(table.getTableName()), columnNames, columnTypes);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }
}

