/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraPartitionResult;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class CassandraPartitionManager {
    private static final Logger log = Logger.get(CassandraPartitionManager.class);
    private final CassandraSession cassandraSession;

    @Inject
    public CassandraPartitionManager(CassandraSession cassandraSession) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
    }

    public CassandraPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ColumnHandle> tupleDomain) {
        CassandraTableHandle cassandraTableHandle = (CassandraTableHandle)tableHandle;
        CassandraTable table = this.cassandraSession.getTable(cassandraTableHandle.getSchemaTableName());
        List<CassandraColumnHandle> partitionKeys = table.getPartitionKeyColumns();
        List<CassandraPartition> allPartitions = this.getCassandraPartitions(table, tupleDomain);
        log.debug("%s.%s #partitions: %d", new Object[]{cassandraTableHandle.getSchemaName(), cassandraTableHandle.getTableName(), allPartitions.size()});
        List<CassandraPartition> partitions = allPartitions.stream().filter(partition -> tupleDomain.overlaps(partition.getTupleDomain())).collect(Collectors.toList());
        TupleDomain remainingTupleDomain = TupleDomain.none();
        if (!tupleDomain.isNone()) {
            if (partitions.size() == 1 && ((CassandraPartition)partitions.get(0)).isUnpartitioned()) {
                remainingTupleDomain = tupleDomain;
            } else {
                List<CassandraColumnHandle> partitionColumns = partitionKeys;
                remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)tupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
            }
        }
        if (partitions.size() == 1 && ((CassandraPartition)partitions.get(0)).isUnpartitioned()) {
            Map domains = (Map)tupleDomain.getDomains().get();
            ArrayList<CassandraColumnHandle> indexedColumns = new ArrayList<CassandraColumnHandle>();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : domains.entrySet()) {
                CassandraColumnHandle column = (CassandraColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                if (!column.isIndexed() || !domain.isSingleValue()) continue;
                sb.append(CassandraCqlUtils.validColumnName(column.getName())).append(" = ").append(CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(((Domain)entry.getValue()).getSingleValue()), column.getCassandraType()));
                indexedColumns.add(column);
                break;
            }
            if (sb.length() > 0) {
                CassandraPartition partition2 = partitions.get(0);
                TupleDomain filterIndexedColumn = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)remainingTupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(indexedColumns))));
                partitions = new ArrayList<CassandraPartition>();
                partitions.add(new CassandraPartition(partition2.getKey(), sb.toString(), (TupleDomain<ColumnHandle>)filterIndexedColumn, true));
                return new CassandraPartitionResult(partitions, (TupleDomain<ColumnHandle>)filterIndexedColumn);
            }
        }
        return new CassandraPartitionResult(partitions, (TupleDomain<ColumnHandle>)remainingTupleDomain);
    }

    private List<CassandraPartition> getCassandraPartitions(CassandraTable table, TupleDomain<ColumnHandle> tupleDomain) {
        if (tupleDomain.isNone()) {
            return ImmutableList.of();
        }
        List<Set<Object>> partitionKeysList = CassandraPartitionManager.getPartitionKeysList(table, tupleDomain);
        Set filterList = Sets.cartesianProduct(partitionKeysList);
        if (filterList.isEmpty()) {
            return this.cassandraSession.getPartitions(table, (List<Set<Object>>)ImmutableList.of());
        }
        return this.cassandraSession.getPartitions(table, partitionKeysList);
    }

    private static List<Set<Object>> getPartitionKeysList(CassandraTable table, TupleDomain<ColumnHandle> tupleDomain) {
        ImmutableList.Builder partitionColumnValues = ImmutableList.builder();
        for (CassandraColumnHandle columnHandle : table.getPartitionKeyColumns()) {
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(columnHandle);
            if (domain == null) {
                return ImmutableList.of();
            }
            if (domain.isNullAllowed()) {
                return ImmutableList.of();
            }
            Set values = (Set)domain.getValues().getValuesProcessor().transform(ranges -> {
                ImmutableSet.Builder columnValues = ImmutableSet.builder();
                for (Range range : ranges.getOrderedRanges()) {
                    if (!range.isSingleValue()) {
                        return ImmutableSet.of();
                    }
                    Object value = range.getSingleValue();
                    CassandraType valueType = columnHandle.getCassandraType();
                    columnValues.add(valueType.validatePartitionKey(value));
                }
                return columnValues.build();
            }, discreteValues -> {
                if (discreteValues.isWhiteList()) {
                    return ImmutableSet.copyOf((Collection)discreteValues.getValues());
                }
                return ImmutableSet.of();
            }, allOrNone -> ImmutableSet.of());
            partitionColumnValues.add((Object)values);
        }
        return partitionColumnValues.build();
    }
}

