/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class CassandraPartitionResult {
    private final List<CassandraPartition> partitions;
    private final TupleDomain<ColumnHandle> unenforcedConstraint;

    public CassandraPartitionResult(List<CassandraPartition> partitions, TupleDomain<ColumnHandle> unenforcedConstraint) {
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.unenforcedConstraint = Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
    }

    public List<CassandraPartition> getPartitions() {
        return this.partitions;
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraint() {
        return this.unenforcedConstraint;
    }

    public boolean isUnpartitioned() {
        return this.partitions.size() == 1 && ((CassandraPartition)Iterables.getOnlyElement(this.partitions)).isUnpartitioned();
    }
}

