/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class CassandraTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final CassandraTableHandle table;
    private final List<CassandraPartition> partitions;
    private final String clusteringPredicates;

    @JsonCreator
    public CassandraTableLayoutHandle(@JsonProperty(value="table") CassandraTableHandle table) {
        this(table, (List<CassandraPartition>)ImmutableList.of(), "");
    }

    public CassandraTableLayoutHandle(CassandraTableHandle table, List<CassandraPartition> partitions, String clusteringPredicates) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.partitions = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partition is null"));
        this.clusteringPredicates = Objects.requireNonNull(clusteringPredicates, "clusteringPredicates is null");
    }

    @JsonProperty
    public CassandraTableHandle getTable() {
        return this.table;
    }

    @JsonIgnore
    public List<CassandraPartition> getPartitions() {
        return this.partitions;
    }

    @JsonIgnore
    public String getClusteringPredicates() {
        return this.clusteringPredicates;
    }

    public String toString() {
        return this.table.toString();
    }
}

