/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class SizeEstimate {
    private final String rangeStart;
    private final String rangeEnd;
    private final long meanPartitionSize;
    private final long partitionsCount;

    public SizeEstimate(String rangeStart, String rangeEnd, long meanPartitionSize, long partitionsCount) {
        this.rangeStart = Objects.requireNonNull(rangeStart, "rangeStart is null");
        this.rangeEnd = Objects.requireNonNull(rangeEnd, "rangeEnd is null");
        this.meanPartitionSize = meanPartitionSize;
        this.partitionsCount = partitionsCount;
    }

    public String getRangeStart() {
        return this.rangeStart;
    }

    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public long getMeanPartitionSize() {
        return this.meanPartitionSize;
    }

    public long getPartitionsCount() {
        return this.partitionsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeEstimate that = (SizeEstimate)o;
        return this.meanPartitionSize == that.meanPartitionSize && this.partitionsCount == that.partitionsCount && Objects.equals(this.rangeStart, that.rangeStart) && Objects.equals(this.rangeEnd, that.rangeEnd);
    }

    public int hashCode() {
        return Objects.hash(this.rangeStart, this.rangeEnd, this.meanPartitionSize, this.partitionsCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rangeStart", (Object)this.rangeStart).add("rangeEnd", (Object)this.rangeEnd).add("meanPartitionSize", this.meanPartitionSize).add("partitionsCount", this.partitionsCount).toString();
    }
}

