/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra.util;

import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.spi.ColumnHandle;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import io.airlift.slice.Slice;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class CassandraCqlUtils {
    private static final String[] KEYWORDS = new String[]{"ADD", "ALL", "ALLOW", "ALTER", "AND", "APPLY", "ASC", "ASCII", "AUTHORIZE", "BATCH", "BEGIN", "BIGINT", "BLOB", "BOOLEAN", "BY", "CLUSTERING", "COLUMNFAMILY", "COMPACT", "COUNT", "COUNTER", "CREATE", "DECIMAL", "DELETE", "DESC", "DOUBLE", "DROP", "FILTERING", "FLOAT", "FROM", "GRANT", "IN", "INDEX", "INET", "INSERT", "INT", "INTO", "KEY", "KEYSPACE", "KEYSPACES", "LIMIT", "LIST", "MAP", "MODIFY", "NORECURSIVE", "NOSUPERUSER", "OF", "ON", "ORDER", "PASSWORD", "PERMISSION", "PERMISSIONS", "PRIMARY", "RENAME", "REVOKE", "SCHEMA", "SELECT", "SET", "STORAGE", "SUPERUSER", "TABLE", "TEXT", "TIMESTAMP", "TIMEUUID", "TO", "TOKEN", "TRUNCATE", "TTL", "TYPE", "UNLOGGED", "UPDATE", "USE", "USER", "USERS", "USING", "UUID", "VALUES", "VARCHAR", "VARINT", "WHERE", "WITH", "WRITETIME"};
    private static final Set<String> keywords = new HashSet<String>(Arrays.asList(KEYWORDS));
    public static final String EMPTY_COLUMN_NAME = "__empty__";

    private CassandraCqlUtils() {
    }

    public static String validSchemaName(String identifier) {
        return CassandraCqlUtils.validIdentifier(identifier);
    }

    public static String validTableName(String identifier) {
        return CassandraCqlUtils.validIdentifier(identifier);
    }

    public static String validColumnName(String identifier) {
        if (identifier.isEmpty() || identifier.equals(EMPTY_COLUMN_NAME)) {
            return "\"\"";
        }
        return CassandraCqlUtils.validIdentifier(identifier);
    }

    private static String validIdentifier(String identifier) {
        if (!identifier.equals(identifier.toLowerCase(Locale.ENGLISH))) {
            return CassandraCqlUtils.quoteIdentifier(identifier);
        }
        if (keywords.contains(identifier.toUpperCase(Locale.ENGLISH))) {
            return CassandraCqlUtils.quoteIdentifier(identifier);
        }
        return identifier;
    }

    private static String quoteIdentifier(String identifier) {
        return '\"' + identifier + '\"';
    }

    public static String quoteStringLiteral(String string) {
        return "'" + string.replace("'", "''") + "'";
    }

    public static String quoteStringLiteralForJson(String string) {
        return '\"' + new String(JsonStringEncoder.getInstance().quoteAsUTF8(string)) + '\"';
    }

    public static void appendSelectColumns(StringBuilder stringBuilder, List<? extends ColumnHandle> columns) {
        CassandraCqlUtils.appendSelectColumns(stringBuilder, columns, true);
    }

    private static void appendSelectColumns(StringBuilder stringBuilder, List<? extends ColumnHandle> columns, boolean first) {
        for (ColumnHandle columnHandle : columns) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(CassandraCqlUtils.validColumnName(((CassandraColumnHandle)columnHandle).getName()));
        }
    }

    public static String cqlNameToSqlName(String name) {
        if (name.isEmpty()) {
            return EMPTY_COLUMN_NAME;
        }
        return name;
    }

    public static String sqlNameToCqlName(String name) {
        if (name.equals(EMPTY_COLUMN_NAME)) {
            return "";
        }
        return name;
    }

    public static Select.Selection select(List<CassandraColumnHandle> columns) {
        Select.Selection selection = QueryBuilder.select();
        for (CassandraColumnHandle column : columns) {
            selection.column(CassandraCqlUtils.validColumnName(column.getName()));
        }
        return selection;
    }

    public static Select selectFrom(CassandraTableHandle tableHandle, List<CassandraColumnHandle> columns) {
        return CassandraCqlUtils.from(CassandraCqlUtils.select(columns), tableHandle);
    }

    public static Select from(Select.Selection selection, CassandraTableHandle tableHandle) {
        String schema = CassandraCqlUtils.validSchemaName(tableHandle.getSchemaName());
        String table = CassandraCqlUtils.validTableName(tableHandle.getTableName());
        return selection.from(schema, table);
    }

    public static Select selectDistinctFrom(CassandraTableHandle tableHandle, List<CassandraColumnHandle> columns) {
        return CassandraCqlUtils.from(CassandraCqlUtils.select(columns).distinct(), tableHandle);
    }

    public static Select selectCountAllFrom(CassandraTableHandle tableHandle) {
        String schema = CassandraCqlUtils.validSchemaName(tableHandle.getSchemaName());
        String table = CassandraCqlUtils.validTableName(tableHandle.getTableName());
        return QueryBuilder.select().countAll().from(schema, table);
    }

    public static String cqlValue(String value, CassandraType cassandraType) {
        switch (cassandraType) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return CassandraCqlUtils.quoteStringLiteral(value);
            }
            case INET: {
                return CassandraCqlUtils.quoteStringLiteral(value.substring(1));
            }
        }
        return value;
    }

    public static String toCQLCompatibleString(Object value) {
        if (value instanceof Slice) {
            return ((Slice)value).toStringUtf8();
        }
        return value.toString();
    }
}

