/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class BaseJdbcConfig {
    private String connectionUrl;
    private String connectionUser;
    private String connectionPassword;
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);

    @NotNull
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="connection-url")
    public BaseJdbcConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    @Config(value="connection-user")
    public BaseJdbcConfig setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
        return this;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    @Config(value="connection-password")
    @ConfigSecuritySensitive
    public BaseJdbcConfig setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="case-insensitive-name-matching")
    public BaseJdbcConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="case-insensitive-name-matching.cache-ttl")
    public BaseJdbcConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }
}

