/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.AnnotationUtils;
import com.facebook.airlift.event.client.EventDataType;
import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventFieldMetadata;
import com.facebook.airlift.event.client.EventType;
import com.facebook.airlift.event.client.TypeParameterUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class EventTypeMetadata<T> {
    private final Class<T> eventClass;
    private final String typeName;
    private final EventFieldMetadata uuidField;
    private final EventFieldMetadata timestampField;
    private final EventFieldMetadata hostField;
    private final SortedMap<String, EventFieldMetadata> fields;
    private final List<String> errors;

    public static Set<EventTypeMetadata<?>> getValidEventTypeMetaDataSet(Class<?> ... eventClasses) {
        ImmutableSet.Builder set = ImmutableSet.builder();
        for (Class<?> eventClass : eventClasses) {
            set.add(EventTypeMetadata.getValidEventTypeMetadata(eventClass));
        }
        return set.build();
    }

    public static <T> EventTypeMetadata<T> getValidEventTypeMetadata(Class<T> eventClass) {
        EventTypeMetadata<T> metadata = EventTypeMetadata.getEventTypeMetadata(eventClass);
        if (!metadata.getErrors().isEmpty()) {
            String errors = Joiner.on((char)'\n').join(metadata.getErrors());
            throw new IllegalArgumentException(String.format("Invalid event class [%s]:%n%s", eventClass.getName(), errors));
        }
        return metadata;
    }

    public static <T> EventTypeMetadata<T> getEventTypeMetadata(Class<T> eventClass) {
        return new EventTypeMetadata<T>(eventClass, new ArrayList<String>(), new HashMap(), false);
    }

    public static <T> EventTypeMetadata<T> getEventTypeMetadataNested(Class<T> eventClass) {
        return new EventTypeMetadata<T>(eventClass, new ArrayList<String>(), new HashMap(), true);
    }

    private EventTypeMetadata(Class<T> eventClass, List<String> errors, Map<Class<?>, EventTypeMetadata<?>> metadataClasses, boolean nestedEvent) {
        Objects.requireNonNull(eventClass, "eventClass is null");
        Objects.requireNonNull(errors, "errors is null");
        Objects.requireNonNull(metadataClasses, "metadataClasses is null");
        Preconditions.checkState((!metadataClasses.containsKey(eventClass) ? 1 : 0) != 0, (Object)"metadataClasses contains eventClass");
        this.eventClass = eventClass;
        this.errors = errors;
        metadataClasses.put(eventClass, this);
        this.typeName = this.extractTypeName(eventClass, nestedEvent);
        ArrayListMultimap specialFields = ArrayListMultimap.create();
        TreeMap<String, EventFieldMetadata> fields = new TreeMap<String, EventFieldMetadata>();
        for (Method method : AnnotationUtils.findAnnotatedMethods(eventClass, EventField.class)) {
            if (method.getParameterTypes().length != 0) {
                this.addMethodError("does not have zero parameters", method, new Object[0]);
                continue;
            }
            method.setAccessible(true);
            Class<Object> dataType = method.getReturnType();
            Optional<Object> containerType = Optional.empty();
            if (EventTypeMetadata.isIterable(dataType)) {
                dataType = this.extractIterableType(method);
                containerType = Optional.of(EventFieldMetadata.ContainerType.ITERABLE);
            } else if (EventTypeMetadata.isMap(dataType)) {
                dataType = this.extractMapType(method, Map.class);
                containerType = Optional.of(EventFieldMetadata.ContainerType.MAP);
            } else if (EventTypeMetadata.isMultimap(dataType)) {
                dataType = this.extractMapType(method, Multimap.class);
                containerType = Optional.of(EventFieldMetadata.ContainerType.MULTIMAP);
            }
            if (dataType == null) continue;
            Optional<Object> eventDataType = Optional.empty();
            Optional<EventTypeMetadata<?>> nestedType = Optional.empty();
            if (EventTypeMetadata.isNestedEvent(dataType)) {
                nestedType = Optional.of(this.getNestedEventTypeMetadata(dataType, metadataClasses));
            } else {
                eventDataType = Optional.ofNullable(EventDataType.getEventDataType(dataType));
                if (!eventDataType.isPresent()) {
                    Object typeSource = containerType.isPresent() ? containerType.get() : "return";
                    this.addMethodError("%s type [%s] is not supported", method, typeSource, dataType);
                    continue;
                }
            }
            EventField eventField = method.getAnnotation(EventField.class);
            String fieldName = eventField.value();
            if (eventField.fieldMapping() != EventField.EventFieldMapping.DATA) {
                if (containerType.isPresent()) {
                    this.addMethodError("non-DATA fieldMapping (%s) not allowed for %s", method, new Object[]{eventField.fieldMapping(), containerType.get()});
                    continue;
                }
                if (nestedEvent) {
                    this.addMethodError("non-DATA fieldMapping (%s) not allowed for nested event", method, new Object[]{eventField.fieldMapping()});
                    continue;
                }
                if (!fieldName.isEmpty()) {
                    this.addMethodError("has a value and non-DATA fieldMapping (%s)", method, new Object[]{eventField.fieldMapping()});
                    continue;
                }
                fieldName = eventField.fieldMapping().getFieldName();
            } else {
                if (fieldName.isEmpty()) {
                    fieldName = EventTypeMetadata.extractNameFromGetter(method);
                }
                if (!EventTypeMetadata.isValidFieldName(fieldName)) {
                    this.addMethodError("Field name is invalid [%s]", method, fieldName);
                    continue;
                }
                if (fields.containsKey(fieldName)) {
                    this.addClassError("Multiple methods are annotated for @X field [%s]", fieldName);
                    continue;
                }
            }
            EventFieldMetadata eventFieldMetadata = new EventFieldMetadata(fieldName, method, eventDataType, nestedType, containerType);
            if (eventField.fieldMapping() == EventField.EventFieldMapping.DATA) {
                fields.put(fieldName, eventFieldMetadata);
                continue;
            }
            specialFields.put((Object)eventField.fieldMapping(), (Object)eventFieldMetadata);
        }
        this.findInvalidMethods(eventClass);
        for (Map.Entry entry : specialFields.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            this.addClassError("Multiple methods are annotated for @X(fieldMapping=%s)", entry.getValue());
        }
        this.uuidField = (EventFieldMetadata)Iterables.getFirst((Iterable)specialFields.get((Object)EventField.EventFieldMapping.UUID), null);
        this.timestampField = (EventFieldMetadata)Iterables.getFirst((Iterable)specialFields.get((Object)EventField.EventFieldMapping.TIMESTAMP), null);
        this.hostField = (EventFieldMetadata)Iterables.getFirst((Iterable)specialFields.get((Object)EventField.EventFieldMapping.HOST), null);
        this.fields = ImmutableSortedMap.copyOf(fields);
        if (this.getErrors().isEmpty() && this.fields.isEmpty()) {
            this.addClassError("does not have any @X annotations", new Object[0]);
        }
    }

    private String extractTypeName(Class<T> eventClass, boolean nestedEvent) {
        EventType typeAnnotation = eventClass.getAnnotation(EventType.class);
        if (typeAnnotation == null) {
            this.addClassError("is not annotated with @%s", EventType.class.getSimpleName());
            return null;
        }
        String typeName = typeAnnotation.value();
        if (nestedEvent && typeName.isEmpty()) {
            return eventClass.getSimpleName();
        }
        if (typeName.isEmpty()) {
            this.addClassError("does not specify an event name", new Object[0]);
        } else if (!EventTypeMetadata.isValidEventName(typeName)) {
            this.addClassError("Event name is invalid [%s]", typeName);
        }
        return typeName;
    }

    private Class<?> extractIterableType(Method method) {
        Type[] types = TypeParameterUtils.getTypeParameters(Iterable.class, method.getGenericReturnType());
        if (types == null || types.length != 1) {
            this.addMethodError("Unable to get type parameter for iterable [%s]", method, method.getGenericReturnType());
            return null;
        }
        Type type = types[0];
        if (!(type instanceof Class)) {
            this.addMethodError("Iterable type parameter [%s] must be an exact type", method, type);
            return null;
        }
        if (EventTypeMetadata.isIterable((Class)type)) {
            this.addMethodError("Iterable of iterable is not supported", method, new Object[0]);
            return null;
        }
        return (Class)type;
    }

    private Class<?> extractMapType(Method method, Class<?> mapClass) {
        String className = mapClass.getSimpleName();
        Type[] types = TypeParameterUtils.getTypeParameters(mapClass, method.getGenericReturnType());
        if (types == null || types.length != 2) {
            this.addMethodError("Unable to get type parameter for %s [%s]", method, className, method.getGenericReturnType());
            return null;
        }
        Type keyType = types[0];
        Type valueType = types[1];
        if (!(keyType instanceof Class)) {
            this.addMethodError("%s key type parameter [%s] must be an exact type", method, className, keyType);
            return null;
        }
        if (!(valueType instanceof Class)) {
            this.addMethodError("%s value type parameter [%s] must be an exact type", method, className, valueType);
            return null;
        }
        if (!EventTypeMetadata.isString((Class)keyType)) {
            this.addMethodError("%s key type parameter [%s] must be a String", method, className, keyType);
        }
        if (EventTypeMetadata.isIterable((Class)valueType)) {
            this.addMethodError("%s value type parameter [%s] cannot be iterable", method, className, valueType);
            return null;
        }
        return (Class)valueType;
    }

    private EventTypeMetadata<?> getNestedEventTypeMetadata(Class<?> eventClass, Map<Class<?>, EventTypeMetadata<?>> metadataClasses) {
        EventTypeMetadata<?> metadata = metadataClasses.get(eventClass);
        if (metadata != null) {
            return metadata;
        }
        return new EventTypeMetadata(eventClass, this.errors, metadataClasses, true);
    }

    private void findInvalidMethods(Class<T> eventClass) {
        for (Class<T> clazz = eventClass; clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(EventField.class)) continue;
                if (!Modifier.isPublic(method.getModifiers())) {
                    this.addMethodError("is not public", method, new Object[0]);
                }
                if (!Modifier.isStatic(method.getModifiers())) continue;
                this.addMethodError("is static", method, new Object[0]);
            }
        }
    }

    private static String extractNameFromGetter(Method method) {
        String name = method.getName();
        if (name.length() > 3 && name.startsWith("get")) {
            return EventTypeMetadata.lowerCaseFirstCharacter(name.substring(3));
        }
        if (name.length() > 2 && name.startsWith("is")) {
            return EventTypeMetadata.lowerCaseFirstCharacter(name.substring(2));
        }
        return name;
    }

    private static String lowerCaseFirstCharacter(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    private static boolean isString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    private static boolean isIterable(Class<?> type) {
        return Iterable.class.isAssignableFrom(type);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    private static boolean isMultimap(Class<?> type) {
        return Multimap.class.isAssignableFrom(type);
    }

    private static boolean isNestedEvent(Class<?> type) {
        return type.isAnnotationPresent(EventType.class);
    }

    private static boolean isValidFieldName(String name) {
        return name.matches("[a-z][A-Za-z0-9]*");
    }

    private static boolean isValidEventName(String name) {
        return name.matches("[A-Z][A-Za-z0-9]*");
    }

    List<String> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    public Class<T> getEventClass() {
        return this.eventClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public EventFieldMetadata getUuidField() {
        return this.uuidField;
    }

    public EventFieldMetadata getTimestampField() {
        return this.timestampField;
    }

    public EventFieldMetadata getHostField() {
        return this.hostField;
    }

    public List<EventFieldMetadata> getFields() {
        return ImmutableList.copyOf(this.fields.values());
    }

    public EventFieldMetadata getField(String fieldName) {
        return (EventFieldMetadata)this.fields.get(fieldName);
    }

    public void addMethodError(String format, Method method, Object ... args) {
        String prefix = String.format("@X method [%s] ", method.toGenericString());
        this.addClassError(prefix + format, args);
    }

    public void addClassError(String format, Object ... args) {
        String message = String.format(format, args);
        message = String.format("Event class [%s] %s", this.eventClass, message);
        message = message.replace("@X", EventField.class.getSimpleName());
        this.errors.add(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTypeMetadata that = (EventTypeMetadata)o;
        return !(this.eventClass != null ? !this.eventClass.equals(that.eventClass) : that.eventClass != null);
    }

    public int hashCode() {
        return this.eventClass != null ? this.eventClass.hashCode() : 0;
    }
}

