/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixException;
import org.apache.helix.InstanceType;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ConfigScope;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.util.StringTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigAccessor {
    private static Logger LOG = LoggerFactory.getLogger(ConfigAccessor.class);
    private static final StringTemplate template = new StringTemplate();
    private final ZkClient zkClient;

    public ConfigAccessor(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    @Deprecated
    public String get(ConfigScope scope, String key) {
        Map<String, String> map = this.get(scope, Arrays.asList(key));
        return map.get(key);
    }

    @Deprecated
    public Map<String, String> get(ConfigScope scope, List<String> keys) {
        HashMap<String, String> map;
        block4: {
            ZNRecord record;
            String[] splits;
            block5: {
                if (scope == null || scope.getScope() == null) {
                    LOG.error("Scope can't be null");
                    return null;
                }
                map = new HashMap<String, String>();
                String clusterName = scope.getClusterName();
                if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
                    throw new HelixException("cluster " + clusterName + " is not setup yet");
                }
                String scopeStr = scope.getScopeStr();
                splits = scopeStr.split("\\|");
                record = (ZNRecord)this.zkClient.readData(splits[0], true);
                if (record == null) break block4;
                if (splits.length != 1) break block5;
                for (String key : keys) {
                    if (!record.getSimpleFields().containsKey(key)) continue;
                    map.put(key, record.getSimpleField(key));
                }
                break block4;
            }
            if (splits.length != 2 || record.getMapField(splits[1]) == null) break block4;
            for (String key : keys) {
                if (!record.getMapField(splits[1]).containsKey(key)) continue;
                map.put(key, record.getMapField(splits[1]).get(key));
            }
        }
        return map;
    }

    public String get(HelixConfigScope scope, String key) {
        Map<String, String> map = this.get(scope, Arrays.asList(key));
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public Map<String, String> get(HelixConfigScope scope, List<String> keys) {
        if (scope == null || scope.getType() == null || !scope.isFullKey()) {
            LOG.error("fail to get configs. invalid config scope. scope: " + scope + ", keys: " + keys);
            return null;
        }
        ZNRecord record = this.getConfigZnRecord(scope);
        if (record == null) {
            LOG.warn("No config found at " + scope.getZkPath());
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String mapKey = scope.getMapKey();
        if (mapKey == null) {
            for (String key : keys) {
                if (!record.getSimpleFields().containsKey(key)) continue;
                map.put(key, record.getSimpleField(key));
            }
        } else {
            Map<String, String> configMap = record.getMapField(mapKey);
            if (configMap == null) {
                LOG.warn("No map-field found in " + record + " using mapKey: " + mapKey);
                return null;
            }
            for (String key : keys) {
                if (!record.getMapField(mapKey).containsKey(key)) continue;
                map.put(key, record.getMapField(mapKey).get(key));
            }
        }
        return map;
    }

    private ZNRecord getConfigZnRecord(HelixConfigScope scope) {
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to get configs. cluster " + clusterName + " is not setup yet");
        }
        return (ZNRecord)this.zkClient.readData(scope.getZkPath(), true);
    }

    @Deprecated
    public void set(ConfigScope scope, String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.set(scope, map);
    }

    @Deprecated
    public void set(ConfigScope scope, Map<String, String> keyValueMap) {
        String scopeStr;
        if (scope == null || scope.getScope() == null) {
            LOG.error("Scope can't be null");
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("cluster: " + clusterName + " is NOT setup.");
        }
        if (scope.getScope() == HelixConfigScope.ConfigScopeProperty.PARTICIPANT) {
            scopeStr = scope.getScopeStr();
            String instanceName = scopeStr.substring(scopeStr.lastIndexOf(47) + 1);
            if (!ZKUtil.isInstanceSetup(this.zkClient, scope.getClusterName(), instanceName, InstanceType.PARTICIPANT)) {
                throw new HelixException("instance: " + instanceName + " is NOT setup in cluster: " + clusterName);
            }
        }
        scopeStr = scope.getScopeStr();
        String[] splits = scopeStr.split("\\|");
        String id = splits[0].substring(splits[0].lastIndexOf(47) + 1);
        ZNRecord update = new ZNRecord(id);
        if (splits.length == 1) {
            for (String key : keyValueMap.keySet()) {
                String value = keyValueMap.get(key);
                update.setSimpleField(key, value);
            }
        } else if (splits.length == 2) {
            if (update.getMapField(splits[1]) == null) {
                update.setMapField(splits[1], new TreeMap<String, String>());
            }
            for (String key : keyValueMap.keySet()) {
                String value = keyValueMap.get(key);
                update.getMapField(splits[1]).put(key, value);
            }
        }
        ZKUtil.createOrMerge(this.zkClient, splits[0], update, true, true);
    }

    public void set(HelixConfigScope scope, String key, String value) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(key, value);
        this.set(scope, map);
    }

    public void set(HelixConfigScope scope, Map<String, String> keyValueMap) {
        if (scope == null || scope.getType() == null || !scope.isFullKey()) {
            LOG.error("fail to set config. invalid config scope. scope: {}", (Object)scope);
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to set config. cluster: " + clusterName + " is NOT setup.");
        }
        if (scope.getType() == HelixConfigScope.ConfigScopeProperty.PARTICIPANT && !ZKUtil.isInstanceSetup(this.zkClient, scope.getClusterName(), scope.getParticipantName(), InstanceType.PARTICIPANT)) {
            throw new HelixException("fail to set config. instance: " + scope.getParticipantName() + " is NOT setup in cluster: " + clusterName);
        }
        String mapKey = scope.getMapKey();
        String zkPath = scope.getZkPath();
        String id = zkPath.substring(zkPath.lastIndexOf(47) + 1);
        ZNRecord update = new ZNRecord(id);
        if (mapKey == null) {
            update.getSimpleFields().putAll(keyValueMap);
        } else {
            update.setMapField(mapKey, keyValueMap);
        }
        ZKUtil.createOrMerge(this.zkClient, zkPath, update, true, true);
    }

    @Deprecated
    public void remove(ConfigScope scope, String key) {
        this.remove(scope, Arrays.asList(key));
    }

    @Deprecated
    public void remove(ConfigScope scope, List<String> keys) {
        if (scope == null || scope.getScope() == null) {
            LOG.error("Scope can't be null");
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String scopeStr = scope.getScopeStr();
        String[] splits = scopeStr.split("\\|");
        String id = splits[0].substring(splits[0].lastIndexOf(47) + 1);
        ZNRecord update = new ZNRecord(id);
        if (splits.length == 1) {
            for (String key : keys) {
                update.setSimpleField(key, "");
            }
        } else if (splits.length == 2) {
            if (update.getMapField(splits[1]) == null) {
                update.setMapField(splits[1], new TreeMap<String, String>());
            }
            for (String key : keys) {
                update.getMapField(splits[1]).put(key, "");
            }
        }
        ZKUtil.subtract(this.zkClient, splits[0], update);
    }

    public void remove(HelixConfigScope scope, String key) {
        this.remove(scope, Arrays.asList(key));
    }

    public void remove(HelixConfigScope scope, List<String> keys) {
        if (scope == null || scope.getType() == null || !scope.isFullKey()) {
            LOG.error("fail to remove. invalid scope: " + scope + ", keys: " + keys);
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to remove. cluster " + clusterName + " is not setup yet");
        }
        String zkPath = scope.getZkPath();
        String mapKey = scope.getMapKey();
        String id = zkPath.substring(zkPath.lastIndexOf(47) + 1);
        ZNRecord update = new ZNRecord(id);
        if (mapKey == null) {
            for (String key : keys) {
                update.setSimpleField(key, "");
            }
        } else {
            update.setMapField(mapKey, new TreeMap<String, String>());
            for (String key : keys) {
                update.getMapField(mapKey).put(key, "");
            }
        }
        ZKUtil.subtract(this.zkClient, zkPath, update);
    }

    public void remove(HelixConfigScope scope, ZNRecord recordToRemove) {
        if (scope == null || scope.getType() == null || !scope.isFullKey()) {
            LOG.error("fail to remove. invalid scope: " + scope);
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to remove. cluster " + clusterName + " is not setup yet");
        }
        String zkPath = scope.getZkPath();
        ZKUtil.subtract(this.zkClient, zkPath, recordToRemove);
    }

    @Deprecated
    public List<String> getKeys(HelixConfigScope.ConfigScopeProperty type, String clusterName, String ... keys) {
        if (type == null || clusterName == null) {
            LOG.error("clusterName|scope can't be null");
            return Collections.emptyList();
        }
        try {
            if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
                LOG.error("cluster " + clusterName + " is not setup yet");
                return Collections.emptyList();
            }
            Object[] args = new String[1 + keys.length];
            args[0] = clusterName;
            System.arraycopy(keys, 0, args, 1, keys.length);
            String scopeStr = template.instantiate(type, (String[])args);
            String[] splits = scopeStr.split("\\|");
            List<String> retKeys = null;
            if (splits.length == 1) {
                retKeys = this.zkClient.getChildren(splits[0]);
            } else {
                ZNRecord record = (ZNRecord)this.zkClient.readData(splits[0]);
                if (splits[1].startsWith("SIMPLEKEYS")) {
                    retKeys = new ArrayList<String>(record.getSimpleFields().keySet());
                } else if (splits[1].startsWith("MAPKEYS")) {
                    retKeys = new ArrayList<String>(record.getMapFields().keySet());
                } else if (splits[1].startsWith("MAPMAPKEYS")) {
                    retKeys = new ArrayList<String>(record.getMapField(splits[2]).keySet());
                }
            }
            if (retKeys == null) {
                LOG.error("Invalid scope: " + (Object)((Object)type) + " or keys: " + Arrays.toString(args));
                return Collections.emptyList();
            }
            Collections.sort(retKeys);
            return retKeys;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public List<String> getKeys(HelixConfigScope scope) {
        if (scope == null || scope.getType() == null) {
            LOG.error("fail to getKeys. invalid config scope: " + scope);
            return null;
        }
        if (!ZKUtil.isClusterSetup(scope.getClusterName(), this.zkClient)) {
            LOG.error("fail to getKeys. cluster " + scope.getClusterName() + " is not setup yet");
            return Collections.emptyList();
        }
        String zkPath = scope.getZkPath();
        String mapKey = scope.getMapKey();
        List<String> retKeys = null;
        if (scope.isFullKey()) {
            ZNRecord record = (ZNRecord)this.zkClient.readData(zkPath);
            retKeys = mapKey == null ? new ArrayList<String>(record.getSimpleFields().keySet()) : new ArrayList<String>(record.getMapField(mapKey).keySet());
        } else if (scope.getType() == HelixConfigScope.ConfigScopeProperty.PARTITION) {
            ZNRecord record = (ZNRecord)this.zkClient.readData(zkPath);
            retKeys = new ArrayList<String>(record.getMapFields().keySet());
        } else {
            retKeys = this.zkClient.getChildren(zkPath);
        }
        if (retKeys != null) {
            Collections.sort(retKeys);
        }
        return retKeys;
    }

    public ClusterConfig getClusterConfig(String clusterName) {
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to get config. cluster: " + clusterName + " is NOT setup.");
        }
        HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(clusterName).build();
        ZNRecord record = this.getConfigZnRecord(scope);
        if (record == null) {
            LOG.warn("No config found at " + scope.getZkPath());
            return null;
        }
        return new ClusterConfig(record);
    }

    public void setClusterConfig(String clusterName, ClusterConfig clusterConfig) {
        this.updateClusterConfig(clusterName, clusterConfig, true);
    }

    public void updateClusterConfig(String clusterName, ClusterConfig clusterConfig) {
        this.updateClusterConfig(clusterName, clusterConfig, false);
    }

    private void updateClusterConfig(String clusterName, ClusterConfig clusterConfig, boolean overwrite) {
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to update config. cluster: " + clusterName + " is NOT setup.");
        }
        HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(clusterName).build();
        String zkPath = scope.getZkPath();
        if (overwrite) {
            ZKUtil.createOrReplace(this.zkClient, zkPath, clusterConfig.getRecord(), true);
        } else {
            ZKUtil.createOrUpdate(this.zkClient, zkPath, clusterConfig.getRecord(), true, true);
        }
    }

    public ResourceConfig getResourceConfig(String clusterName, String resourceName) {
        HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterName).forResource(resourceName).build();
        ZNRecord record = this.getConfigZnRecord(scope);
        if (record == null) {
            LOG.warn("No config found at " + scope.getZkPath());
            return null;
        }
        return new ResourceConfig(record);
    }

    public void setResourceConfig(String clusterName, String resourceName, ResourceConfig resourceConfig) {
        this.updateResourceConfig(clusterName, resourceName, resourceConfig, true);
    }

    public void updateResourceConfig(String clusterName, String resourceName, ResourceConfig resourceConfig) {
        this.updateResourceConfig(clusterName, resourceName, resourceConfig, false);
    }

    private void updateResourceConfig(String clusterName, String resourceName, ResourceConfig resourceConfig, boolean overwrite) {
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to setup config. cluster: " + clusterName + " is NOT setup.");
        }
        HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterName).forResource(resourceName).build();
        String zkPath = scope.getZkPath();
        if (overwrite) {
            ZKUtil.createOrReplace(this.zkClient, zkPath, resourceConfig.getRecord(), true);
        } else {
            ZKUtil.createOrUpdate(this.zkClient, zkPath, resourceConfig.getRecord(), true, true);
        }
    }

    public InstanceConfig getInstanceConfig(String clusterName, String instanceName) {
        if (!ZKUtil.isInstanceSetup(this.zkClient, clusterName, instanceName, InstanceType.PARTICIPANT)) {
            throw new HelixException("fail to get config. instance: " + instanceName + " is NOT setup in cluster: " + clusterName);
        }
        HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.PARTICIPANT).forCluster(clusterName).forParticipant(instanceName).build();
        ZNRecord record = this.getConfigZnRecord(scope);
        if (record == null) {
            LOG.warn("No config found at " + scope.getZkPath());
            return null;
        }
        return new InstanceConfig(record);
    }

    public void setInstanceConfig(String clusterName, String instanceName, InstanceConfig instanceConfig) {
        this.updateInstanceConfig(clusterName, instanceName, instanceConfig, true);
    }

    public void updateInstanceConfig(String clusterName, String instanceName, InstanceConfig instanceConfig) {
        this.updateInstanceConfig(clusterName, instanceName, instanceConfig, false);
    }

    private void updateInstanceConfig(String clusterName, String instanceName, InstanceConfig instanceConfig, boolean overwrite) {
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("fail to setup config. cluster: " + clusterName + " is NOT setup.");
        }
        HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.PARTICIPANT).forCluster(clusterName).forParticipant(instanceName).build();
        String zkPath = scope.getZkPath();
        if (overwrite) {
            ZKUtil.createOrReplace(this.zkClient, zkPath, instanceConfig.getRecord(), true);
        } else {
            ZKUtil.createOrUpdate(this.zkClient, zkPath, instanceConfig.getRecord(), true, true);
        }
    }

    static {
        template.addEntry(HelixConfigScope.ConfigScopeProperty.CLUSTER, 1, "/{clusterName}/CONFIGS/CLUSTER");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.CLUSTER, 2, "/{clusterName}/CONFIGS/CLUSTER/{clusterName}|SIMPLEKEYS");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, 1, "/{clusterName}/CONFIGS/PARTICIPANT");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, 2, "/{clusterName}/CONFIGS/PARTICIPANT/{participantName}|SIMPLEKEYS");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.RESOURCE, 1, "/{clusterName}/CONFIGS/RESOURCE");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.RESOURCE, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|SIMPLEKEYS");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTITION, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|MAPKEYS");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTITION, 3, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|MAPMAPKEYS|{partitionName}");
    }
}

