/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataCache {
    private static Logger LOG = LoggerFactory.getLogger((String)AbstractDataCache.class.getName());
    private String _eventId = "NO_ID";

    public String getEventId() {
        return this._eventId;
    }

    public void setEventId(String eventId) {
        this._eventId = eventId;
    }

    protected <T extends HelixProperty> Map<PropertyKey, T> refreshProperties(HelixDataAccessor accessor, List<PropertyKey> reloadKeys, List<PropertyKey> cachedKeys, Map<PropertyKey, T> cachedPropertyMap) {
        HashMap refreshedPropertyMap = Maps.newHashMap();
        List<HelixProperty.Stat> stats = accessor.getPropertyStats(cachedKeys);
        for (int i = 0; i < cachedKeys.size(); ++i) {
            PropertyKey key = cachedKeys.get(i);
            HelixProperty.Stat stat = stats.get(i);
            if (stat != null) {
                HelixProperty property = (HelixProperty)cachedPropertyMap.get(key);
                if (property != null && property.getBucketSize() == 0 && property.getStat().equals(stat)) {
                    refreshedPropertyMap.put(key, property);
                    continue;
                }
                reloadKeys.add(key);
                continue;
            }
            LOG.warn("stat is null for key: " + key);
            reloadKeys.add(key);
        }
        List reloadedProperty = accessor.getProperty(reloadKeys, true);
        Iterator<PropertyKey> csKeyIter = reloadKeys.iterator();
        for (HelixProperty property : reloadedProperty) {
            PropertyKey key = csKeyIter.next();
            if (property != null) {
                refreshedPropertyMap.put(key, property);
                continue;
            }
            LOG.warn("znode is null for key: " + key);
        }
        return refreshedPropertyMap;
    }
}

