/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.ExternalViewCache;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicClusterDataCache {
    private static Logger LOG = LoggerFactory.getLogger((String)BasicClusterDataCache.class.getName());
    protected Map<String, LiveInstance> _liveInstanceMap;
    protected Map<String, InstanceConfig> _instanceConfigMap;
    protected ExternalViewCache _externalViewCache;
    protected String _clusterName;
    protected Map<HelixConstants.ChangeType, Boolean> _propertyDataChangedMap = new ConcurrentHashMap<HelixConstants.ChangeType, Boolean>();

    public BasicClusterDataCache(String clusterName) {
        this._liveInstanceMap = new HashMap<String, LiveInstance>();
        this._instanceConfigMap = new HashMap<String, InstanceConfig>();
        this._externalViewCache = new ExternalViewCache(clusterName);
        this._clusterName = clusterName;
        this.requireFullRefresh();
    }

    public void refresh(HelixDataAccessor accessor) {
        long start;
        LOG.info("START: BasicClusterDataCache.refresh() for cluster " + this._clusterName);
        long startTime = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.EXTERNAL_VIEW).booleanValue()) {
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.EXTERNAL_VIEW, false);
            this._externalViewCache.refresh(accessor);
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.LIVE_INSTANCE).booleanValue()) {
            start = System.currentTimeMillis();
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.LIVE_INSTANCE, false);
            this._liveInstanceMap = accessor.getChildValuesMap(keyBuilder.liveInstances(), true);
            LOG.info("Reload LiveInstances: " + this._liveInstanceMap.keySet() + ". Takes " + (System.currentTimeMillis() - start) + " ms");
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.INSTANCE_CONFIG).booleanValue()) {
            start = System.currentTimeMillis();
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.INSTANCE_CONFIG, false);
            this._instanceConfigMap = accessor.getChildValuesMap(keyBuilder.instanceConfigs(), true);
            LOG.info("Reload InstanceConfig: " + this._instanceConfigMap.keySet() + ". Takes " + (System.currentTimeMillis() - start) + " ms");
        }
        long endTime = System.currentTimeMillis();
        LOG.info("END: BasicClusterDataCache.refresh() for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
        if (LOG.isDebugEnabled()) {
            LOG.debug("LiveInstances: " + this._liveInstanceMap);
            LOG.debug("ExternalViews: " + this._externalViewCache.getExternalViewMap().keySet());
            LOG.debug("InstanceConfigs: " + this._instanceConfigMap);
        }
    }

    public Map<String, ExternalView> getExternalViews() {
        return this._externalViewCache.getExternalViewMap();
    }

    public Map<String, LiveInstance> getLiveInstances() {
        return Collections.unmodifiableMap(this._liveInstanceMap);
    }

    public Map<String, InstanceConfig> getInstanceConfigMap() {
        return Collections.unmodifiableMap(this._instanceConfigMap);
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType, String pathChanged) {
        this.notifyDataChange(changeType);
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType) {
        this._propertyDataChangedMap.put(changeType, true);
    }

    public synchronized void clearCache(HelixConstants.ChangeType changeType) {
        switch (changeType) {
            case LIVE_INSTANCE: {
                this._liveInstanceMap.clear();
                break;
            }
            case INSTANCE_CONFIG: {
                this._instanceConfigMap.clear();
                break;
            }
            case EXTERNAL_VIEW: {
                this._externalViewCache.clear();
                break;
            }
        }
    }

    public void requireFullRefresh() {
        for (HelixConstants.ChangeType type : HelixConstants.ChangeType.values()) {
            this._propertyDataChangedMap.put(type, Boolean.TRUE);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("liveInstaceMap:" + this._liveInstanceMap).append("\n");
        sb.append("externalViewMap:" + this._externalViewCache.getExternalViewMap()).append("\n");
        sb.append("instanceConfigMap:" + this._instanceConfigMap).append("\n");
        return sb.toString();
    }
}

