/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.model.IdealState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdealStateCache
extends AbstractDataCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)IdealStateCache.class.getName());
    private Map<String, IdealState> _idealStateMap;
    private Map<String, IdealState> _idealStateCache;
    private String _clusterName;

    public IdealStateCache(String clusterName) {
        this._clusterName = clusterName;
        this._idealStateMap = Collections.emptyMap();
        this._idealStateCache = Collections.emptyMap();
    }

    public void refresh(HelixDataAccessor accessor) {
        long startTime = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashSet<PropertyKey> currentIdealStateKeys = new HashSet<PropertyKey>();
        for (String idealState : accessor.getChildNames(keyBuilder.idealStates())) {
            currentIdealStateKeys.add(keyBuilder.idealStates(idealState));
        }
        HashSet<PropertyKey> cachedKeys = new HashSet<PropertyKey>();
        HashMap cachedIdealStateMap = Maps.newHashMap();
        for (String idealState : this._idealStateCache.keySet()) {
            cachedKeys.add(keyBuilder.idealStates(idealState));
            cachedIdealStateMap.put(keyBuilder.idealStates(idealState), this._idealStateCache.get(idealState));
        }
        cachedKeys.retainAll(currentIdealStateKeys);
        HashSet reloadKeys = new HashSet(currentIdealStateKeys);
        reloadKeys.removeAll(cachedKeys);
        Map updatedMap = this.refreshProperties(accessor, new LinkedList<PropertyKey>(reloadKeys), new ArrayList<PropertyKey>(cachedKeys), cachedIdealStateMap);
        HashMap newIdealStateMap = Maps.newHashMap();
        for (IdealState idealState : updatedMap.values()) {
            newIdealStateMap.put(idealState.getResourceName(), idealState);
        }
        this._idealStateCache = new HashMap<String, IdealState>(newIdealStateMap);
        this._idealStateMap = new HashMap<String, IdealState>(newIdealStateMap);
        long endTime = System.currentTimeMillis();
        LogUtil.logInfo(LOG, this.getEventId(), "Refresh " + this._idealStateMap.size() + " idealStates for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
    }

    public Map<String, IdealState> getIdealStateMap() {
        return Collections.unmodifiableMap(this._idealStateMap);
    }

    public void clear() {
        this._idealStateMap.clear();
        this._idealStateCache.clear();
    }

    public void setIdealStates(List<IdealState> idealStates) {
        HashMap<String, IdealState> idealStateMap = new HashMap<String, IdealState>();
        for (IdealState idealState : idealStates) {
            idealStateMap.put(idealState.getId(), idealState);
        }
        this._idealStateMap = idealStateMap;
    }
}

