/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMessagesCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)InstanceMessagesCache.class.getName());
    private Map<String, Map<String, Message>> _messageMap;
    private Map<String, Map<String, Message>> _messageCache = Maps.newHashMap();
    private String _clusterName;

    public InstanceMessagesCache(String clusterName) {
        this._clusterName = clusterName;
    }

    public boolean refresh(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        LOG.info("START: InstanceMessagesCache.refresh()");
        long startTime = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashMap<String, HashMap> msgMap = new HashMap<String, HashMap>();
        LinkedList newMessageKeys = Lists.newLinkedList();
        long purgeSum = 0L;
        for (String instanceName : liveInstanceMap.keySet()) {
            HashMap cachedMap = this._messageCache.get(instanceName);
            if (cachedMap == null) {
                cachedMap = Maps.newHashMap();
                this._messageCache.put(instanceName, cachedMap);
            }
            msgMap.put(instanceName, cachedMap);
            HashSet messageNames = Sets.newHashSet(accessor.getChildNames(keyBuilder.messages(instanceName)));
            long purgeStart = System.currentTimeMillis();
            Iterator cachedNamesIter = cachedMap.keySet().iterator();
            while (cachedNamesIter.hasNext()) {
                String messageName = (String)cachedNamesIter.next();
                if (messageNames.contains(messageName)) continue;
                cachedNamesIter.remove();
            }
            long purgeEnd = System.currentTimeMillis();
            purgeSum += purgeEnd - purgeStart;
            for (String messageName : messageNames) {
                if (cachedMap.containsKey(messageName)) continue;
                newMessageKeys.add(keyBuilder.message(instanceName, messageName));
            }
        }
        if (newMessageKeys.size() > 0) {
            List newMessages = accessor.getProperty(newMessageKeys, true);
            for (Message message : newMessages) {
                if (message == null) continue;
                Map<String, Message> cachedMap = this._messageCache.get(message.getTgtName());
                cachedMap.put(message.getId(), message);
            }
        }
        this._messageMap = Collections.unmodifiableMap(msgMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message purge took: " + purgeSum);
            LOG.debug("# of Messages read from ZooKeeper " + newMessageKeys.size() + ". took " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        return true;
    }

    public void updateRelayMessages(Map<String, LiveInstance> liveInstanceMap, Map<String, Map<String, Map<String, CurrentState>>> currentStateMap) {
        ArrayList<Message> relayMessages = new ArrayList<Message>();
        for (String instance : this._messageMap.keySet()) {
            Map<String, Message> instanceMessages = this._messageMap.get(instance);
            Map<String, Map<String, CurrentState>> instanceCurrentStateMap = currentStateMap.get(instance);
            if (instanceCurrentStateMap == null) continue;
            for (Message message : instanceMessages.values()) {
                if (!message.hasRelayMessages()) continue;
                String sessionId = message.getTgtSessionId();
                String resourceName = message.getResourceName();
                String partitionName = message.getPartitionName();
                String targetState = message.getToState();
                String instanceSessionId = liveInstanceMap.get(instance).getSessionId();
                if (!instanceSessionId.equals(sessionId)) {
                    LOG.info("Instance SessionId does not match, ignore relay messages attached to message " + message.getId());
                    continue;
                }
                Map<String, CurrentState> sessionCurrentStateMap = instanceCurrentStateMap.get(sessionId);
                if (sessionCurrentStateMap == null) {
                    LOG.info("No sessionCurrentStateMap found, ignore relay messages attached to message " + message.getId());
                    continue;
                }
                CurrentState currentState = sessionCurrentStateMap.get(resourceName);
                if (currentState == null || !targetState.equals(currentState.getState(partitionName))) {
                    LOG.info("CurrentState " + currentState + " do not match the target state of the message, ignore relay messages attached to message " + message.getId());
                    continue;
                }
                long transitionCompleteTime = currentState.getEndTime(partitionName);
                for (Message relayMsg : message.getRelayMessages().values()) {
                    relayMsg.setRelayTime(transitionCompleteTime);
                    relayMessages.add(relayMsg);
                }
            }
        }
        for (Message message : relayMessages) {
            String instance = message.getTgtName();
            Map<String, Message> instanceMessages = this._messageMap.get(instance);
            if (instanceMessages == null) {
                instanceMessages = new HashMap<String, Message>();
                this._messageMap.put(instance, instanceMessages);
            }
            instanceMessages.put(message.getId(), message);
        }
    }

    public Map<String, Message> getMessages(String instanceName) {
        Map<String, Message> map = this._messageMap.get(instanceName);
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public void cacheMessages(List<Message> messages) {
        for (Message message : messages) {
            Map<Object, Object> instMsgMap;
            String instanceName = message.getTgtName();
            if (this._messageCache.containsKey(instanceName)) {
                instMsgMap = this._messageCache.get(instanceName);
            } else {
                instMsgMap = Maps.newHashMap();
                this._messageCache.put(instanceName, (Map<String, Message>)instMsgMap);
            }
            instMsgMap.put(message.getId(), message);
        }
    }

    public String toString() {
        return "InstanceMessagesCache{_messageMap=" + this._messageMap + ", _messageCache=" + this._messageCache + ", _clusterName='" + this._clusterName + '\'' + '}';
    }
}

