/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDataCache
extends AbstractDataCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)TaskDataCache.class.getName());
    private static final String NAME = "NAME";
    private String _clusterName;
    private Map<String, JobConfig> _jobConfigMap = new HashMap<String, JobConfig>();
    private Map<String, WorkflowConfig> _workflowConfigMap = new HashMap<String, WorkflowConfig>();
    private Map<String, ZNRecord> _contextMap = new HashMap<String, ZNRecord>();
    private final AssignableInstanceManager _assignableInstanceManager = new AssignableInstanceManager();

    public TaskDataCache(String clusterName) {
        this._clusterName = clusterName;
    }

    public synchronized boolean refresh(HelixDataAccessor accessor, Map<String, ResourceConfig> resourceConfigMap) {
        this.refreshJobContexts(accessor);
        this._workflowConfigMap.clear();
        this._jobConfigMap.clear();
        for (Map.Entry<String, ResourceConfig> entry : resourceConfigMap.entrySet()) {
            if (entry.getValue().getRecord().getSimpleFields().containsKey(WorkflowConfig.WorkflowConfigProperty.Dag.name())) {
                this._workflowConfigMap.put(entry.getKey(), new WorkflowConfig(entry.getValue()));
                continue;
            }
            if (!entry.getValue().getRecord().getSimpleFields().containsKey(WorkflowConfig.WorkflowConfigProperty.WorkflowID.name())) continue;
            this._jobConfigMap.put(entry.getKey(), new JobConfig(entry.getValue()));
        }
        return true;
    }

    private void refreshJobContexts(HelixDataAccessor accessor) {
        long start = System.currentTimeMillis();
        this._contextMap.clear();
        if (this._clusterName == null) {
            return;
        }
        String path = String.format("/%s/%s%s", this._clusterName, PropertyType.PROPERTYSTORE.name(), "/TaskRebalancer");
        ArrayList<String> contextPaths = new ArrayList<String>();
        List<String> childNames = accessor.getBaseDataAccessor().getChildNames(path, 0);
        if (childNames == null) {
            return;
        }
        for (String context : childNames) {
            contextPaths.add(Joiner.on((String)"/").join((Object)path, (Object)context, new Object[]{"Context"}));
        }
        List<ZNRecord> contexts = accessor.getBaseDataAccessor().get(contextPaths, null, 0);
        for (int i = 0; i < contexts.size(); ++i) {
            ZNRecord context = contexts.get(i);
            if (context != null && context.getSimpleField(NAME) != null) {
                this._contextMap.put(context.getSimpleField(NAME), context);
                continue;
            }
            this._contextMap.put(childNames.get(i), context);
            LogUtil.logDebug(LOG, this.getEventId(), String.format("Context for %s is null or miss the context NAME!", childNames.get(i)));
        }
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this.getEventId(), "# of workflow/job context read from zk: " + this._contextMap.size() + ". Take " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public Map<String, JobConfig> getJobConfigMap() {
        return this._jobConfigMap;
    }

    public JobConfig getJobConfig(String resource) {
        return this._jobConfigMap.get(resource);
    }

    public Map<String, WorkflowConfig> getWorkflowConfigMap() {
        return this._workflowConfigMap;
    }

    public WorkflowConfig getWorkflowConfig(String resource) {
        return this._workflowConfigMap.get(resource);
    }

    public JobContext getJobContext(String resourceName) {
        if (this._contextMap.containsKey(resourceName) && this._contextMap.get(resourceName) != null) {
            return new JobContext(this._contextMap.get(resourceName));
        }
        return null;
    }

    public WorkflowContext getWorkflowContext(String resourceName) {
        if (this._contextMap.containsKey(resourceName) && this._contextMap.get(resourceName) != null) {
            return new WorkflowContext(this._contextMap.get(resourceName));
        }
        return null;
    }

    public void updateJobContext(String resourceName, JobContext jobContext, HelixDataAccessor accessor) {
        this.updateContext(resourceName, jobContext.getRecord(), accessor);
    }

    public void updateWorkflowContext(String resourceName, WorkflowContext workflowContext, HelixDataAccessor accessor) {
        this.updateContext(resourceName, workflowContext.getRecord(), accessor);
    }

    private void updateContext(String resourceName, ZNRecord record, HelixDataAccessor accessor) {
        String path = String.format("/%s/%s%s/%s/%s", this._clusterName, PropertyType.PROPERTYSTORE.name(), "/TaskRebalancer", resourceName, "Context");
        accessor.getBaseDataAccessor().set(path, record, AccessOption.PERSISTENT);
        this._contextMap.put(resourceName, record);
    }

    public Map<String, ZNRecord> getContexts() {
        return this._contextMap;
    }

    public AssignableInstanceManager getAssignableInstanceManager() {
        return this._assignableInstanceManager;
    }

    public String toString() {
        return "TaskDataCache{_jobConfigMap=" + this._jobConfigMap + ", _workflowConfigMap=" + this._workflowConfigMap + ", _contextMap=" + this._contextMap + ", _clusterName='" + this._clusterName + '\'' + '}';
    }
}

