/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRebalancer
extends AbstractRebalancer {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRebalancer.class);

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        ResourceAssignment partitionMapping = cache.getCachedResourceAssignment(resource.getResourceName());
        if (partitionMapping != null) {
            return partitionMapping;
        }
        LOG.info("Computing BestPossibleMapping for " + resource.getResourceName());
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            Map<String, String> idealStateMap = idealState.getInstanceStateMap(partition.getPartitionName());
            Map<String, String> bestStateForPartition = this.computeCustomizedBestStateForPartition(cache, stateModelDef, idealStateMap, currentStateMap, disabledInstancesForPartition, idealState.isEnabled());
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        cache.setCachedResourceAssignment(resource.getResourceName(), partitionMapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Processing resource: %s", resource.getResourceName()));
            LOG.debug(String.format("Final Mapping of resource : %s", partitionMapping.toString()));
        }
        return partitionMapping;
    }

    private Map<String, String> computeCustomizedBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, Map<String, String> idealStateMap, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition, boolean isResourceEnabled) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (!(idealStateMap != null && idealStateMap.containsKey(instance) || disabledInstancesForPartition.contains(instance))) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name()) || isResourceEnabled && !disabledInstancesForPartition.contains(instance)) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (idealStateMap == null) {
            return instanceStateMap;
        }
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        for (String instance : idealStateMap.keySet()) {
            boolean enabled;
            boolean notInErrorState = currentStateMap == null || currentStateMap.get(instance) == null || !currentStateMap.get(instance).equals(HelixDefinedState.ERROR.toString());
            boolean bl = enabled = !disabledInstancesForPartition.contains(instance) && isResourceEnabled;
            if (!liveInstancesMap.containsKey(instance) || !notInErrorState || !enabled) continue;
            instanceStateMap.put(instance, idealStateMap.get(instance));
        }
        return instanceStateMap;
    }
}

