/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.SemiAutoRebalancer;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceRebalancer
extends SemiAutoRebalancer {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceRebalancer.class);

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        LOG.info(String.format("Start computing ideal state for resource %s in maintenance mode.", resourceName));
        Map<Partition, Map<String, String>> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName);
        if (currentStateMap == null || currentStateMap.size() == 0) {
            LOG.warn(String.format("No new partition will be assigned for %s in maintenance mode", resourceName));
            currentIdealState.setPreferenceLists(Collections.EMPTY_MAP);
            return currentIdealState;
        }
        for (Partition partition : currentStateMap.keySet()) {
            Map<String, String> stateMap = currentStateMap.get(partition);
            ArrayList<String> preferenceList = new ArrayList<String>(stateMap.keySet());
            Collections.sort(preferenceList, new AbstractRebalancer.PreferenceListNodeComparator(stateMap, clusterData.getStateModelDef(currentIdealState.getStateModelDefRef()), Collections.emptyList()));
            currentIdealState.setPreferenceList(partition.getPartitionName(), preferenceList);
        }
        LOG.info(String.format("End computing ideal state for resource %s in maintenance mode.", resourceName));
        return currentIdealState;
    }
}

