/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.rebalancer.constraint.AbstractRebalanceHardConstraint;
import org.apache.helix.api.rebalancer.constraint.AbstractRebalanceSoftConstraint;
import org.apache.helix.api.rebalancer.constraint.dataprovider.CapacityProvider;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.controller.rebalancer.constraint.PartitionWeightAwareEvennessConstraint;
import org.apache.helix.controller.rebalancer.strategy.AbstractEvenDistributionRebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.CrushRebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CardDealer;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CardDealingAdjustmentAlgorithmV2;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintRebalanceStrategy
extends AbstractEvenDistributionRebalanceStrategy {
    private static final Logger _logger = LoggerFactory.getLogger(ConstraintRebalanceStrategy.class);
    private static final int MIN_INSTANCE_WEIGHT = 1;
    private final RebalanceStrategy _baseStrategy = new CrushRebalanceStrategy();
    private final List<AbstractRebalanceHardConstraint> _hardConstraints = new ArrayList<AbstractRebalanceHardConstraint>();
    private final List<AbstractRebalanceSoftConstraint> _softConstraints = new ArrayList<AbstractRebalanceSoftConstraint>();
    private List<String> _partitions;
    private int _maxPerNode;
    private LinkedHashMap<String, Integer> _states;
    private List<String> _orderedStateList;

    @Override
    protected RebalanceStrategy getBaseRebalanceStrategy() {
        return this._baseStrategy;
    }

    public ConstraintRebalanceStrategy(List<? extends AbstractRebalanceHardConstraint> hardConstraints, List<? extends AbstractRebalanceSoftConstraint> softConstraints) {
        if (hardConstraints != null) {
            this._hardConstraints.addAll(hardConstraints);
        }
        if (softConstraints != null) {
            this._softConstraints.addAll(softConstraints);
        }
        if (this._hardConstraints.isEmpty() && this._softConstraints.isEmpty()) {
            throw new HelixException("Failed to construct ConstraintRebalanceStrategy since no constraint is provided.");
        }
    }

    public ConstraintRebalanceStrategy() {
        _logger.debug("Init constraint rebalance strategy using the default even constraint.");
        PartitionWeightAwareEvennessConstraint defaultConstraint = new PartitionWeightAwareEvennessConstraint(new PartitionWeightProvider(){

            @Override
            public int getPartitionWeight(String resource, String partition) {
                return 1;
            }
        }, new CapacityProvider(){

            @Override
            public int getParticipantCapacity(String participant) {
                return 1;
            }

            @Override
            public int getParticipantUsage(String participant) {
                return 0;
            }
        });
        this._softConstraints.add(defaultConstraint);
    }

    @Override
    protected CardDealer getCardDealingAlgorithm(Topology topology) {
        return new CardDealingAdjustmentAlgorithmV2(topology, this._replica, CardDealingAdjustmentAlgorithmV2.Mode.EVENNESS);
    }

    @Override
    public void init(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states, int maximumPerNode) {
        this._resourceName = resourceName;
        this._partitions = new ArrayList<String>(partitions);
        this._maxPerNode = maximumPerNode;
        this._states = states;
        this._orderedStateList = new ArrayList<String>();
        for (String state : states.keySet()) {
            for (int i = 0; i < states.get(state); ++i) {
                this._orderedStateList.add(state);
            }
        }
    }

    @Override
    public ZNRecord computePartitionAssignment(List<String> allNodes, List<String> liveNodes, Map<String, Map<String, String>> currentMapping, ClusterDataCache clusterData) throws HelixException {
        HashMap<String, Integer> instanceWeightRecords = new HashMap<String, Integer>();
        for (InstanceConfig instanceConfig : clusterData.getInstanceConfigMap().values()) {
            if (instanceConfig.getWeight() == -1) continue;
            instanceWeightRecords.put(instanceConfig.getInstanceName(), instanceConfig.getWeight());
        }
        ArrayList<String> candidates = new ArrayList<String>(allNodes);
        candidates.retainAll(clusterData.getInstanceConfigMap().keySet());
        HashMap<String, List<String>> preferenceList = new HashMap<String, List<String>>();
        HashMap<String, Map<String, String>> idealStateMap = new HashMap<String, Map<String, String>>();
        for (String partition : this._partitions) {
            if (currentMapping.containsKey(partition)) {
                Map<String, String> partitionMapping = currentMapping.get(partition);
                if ((partitionMapping = this.validateStateMap(partitionMapping)) != null) {
                    _logger.debug("The provided preferred partition assignment meets state model requirements. Skip rebalance.");
                    preferenceList.put(partition, new ArrayList<String>(partitionMapping.keySet()));
                    idealStateMap.put(partition, partitionMapping);
                    this.updateConstraints(partition, partitionMapping);
                    continue;
                }
            }
            List<String> assignment = this.computeSinglePartitionAssignment(partition, candidates, liveNodes, clusterData);
            Collections.shuffle(assignment, new Random(String.format("%s.%s", this._resourceName, partition).hashCode()));
            HashMap<String, String> stateMap = new HashMap<String, String>();
            for (int i = 0; i < assignment.size(); ++i) {
                stateMap.put(assignment.get(i), this._orderedStateList.get(i));
            }
            idealStateMap.put(partition, stateMap);
            preferenceList.put(partition, assignment);
            this.updateConstraints(partition, stateMap);
        }
        for (String instanceName : instanceWeightRecords.keySet()) {
            clusterData.getInstanceConfigMap().get(instanceName).setWeight((Integer)instanceWeightRecords.get(instanceName));
        }
        ZNRecord result = new ZNRecord(this._resourceName);
        result.setListFields(preferenceList);
        result.setMapFields(idealStateMap);
        return result;
    }

    private Map<String, String> validateStateMap(Map<String, String> actualMapping) {
        HashMap<String, String> filteredStateMapping = new HashMap<String, String>();
        HashMap<String, Integer> tmpStates = new HashMap<String, Integer>(this._states);
        for (String partition : actualMapping.keySet()) {
            int count;
            String state = actualMapping.get(partition);
            if (!tmpStates.containsKey(state) || (count = ((Integer)tmpStates.get(state)).intValue()) <= 0) continue;
            filteredStateMapping.put(partition, state);
            tmpStates.put(state, count - 1);
        }
        for (String state : tmpStates.keySet()) {
            if ((Integer)tmpStates.get(state) <= 0) continue;
            return null;
        }
        return filteredStateMapping;
    }

    private List<String> computeSinglePartitionAssignment(String partitionName, List<String> allNodes, List<String> liveNodes, ClusterDataCache clusterData) {
        ArrayList<String> qualifiedNodes = new ArrayList<String>(allNodes);
        for (AbstractRebalanceHardConstraint hardConstraint : this._hardConstraints) {
            Map<String, String[]> proposedAssignment = Collections.singletonMap(partitionName, qualifiedNodes.toArray(new String[qualifiedNodes.size()]));
            boolean[] validateResults = hardConstraint.isValid(this._resourceName, proposedAssignment).get(partitionName);
            for (int i = 0; i < validateResults.length; ++i) {
                if (validateResults[i]) continue;
                qualifiedNodes.remove(proposedAssignment.get(partitionName)[i]);
            }
        }
        int[] instancePriority = new int[qualifiedNodes.size()];
        Map<String, String[]> proposedAssignment = Collections.singletonMap(partitionName, qualifiedNodes.toArray(new String[qualifiedNodes.size()]));
        for (AbstractRebalanceSoftConstraint softConstraint : this._softConstraints) {
            if (softConstraint.getConstraintWeight() == 0) continue;
            int[] evaluateResults = softConstraint.evaluate(this._resourceName, proposedAssignment).get(partitionName);
            for (int i = 0; i < evaluateResults.length; ++i) {
                int n = i;
                instancePriority[n] = instancePriority[n] + evaluateResults[i] * softConstraint.getConstraintWeight();
            }
        }
        int baseline = Integer.MAX_VALUE;
        for (int priority : instancePriority) {
            if (baseline <= priority) continue;
            baseline = priority;
        }
        for (int i = 0; i < instancePriority.length; ++i) {
            clusterData.getInstanceConfigMap().get(qualifiedNodes.get(i)).setWeight(instancePriority[i] - baseline + 1);
        }
        super.init(this._resourceName, Collections.singletonList(partitionName), this._states, this._maxPerNode);
        ZNRecord partitionAssignment = super.computePartitionAssignment(qualifiedNodes, liveNodes, Collections.EMPTY_MAP, clusterData);
        return partitionAssignment.getListFields().get(partitionName);
    }

    private void updateConstraints(String partition, Map<String, String> pendingAssignment) {
        if (pendingAssignment.isEmpty()) {
            _logger.warn("No pending assignment needs to update. Skip constraint update.");
            return;
        }
        ResourcesStateMap tempStateMap = new ResourcesStateMap();
        tempStateMap.setState(this._resourceName, new Partition(partition), pendingAssignment);
        _logger.debug("Update constraints with pending assignment: " + tempStateMap.toString());
        for (AbstractRebalanceHardConstraint hardConstraint : this._hardConstraints) {
            hardConstraint.updateAssignment(tempStateMap);
        }
        for (AbstractRebalanceSoftConstraint softConstraint : this._softConstraints) {
            softConstraint.updateAssignment(tempStateMap);
        }
    }
}

