/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy.crushMapping;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.helix.util.JenkinsHash;

class ConsistentHashSelector {
    private static final int DEFAULT_TOKENS_PER_INSTANCE = 1000;
    private static final JenkinsHash _hashFunction = new JenkinsHash();
    private final SortedMap<Long, String> circle = new TreeMap<Long, String>();
    protected int instanceSize = 0;

    public ConsistentHashSelector(Set<String> instances) {
        for (String instance : instances) {
            this.add(instance, 1000L);
            ++this.instanceSize;
        }
    }

    private void add(String instance, long numberOfReplicas) {
        int instanceHashCode = instance.hashCode();
        int i = 0;
        while ((long)i < numberOfReplicas) {
            this.circle.put(_hashFunction.hash(instanceHashCode, i), instance);
            ++i;
        }
    }

    public Iterable<String> getCircle(long data) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = _hashFunction.hash(data);
        return this.circle.tailMap(hash).values();
    }
}

