/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy.crushMapping;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.ConsistentHashSelector;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.util.JenkinsHash;

public class ConsistentHashingAdjustmentAlgorithm {
    private static final int MAX_SELETOR_CACHE_SIZE = 1000;
    private static final int SELETOR_CACHE_EXPIRE = 3;
    private JenkinsHash _hashFunction;
    private ConsistentHashSelector _selector;
    Set<String> _activeInstances = new HashSet<String>();
    private Map<String, String> _faultZoneMap = new HashMap<String, String>();
    private Map<String, Set<String>> _faultZonePartitionMap = new HashMap<String, Set<String>>();
    private static final LoadingCache<Set<String>, ConsistentHashSelector> _selectorCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(3L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Set<String>, ConsistentHashSelector>(){

        public ConsistentHashSelector load(Set<String> allInstances) {
            return new ConsistentHashSelector(allInstances);
        }
    });

    public ConsistentHashingAdjustmentAlgorithm(Topology topology, Collection<String> activeInstances) throws ExecutionException {
        this._hashFunction = new JenkinsHash();
        HashSet<String> allInstances = new HashSet<String>();
        for (Node zone : topology.getFaultZones()) {
            for (Node instance : Topology.getAllLeafNodes(zone)) {
                allInstances.add(instance.getName());
                this._faultZoneMap.put(instance.getName(), zone.getName());
                if (this._faultZonePartitionMap.containsKey(zone.getName())) continue;
                this._faultZonePartitionMap.put(zone.getName(), new HashSet());
            }
        }
        this._selector = (ConsistentHashSelector)_selectorCache.get(allInstances);
        this._activeInstances.addAll(activeInstances);
    }

    public boolean computeMapping(Map<String, List<String>> nodeToPartitionMap, int randomSeed) {
        if (this._activeInstances.isEmpty()) {
            return false;
        }
        HashSet<String> inactiveInstances = new HashSet<String>();
        HashMap<String, Integer> toBeReassigned = new HashMap<String, Integer>();
        Iterator<String> nodeIter = nodeToPartitionMap.keySet().iterator();
        while (nodeIter.hasNext()) {
            String instance = nodeIter.next();
            List<String> partitions = nodeToPartitionMap.get(instance);
            if (!this._activeInstances.contains(instance)) {
                inactiveInstances.add(instance);
                this.addToReAssignPartition(toBeReassigned, partitions);
                partitions.clear();
                nodeIter.remove();
                continue;
            }
            this._faultZonePartitionMap.get(this._faultZoneMap.get(instance)).addAll(partitions);
        }
        for (String partition : new ArrayList(toBeReassigned.keySet())) {
            int remainReplicas = (Integer)toBeReassigned.get(partition);
            HashSet<String> conflictInstance = new HashSet<String>();
            block2: for (int index = 0; index < (Integer)toBeReassigned.get(partition); ++index) {
                Iterable<String> sortedInstances = this._selector.getCircle(this._hashFunction.hash(randomSeed, partition.hashCode(), index));
                Iterator<String> instanceItr = sortedInstances.iterator();
                while (instanceItr.hasNext() && conflictInstance.size() + inactiveInstances.size() != this._selector.instanceSize) {
                    String instance = instanceItr.next();
                    if (!this._activeInstances.contains(instance)) {
                        inactiveInstances.add(instance);
                    }
                    if (inactiveInstances.contains(instance) || conflictInstance.contains(instance)) continue;
                    Set<String> faultZonePartitions = this._faultZonePartitionMap.get(this._faultZoneMap.get(instance));
                    if (faultZonePartitions.contains(partition)) {
                        conflictInstance.add(instance);
                        continue;
                    }
                    if (!nodeToPartitionMap.containsKey(instance)) {
                        nodeToPartitionMap.put(instance, new ArrayList());
                    }
                    nodeToPartitionMap.get(instance).add(partition);
                    faultZonePartitions.add(partition);
                    --remainReplicas;
                    continue block2;
                }
            }
            if (remainReplicas == 0) {
                toBeReassigned.remove(partition);
                continue;
            }
            toBeReassigned.put(partition, remainReplicas);
        }
        return toBeReassigned.isEmpty();
    }

    private void addToReAssignPartition(Map<String, Integer> toBeReassigned, List<String> partitions) {
        for (String partition : partitions) {
            if (!toBeReassigned.containsKey(partition)) {
                toBeReassigned.put(partition, 1);
                continue;
            }
            toBeReassigned.put(partition, toBeReassigned.get(partition) + 1);
        }
    }
}

