/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.common.caches.CurrentStateCache;
import org.apache.helix.common.caches.IdealStateCache;
import org.apache.helix.common.caches.InstanceMessagesCache;
import org.apache.helix.common.caches.TaskDataCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterDataCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClusterDataCache.class.getName());
    private ClusterConfig _clusterConfig;
    private Map<String, LiveInstance> _liveInstanceMap;
    private Map<String, LiveInstance> _liveInstanceCacheMap;
    private Map<String, StateModelDefinition> _stateModelDefMap;
    private Map<String, InstanceConfig> _instanceConfigMap;
    private Map<String, InstanceConfig> _instanceConfigCacheMap;
    private Map<String, Long> _instanceOfflineTimeMap;
    private Map<String, ResourceConfig> _resourceConfigMap;
    private Map<String, ResourceConfig> _resourceConfigCacheMap;
    private Map<String, ClusterConstraints> _constraintMap;
    private Map<String, Map<String, String>> _idealStateRuleMap;
    private Map<String, Map<String, Long>> _missingTopStateMap = new HashMap<String, Map<String, Long>>();
    private Map<String, Map<String, String>> _lastTopStateLocationMap = new HashMap<String, Map<String, String>>();
    private Map<String, ExternalView> _targetExternalViewMap = new HashMap<String, ExternalView>();
    private Map<String, ExternalView> _externalViewMap = new HashMap<String, ExternalView>();
    private Map<String, Map<String, Set<String>>> _disabledInstanceForPartitionMap = new HashMap<String, Map<String, Set<String>>>();
    private Set<String> _disabledInstanceSet = new HashSet<String>();
    private String _eventId = "NO_ID";
    private IdealStateCache _idealStateCache;
    private CurrentStateCache _currentStateCache;
    private TaskDataCache _taskDataCache;
    private InstanceMessagesCache _instanceMessagesCache;
    private Map<String, ResourceAssignment> _resourceAssignmentCache = new HashMap<String, ResourceAssignment>();
    private Map<String, ZNRecord> _idealMappingCache = new HashMap<String, ZNRecord>();
    private Map<HelixConstants.ChangeType, Boolean> _propertyDataChangedMap;
    private Map<String, Integer> _participantActiveTaskCount = new HashMap<String, Integer>();
    private ExecutorService _asyncTasksThreadPool;
    boolean _updateInstanceOfflineTime = true;
    boolean _isTaskCache;
    boolean _isMaintenanceModeEnabled;
    private String _clusterName;
    private boolean _existsLiveInstanceOrCurrentStateChange = false;
    private boolean _existsClusterConfigChange = false;
    private boolean _existsInstanceChange = false;

    public ClusterDataCache() {
        this(null);
    }

    public ClusterDataCache(String clusterName) {
        this._propertyDataChangedMap = new ConcurrentHashMap<HelixConstants.ChangeType, Boolean>();
        for (HelixConstants.ChangeType type : HelixConstants.ChangeType.values()) {
            this._propertyDataChangedMap.put(type, true);
        }
        this._clusterName = clusterName;
        this._idealStateCache = new IdealStateCache(this._clusterName);
        this._currentStateCache = new CurrentStateCache(this._clusterName);
        this._taskDataCache = new TaskDataCache(this._clusterName);
        this._instanceMessagesCache = new InstanceMessagesCache(this._clusterName);
    }

    public synchronized boolean refresh(HelixDataAccessor accessor) {
        long startTime = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.IDEAL_STATE).booleanValue()) {
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.IDEAL_STATE, false);
            this.clearCachedResourceAssignments();
            this._idealStateCache.refresh(accessor);
            LogUtil.logInfo(LOG, this._eventId, "Refresh IdealStates for cluster " + this._clusterName + ", took " + (System.currentTimeMillis() - startTime) + " ms for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.LIVE_INSTANCE).booleanValue()) {
            startTime = System.currentTimeMillis();
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.LIVE_INSTANCE, false);
            this.clearCachedResourceAssignments();
            this._liveInstanceCacheMap = accessor.getChildValuesMap(keyBuilder.liveInstances(), true);
            this._updateInstanceOfflineTime = true;
            LogUtil.logInfo(LOG, this._eventId, "Refresh LiveInstances for cluster " + this._clusterName + ", took " + (System.currentTimeMillis() - startTime) + " ms for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.INSTANCE_CONFIG).booleanValue()) {
            this._existsInstanceChange = true;
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.INSTANCE_CONFIG, false);
            this.clearCachedResourceAssignments();
            this._instanceConfigCacheMap = accessor.getChildValuesMap(keyBuilder.instanceConfigs(), true);
            LogUtil.logInfo(LOG, this._eventId, "Reload InstanceConfig: " + this._instanceConfigCacheMap.keySet() + " for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.RESOURCE_CONFIG).booleanValue()) {
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.RESOURCE_CONFIG, false);
            this.clearCachedResourceAssignments();
            this._resourceConfigCacheMap = accessor.getChildValuesMap(accessor.keyBuilder().resourceConfigs(), true);
            LogUtil.logInfo(LOG, this._eventId, "Reload ResourceConfigs: " + this._resourceConfigCacheMap.keySet() + " for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CURRENT_STATE).booleanValue()) {
            this._existsLiveInstanceOrCurrentStateChange = true;
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.CURRENT_STATE, false);
        }
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CLUSTER_CONFIG).booleanValue()) {
            this._existsClusterConfigChange = true;
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.CLUSTER_CONFIG, false);
        }
        this._liveInstanceMap = new HashMap<String, LiveInstance>(this._liveInstanceCacheMap);
        this._liveInstanceMap = new HashMap<String, LiveInstance>(this._liveInstanceCacheMap);
        this._instanceConfigMap = new ConcurrentHashMap<String, InstanceConfig>(this._instanceConfigCacheMap);
        this._resourceConfigMap = new HashMap<String, ResourceConfig>(this._resourceConfigCacheMap);
        if (this._updateInstanceOfflineTime) {
            this.updateOfflineInstanceHistory(accessor);
        }
        Map stateDefMap = accessor.getChildValuesMap(keyBuilder.stateModelDefs(), true);
        this._stateModelDefMap = new ConcurrentHashMap(stateDefMap);
        this._constraintMap = accessor.getChildValuesMap(keyBuilder.constraints(), true);
        this._clusterConfig = (ClusterConfig)accessor.getProperty(keyBuilder.clusterConfig());
        if (this._isTaskCache) {
            this._taskDataCache.refresh(accessor, this._resourceConfigMap);
            AssignableInstanceManager assignableInstanceManager = this._taskDataCache.getAssignableInstanceManager();
            if (this._existsClusterConfigChange) {
                this._existsClusterConfigChange = false;
                this._existsInstanceChange = false;
                assignableInstanceManager.buildAssignableInstances(this._clusterConfig, this._taskDataCache, this._liveInstanceMap, this._instanceConfigMap);
            } else if (this._existsInstanceChange) {
                this._existsInstanceChange = false;
                assignableInstanceManager.updateAssignableInstances(this._clusterConfig, this._liveInstanceMap, this._instanceConfigMap);
            }
        }
        this._instanceMessagesCache.refresh(accessor, this._liveInstanceMap);
        this._currentStateCache.refresh(accessor, this._liveInstanceMap);
        this._instanceMessagesCache.updateRelayMessages(this._liveInstanceMap, this._currentStateCache.getCurrentStatesMap());
        if (this._clusterConfig != null) {
            this._idealStateRuleMap = this._clusterConfig.getIdealStateRules();
        } else {
            this._idealStateRuleMap = new HashMap<String, Map<String, String>>();
            LogUtil.logWarn(LOG, this._eventId, "Cluster config is null for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
        }
        MaintenanceSignal maintenanceSignal = (MaintenanceSignal)accessor.getProperty(keyBuilder.maintenance());
        this._isMaintenanceModeEnabled = maintenanceSignal != null;
        this.updateDisabledInstances();
        long endTime = System.currentTimeMillis();
        LogUtil.logInfo(LOG, this._eventId, "END: ClusterDataCache.refresh() for cluster " + this.getClusterName() + ", took " + (endTime - startTime) + " ms for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this._eventId, "# of StateModelDefinition read from zk: " + this._stateModelDefMap.size());
            LogUtil.logDebug(LOG, this._eventId, "# of ConstraintMap read from zk: " + this._constraintMap.size());
            LogUtil.logDebug(LOG, this._eventId, "LiveInstances: " + this._liveInstanceMap.keySet());
            for (LiveInstance instance : this._liveInstanceMap.values()) {
                LogUtil.logDebug(LOG, this._eventId, "live instance: " + instance.getInstanceName() + " " + instance.getSessionId());
            }
            LogUtil.logDebug(LOG, this._eventId, "IdealStates: " + this._idealStateCache.getIdealStateMap().keySet());
            LogUtil.logDebug(LOG, this._eventId, "ResourceConfigs: " + this._resourceConfigMap.keySet());
            LogUtil.logDebug(LOG, this._eventId, "InstanceConfigs: " + this._instanceConfigMap.keySet());
            LogUtil.logDebug(LOG, this._eventId, "ClusterConfigs: " + this._clusterConfig);
            LogUtil.logDebug(LOG, this._eventId, "JobContexts: " + this._taskDataCache.getContexts().keySet());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache content: " + this.toString());
        }
        return true;
    }

    private void updateDisabledInstances() {
        this._disabledInstanceForPartitionMap.clear();
        this._disabledInstanceSet.clear();
        for (InstanceConfig config : this._instanceConfigMap.values()) {
            Map<String, List<String>> disabledPartitionMap = config.getDisabledPartitionsMap();
            if (!config.getInstanceEnabled()) {
                this._disabledInstanceSet.add(config.getInstanceName());
            }
            for (String resource : disabledPartitionMap.keySet()) {
                if (!this._disabledInstanceForPartitionMap.containsKey(resource)) {
                    this._disabledInstanceForPartitionMap.put(resource, new HashMap());
                }
                for (String partition : disabledPartitionMap.get(resource)) {
                    if (!this._disabledInstanceForPartitionMap.get(resource).containsKey(partition)) {
                        this._disabledInstanceForPartitionMap.get(resource).put(partition, new HashSet());
                    }
                    this._disabledInstanceForPartitionMap.get(resource).get(partition).add(config.getInstanceName());
                }
            }
        }
        if (this._clusterConfig.getDisabledInstances() != null) {
            this._disabledInstanceSet.addAll(this._clusterConfig.getDisabledInstances().keySet());
        }
    }

    private void updateOfflineInstanceHistory(HelixDataAccessor accessor) {
        ArrayList<String> offlineNodes = new ArrayList<String>(this._instanceConfigMap.keySet());
        offlineNodes.removeAll(this._liveInstanceMap.keySet());
        this._instanceOfflineTimeMap = new HashMap<String, Long>();
        for (String instance : offlineNodes) {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            PropertyKey propertyKey = keyBuilder.participantHistory(instance);
            ParticipantHistory history = (ParticipantHistory)accessor.getProperty(propertyKey);
            if (history == null) {
                history = new ParticipantHistory(instance);
            }
            if (history.getLastOfflineTime() == ParticipantHistory.ONLINE) {
                history.reportOffline();
                if (!accessor.setProperty(propertyKey, history)) {
                    LogUtil.logError(LOG, this._eventId, "Fails to persist participant online history back to ZK!");
                }
            }
            this._instanceOfflineTimeMap.put(instance, history.getLastOfflineTime());
        }
        this._updateInstanceOfflineTime = false;
    }

    public ClusterConfig getClusterConfig() {
        return this._clusterConfig;
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this._clusterConfig = clusterConfig;
    }

    public String getClusterName() {
        return this._clusterConfig != null ? this._clusterConfig.getClusterName() : this._clusterName;
    }

    public Map<String, Long> getInstanceOfflineTimeMap() {
        return this._instanceOfflineTimeMap;
    }

    public Map<String, IdealState> getIdealStates() {
        return this._idealStateCache.getIdealStateMap();
    }

    public synchronized void setIdealStates(List<IdealState> idealStates) {
        this._idealStateCache.setIdealStates(idealStates);
    }

    public Map<String, Map<String, String>> getIdealStateRules() {
        return this._idealStateRuleMap;
    }

    public Map<String, LiveInstance> getLiveInstances() {
        return this._liveInstanceMap;
    }

    public Set<String> getAllInstances() {
        return new HashSet<String>(this._instanceConfigMap.keySet());
    }

    public Set<String> getEnabledLiveInstances() {
        HashSet<String> enabledLiveInstances = new HashSet<String>(this.getLiveInstances().keySet());
        enabledLiveInstances.removeAll(this.getDisabledInstances());
        return enabledLiveInstances;
    }

    public Set<String> getEnabledInstances() {
        HashSet<String> enabledNodes = new HashSet<String>(this.getInstanceConfigMap().keySet());
        enabledNodes.removeAll(this.getDisabledInstances());
        return enabledNodes;
    }

    public Set<String> getEnabledLiveInstancesWithTag(String instanceTag) {
        HashSet<String> enabledLiveInstancesWithTag = new HashSet<String>(this.getLiveInstances().keySet());
        Set<String> instancesWithTag = this.getInstancesWithTag(instanceTag);
        enabledLiveInstancesWithTag.retainAll(instancesWithTag);
        enabledLiveInstancesWithTag.removeAll(this.getDisabledInstances());
        return enabledLiveInstancesWithTag;
    }

    public Set<String> getInstancesWithTag(String instanceTag) {
        HashSet<String> taggedInstances = new HashSet<String>();
        for (String instance : this._instanceConfigMap.keySet()) {
            InstanceConfig instanceConfig = this._instanceConfigMap.get(instance);
            if (instanceConfig == null || !instanceConfig.containsTag(instanceTag)) continue;
            taggedInstances.add(instance);
        }
        return taggedInstances;
    }

    public synchronized void setLiveInstances(List<LiveInstance> liveInstances) {
        HashMap<String, LiveInstance> liveInstanceMap = new HashMap<String, LiveInstance>();
        for (LiveInstance liveInstance : liveInstances) {
            liveInstanceMap.put(liveInstance.getId(), liveInstance);
        }
        this._liveInstanceCacheMap = liveInstanceMap;
        this._updateInstanceOfflineTime = true;
        this._existsInstanceChange = true;
        this._existsLiveInstanceOrCurrentStateChange = true;
    }

    public Map<String, CurrentState> getCurrentState(String instanceName, String clientSessionId) {
        return this._currentStateCache.getCurrentState(instanceName, clientSessionId);
    }

    public Map<String, Message> getMessages(String instanceName) {
        return this._instanceMessagesCache.getMessages(instanceName);
    }

    public void cacheMessages(List<Message> messages) {
        this._instanceMessagesCache.cacheMessages(messages);
    }

    public StateModelDefinition getStateModelDef(String stateModelDefRef) {
        if (stateModelDefRef == null) {
            return null;
        }
        return this._stateModelDefMap.get(stateModelDefRef);
    }

    public Map<String, StateModelDefinition> getStateModelDefMap() {
        return this._stateModelDefMap;
    }

    public IdealState getIdealState(String resourceName) {
        return this._idealStateCache.getIdealStateMap().get(resourceName);
    }

    public Map<String, InstanceConfig> getInstanceConfigMap() {
        return this._instanceConfigMap;
    }

    public void setInstanceConfigMap(Map<String, InstanceConfig> instanceConfigMap) {
        this._instanceConfigMap = instanceConfigMap;
    }

    public Map<String, ResourceConfig> getResourceConfigMap() {
        return this._resourceConfigMap;
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType) {
        this._propertyDataChangedMap.put(changeType, true);
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType, String pathChanged) {
        this.notifyDataChange(changeType);
    }

    public ResourceConfig getResourceConfig(String resource) {
        return this._resourceConfigMap.get(resource);
    }

    public Map<String, JobConfig> getJobConfigMap() {
        return this._taskDataCache.getJobConfigMap();
    }

    public JobConfig getJobConfig(String resource) {
        return this._taskDataCache.getJobConfig(resource);
    }

    public Map<String, WorkflowConfig> getWorkflowConfigMap() {
        return this._taskDataCache.getWorkflowConfigMap();
    }

    public WorkflowConfig getWorkflowConfig(String resource) {
        return this._taskDataCache.getWorkflowConfig(resource);
    }

    public synchronized void setInstanceConfigs(List<InstanceConfig> instanceConfigs) {
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            instanceConfigMap.put(instanceConfig.getId(), instanceConfig);
        }
        this._instanceConfigCacheMap = instanceConfigMap;
    }

    public Set<String> getDisabledInstancesForPartition(String resource, String partition) {
        HashSet<String> disabledInstancesForPartition = new HashSet<String>(this._disabledInstanceSet);
        if (this._disabledInstanceForPartitionMap.containsKey(resource) && this._disabledInstanceForPartitionMap.get(resource).containsKey(partition)) {
            disabledInstancesForPartition.addAll((Collection<String>)this._disabledInstanceForPartitionMap.get(resource).get(partition));
        }
        return disabledInstancesForPartition;
    }

    public Set<String> getDisabledInstances() {
        return Collections.unmodifiableSet(this._disabledInstanceSet);
    }

    public int getReplicas(String resourceName) {
        int replicas = -1;
        Map<String, IdealState> idealStateMap = this._idealStateCache.getIdealStateMap();
        if (idealStateMap.containsKey(resourceName)) {
            String replicasStr = idealStateMap.get(resourceName).getReplicas();
            if (replicasStr != null) {
                if (replicasStr.equals(IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString())) {
                    replicas = this._liveInstanceMap.size();
                } else {
                    try {
                        replicas = Integer.parseInt(replicasStr);
                    }
                    catch (Exception e) {
                        LogUtil.logError(LOG, this._eventId, "invalid replicas string: " + replicasStr + " for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
                    }
                }
            } else {
                LogUtil.logError(LOG, this._eventId, "idealState for resource: " + resourceName + " does NOT have replicas for " + (this._isTaskCache ? "TASK" : "DEFAULT") + "pipeline");
            }
        }
        return replicas;
    }

    public ClusterConstraints getConstraint(ClusterConstraints.ConstraintType type) {
        if (this._constraintMap != null) {
            return this._constraintMap.get(type.toString());
        }
        return null;
    }

    public Map<String, Map<String, Long>> getMissingTopStateMap() {
        return this._missingTopStateMap;
    }

    public Map<String, Map<String, String>> getLastTopStateLocationMap() {
        return this._lastTopStateLocationMap;
    }

    public Integer getParticipantActiveTaskCount(String instance) {
        return this._participantActiveTaskCount.get(instance);
    }

    public void setParticipantActiveTaskCount(String instance, int taskCount) {
        this._participantActiveTaskCount.put(instance, taskCount);
    }

    public void resetActiveTaskCount(CurrentStateOutput currentStateOutput) {
        for (String liveInstance : this.getLiveInstances().keySet()) {
            this._participantActiveTaskCount.put(liveInstance, 0);
        }
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithPendingState("Task", TaskPartitionState.INIT.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithPendingState("Task", TaskPartitionState.RUNNING.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithCurrentState("Task", TaskPartitionState.INIT.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithCurrentState("Task", TaskPartitionState.RUNNING.name()), this._participantActiveTaskCount);
    }

    private void fillActiveTaskCount(Map<String, Integer> additionPartitionMap, Map<String, Integer> partitionMap) {
        for (String participant : additionPartitionMap.keySet()) {
            partitionMap.put(participant, partitionMap.get(participant) + additionPartitionMap.get(participant));
        }
    }

    public JobContext getJobContext(String resourceName) {
        return this._taskDataCache.getJobContext(resourceName);
    }

    public WorkflowContext getWorkflowContext(String resourceName) {
        return this._taskDataCache.getWorkflowContext(resourceName);
    }

    public void updateJobContext(String resourceName, JobContext jobContext, HelixDataAccessor accessor) {
        this._taskDataCache.updateJobContext(resourceName, jobContext, accessor);
    }

    public void updateWorkflowContext(String resourceName, WorkflowContext workflowContext, HelixDataAccessor accessor) {
        this._taskDataCache.updateWorkflowContext(resourceName, workflowContext, accessor);
    }

    public Map<String, ZNRecord> getContexts() {
        return this._taskDataCache.getContexts();
    }

    public AssignableInstanceManager getAssignableInstanceManager() {
        return this._taskDataCache.getAssignableInstanceManager();
    }

    public ExternalView getTargetExternalView(String resourceName) {
        return this._targetExternalViewMap.get(resourceName);
    }

    public void updateTargetExternalView(String resourceName, ExternalView targetExternalView) {
        this._targetExternalViewMap.put(resourceName, targetExternalView);
    }

    public Map<String, ExternalView> getExternalViews() {
        return Collections.unmodifiableMap(this._externalViewMap);
    }

    public void updateExternalViews(List<ExternalView> externalViews) {
        for (ExternalView externalView : externalViews) {
            this._externalViewMap.put(externalView.getResourceName(), externalView);
        }
    }

    public void removeExternalViews(List<String> resourceNames) {
        for (String externalView : resourceNames) {
            this._externalViewMap.remove(externalView);
        }
    }

    public synchronized void requireFullRefresh() {
        for (HelixConstants.ChangeType type : HelixConstants.ChangeType.values()) {
            this._propertyDataChangedMap.put(type, true);
        }
    }

    public ExecutorService getAsyncTasksThreadPool() {
        return this._asyncTasksThreadPool;
    }

    public ResourceAssignment getCachedResourceAssignment(String resource) {
        return this._resourceAssignmentCache.get(resource);
    }

    public Map<String, ResourceAssignment> getCachedResourceAssignments() {
        return Collections.unmodifiableMap(this._resourceAssignmentCache);
    }

    public void setCachedResourceAssignment(String resource, ResourceAssignment resourceAssignment) {
        this._resourceAssignmentCache.put(resource, resourceAssignment);
    }

    public ZNRecord getCachedIdealMapping(String resource) {
        return this._idealMappingCache.get(resource);
    }

    public Map<String, ZNRecord> getCachedIdealMapping() {
        return Collections.unmodifiableMap(this._idealMappingCache);
    }

    public void setCachedIdealMapping(String resource, ZNRecord mapping) {
        this._idealMappingCache.put(resource, mapping);
    }

    public void clearCachedResourceAssignments() {
        this._resourceAssignmentCache.clear();
        this._idealMappingCache.clear();
    }

    public void setAsyncTasksThreadPool(ExecutorService asyncTasksThreadPool) {
        this._asyncTasksThreadPool = asyncTasksThreadPool;
    }

    public void setTaskCache(boolean taskCache) {
        this._isTaskCache = taskCache;
    }

    public boolean isTaskCache() {
        return this._isTaskCache;
    }

    public boolean isMaintenanceModeEnabled() {
        return this._isMaintenanceModeEnabled;
    }

    public void clearMonitoringRecords() {
        this._missingTopStateMap.clear();
        this._lastTopStateLocationMap.clear();
    }

    public String getEventId() {
        return this._eventId;
    }

    public void setEventId(String eventId) {
        this._eventId = eventId;
        this._idealStateCache.setEventId(eventId);
        this._currentStateCache.setEventId(eventId);
        this._taskDataCache.setEventId(eventId);
    }

    public boolean getExistsLiveInstanceOrCurrentStateChange() {
        boolean change = this._existsLiveInstanceOrCurrentStateChange;
        this._existsLiveInstanceOrCurrentStateChange = false;
        return change;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("liveInstaceMap:" + this._liveInstanceMap).append("\n");
        sb.append("idealStateMap:" + this._idealStateCache.getIdealStateMap()).append("\n");
        sb.append("stateModelDefMap:" + this._stateModelDefMap).append("\n");
        sb.append("instanceConfigMap:" + this._instanceConfigMap).append("\n");
        sb.append("resourceConfigMap:" + this._resourceConfigMap).append("\n");
        sb.append("taskDataCache:" + this._taskDataCache).append("\n");
        sb.append("messageCache:" + this._instanceMessagesCache).append("\n");
        sb.append("currentStateCache:" + this._currentStateCache).append("\n");
        sb.append("clusterConfig:" + this._clusterConfig).append("\n");
        return sb.toString();
    }
}

