/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;

public class CurrentStateOutput {
    private final Map<String, Map<Partition, Map<String, String>>> _currentStateMap = new HashMap<String, Map<Partition, Map<String, String>>>();
    private final Map<String, Map<Partition, Map<String, Message>>> _pendingStateMap = new HashMap<String, Map<Partition, Map<String, Message>>>();
    private final Map<String, Map<Partition, Map<String, Message>>> _cancellationStateMap = new HashMap<String, Map<Partition, Map<String, Message>>>();
    private final Map<String, Map<Partition, Map<String, Long>>> _currentStateEndTimeMap = new HashMap<String, Map<Partition, Map<String, Long>>>();
    private final Map<String, Map<Partition, Map<String, String>>> _requestedStateMap;
    private final Map<String, Map<Partition, Map<String, String>>> _infoMap;
    private final Map<String, String> _resourceStateModelMap = new HashMap<String, String>();
    private final Map<String, CurrentState> _curStateMetaMap = new HashMap<String, CurrentState>();

    public CurrentStateOutput() {
        this._requestedStateMap = new HashMap<String, Map<Partition, Map<String, String>>>();
        this._infoMap = new HashMap<String, Map<Partition, Map<String, String>>>();
    }

    public void setResourceStateModelDef(String resourceName, String stateModelDefName) {
        this._resourceStateModelMap.put(resourceName, stateModelDefName);
    }

    public String getResourceStateModelDef(String resourceName) {
        return this._resourceStateModelMap.get(resourceName);
    }

    public void setBucketSize(String resource, int bucketSize) {
        CurrentState curStateMeta = this._curStateMetaMap.get(resource);
        if (curStateMeta == null) {
            curStateMeta = new CurrentState(resource);
            this._curStateMetaMap.put(resource, curStateMeta);
        }
        curStateMeta.setBucketSize(bucketSize);
    }

    public int getBucketSize(String resource) {
        int bucketSize = 0;
        CurrentState curStateMeta = this._curStateMetaMap.get(resource);
        if (curStateMeta != null) {
            bucketSize = curStateMeta.getBucketSize();
        }
        return bucketSize;
    }

    public void setCurrentState(String resourceName, Partition partition, String instanceName, String state) {
        if (!this._currentStateMap.containsKey(resourceName)) {
            this._currentStateMap.put(resourceName, new HashMap());
        }
        if (!this._currentStateMap.get(resourceName).containsKey(partition)) {
            this._currentStateMap.get(resourceName).put(partition, new HashMap());
        }
        this._currentStateMap.get(resourceName).get(partition).put(instanceName, state);
    }

    public void setEndTime(String resourceName, Partition partition, String instanceName, Long timestamp) {
        if (!this._currentStateEndTimeMap.containsKey(resourceName)) {
            this._currentStateEndTimeMap.put(resourceName, new HashMap());
        }
        if (!this._currentStateEndTimeMap.get(resourceName).containsKey(partition)) {
            this._currentStateEndTimeMap.get(resourceName).put(partition, new HashMap());
        }
        this._currentStateEndTimeMap.get(resourceName).get(partition).put(instanceName, timestamp);
    }

    public void setRequestedState(String resourceName, Partition partition, String instanceName, String state) {
        if (!this._requestedStateMap.containsKey(resourceName)) {
            this._requestedStateMap.put(resourceName, new HashMap());
        }
        if (!this._requestedStateMap.get(resourceName).containsKey(partition)) {
            this._requestedStateMap.get(resourceName).put(partition, new HashMap());
        }
        this._requestedStateMap.get(resourceName).get(partition).put(instanceName, state);
    }

    public void setInfo(String resourceName, Partition partition, String instanceName, String state) {
        if (!this._infoMap.containsKey(resourceName)) {
            this._infoMap.put(resourceName, new HashMap());
        }
        if (!this._infoMap.get(resourceName).containsKey(partition)) {
            this._infoMap.get(resourceName).put(partition, new HashMap());
        }
        this._infoMap.get(resourceName).get(partition).put(instanceName, state);
    }

    public void setPendingState(String resourceName, Partition partition, String instanceName, Message message) {
        this.setStateMessage(resourceName, partition, instanceName, message, this._pendingStateMap);
    }

    public void setCancellationState(String resourceName, Partition partition, String instanceName, Message message) {
        this.setStateMessage(resourceName, partition, instanceName, message, this._cancellationStateMap);
    }

    private void setStateMessage(String resourceName, Partition partition, String instanceName, Message message, Map<String, Map<Partition, Map<String, Message>>> stateMessageMap) {
        if (!stateMessageMap.containsKey(resourceName)) {
            stateMessageMap.put(resourceName, new HashMap());
        }
        if (!stateMessageMap.get(resourceName).containsKey(partition)) {
            stateMessageMap.get(resourceName).put(partition, new HashMap());
        }
        stateMessageMap.get(resourceName).get(partition).put(instanceName, message);
    }

    public String getCurrentState(String resourceName, Partition partition, String instanceName) {
        Map<String, String> instanceStateMap;
        Map<Partition, Map<String, String>> map = this._currentStateMap.get(resourceName);
        if (map != null && (instanceStateMap = map.get(partition)) != null) {
            return instanceStateMap.get(instanceName);
        }
        return null;
    }

    public Long getEndTime(String resourceName, Partition partition, String instanceName) {
        Map<String, Long> instanceInfo;
        Map<Partition, Map<String, Long>> partitionInfo = this._currentStateEndTimeMap.get(resourceName);
        if (partitionInfo != null && (instanceInfo = partitionInfo.get(partition)) != null && instanceInfo.get(instanceName) != null) {
            return instanceInfo.get(instanceName);
        }
        return -1L;
    }

    public String getRequestedState(String resourceName, Partition partition, String instanceName) {
        Map<String, String> instanceStateMap;
        Map<Partition, Map<String, String>> map = this._requestedStateMap.get(resourceName);
        if (map != null && (instanceStateMap = map.get(partition)) != null) {
            return instanceStateMap.get(instanceName);
        }
        return null;
    }

    public String getInfo(String resourceName, Partition partition, String instanceName) {
        Map<String, String> instanceStateMap;
        Map<Partition, Map<String, String>> map = this._infoMap.get(resourceName);
        if (map != null && (instanceStateMap = map.get(partition)) != null) {
            return instanceStateMap.get(instanceName);
        }
        return null;
    }

    public Message getPendingState(String resourceName, Partition partition, String instanceName) {
        return this.getStateMessage(resourceName, partition, instanceName, this._pendingStateMap);
    }

    public Message getCancellationState(String resourceName, Partition partition, String instanceName) {
        return this.getStateMessage(resourceName, partition, instanceName, this._cancellationStateMap);
    }

    private Message getStateMessage(String resourceName, Partition partition, String instanceName, Map<String, Map<Partition, Map<String, Message>>> stateMessageMap) {
        Map<String, Message> instanceStateMap;
        Map<Partition, Map<String, Message>> map = stateMessageMap.get(resourceName);
        if (map != null && (instanceStateMap = map.get(partition)) != null) {
            return instanceStateMap.get(instanceName);
        }
        return null;
    }

    public Map<Partition, Map<String, String>> getCurrentStateMap(String resourceName) {
        if (this._currentStateMap.containsKey(resourceName)) {
            return this._currentStateMap.get(resourceName);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getCurrentStateMap(String resourceName, Partition partition) {
        Map<Partition, Map<String, String>> map;
        if (this._currentStateMap.containsKey(resourceName) && (map = this._currentStateMap.get(resourceName)).containsKey(partition)) {
            return map.get(partition);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getPendingStateMap(String resourceName, Partition partition) {
        Map<Partition, Map<String, Message>> map;
        if (this._pendingStateMap.containsKey(resourceName) && (map = this._pendingStateMap.get(resourceName)).containsKey(partition)) {
            Map<String, Message> pendingMsgMap = map.get(partition);
            HashMap<String, String> pendingStateMap = new HashMap<String, String>();
            for (String instance : pendingMsgMap.keySet()) {
                pendingStateMap.put(instance, pendingMsgMap.get(instance).getToState());
            }
            return pendingStateMap;
        }
        return Collections.emptyMap();
    }

    public Map<String, Message> getPendingMessageMap(String resourceName, Partition partition) {
        Map<Partition, Map<String, Message>> map;
        if (this._pendingStateMap.containsKey(resourceName) && (map = this._pendingStateMap.get(resourceName)).containsKey(partition)) {
            return map.get(partition);
        }
        return Collections.emptyMap();
    }

    public Set<Partition> getCurrentStateMappedPartitions(String resourceId) {
        Map<Partition, Map<String, String>> currentStateMap = this._currentStateMap.get(resourceId);
        Map<Partition, Map<String, Message>> pendingStateMap = this._pendingStateMap.get(resourceId);
        HashSet partitionSet = Sets.newHashSet();
        if (currentStateMap != null) {
            partitionSet.addAll(currentStateMap.keySet());
        }
        if (pendingStateMap != null) {
            partitionSet.addAll(pendingStateMap.keySet());
        }
        return partitionSet;
    }

    public Map<String, Integer> getPartitionCountWithPendingState(String resourceStateModel, String state) {
        return this.getPartitionCountWithState(resourceStateModel, state, this._pendingStateMap);
    }

    public Map<String, Integer> getPartitionCountWithCurrentState(String resourceStateModel, String state) {
        return this.getPartitionCountWithState(resourceStateModel, state, this._currentStateMap);
    }

    private Map<String, Integer> getPartitionCountWithState(String resourceStateModel, String state, Map<String, Map<Partition, Map<String, Object>>> stateMap) {
        HashMap<String, Integer> currentPartitionCount = new HashMap<String, Integer>();
        for (String resource : stateMap.keySet()) {
            String stateModel = this._resourceStateModelMap.get(resource);
            if ((stateModel == null || !stateModel.equals(resourceStateModel)) && (stateModel != null || resourceStateModel != null)) continue;
            for (Partition partition : stateMap.get(resource).keySet()) {
                Map<String, Object> partitionMessage = stateMap.get(resource).get(partition);
                for (Map.Entry<String, Object> participantMap : partitionMessage.entrySet()) {
                    String participant = participantMap.getKey();
                    if (!currentPartitionCount.containsKey(participant)) {
                        currentPartitionCount.put(participant, 0);
                    }
                    Object curStateObj = participantMap.getValue();
                    String currState = null;
                    if (curStateObj != null) {
                        if (curStateObj instanceof Message) {
                            currState = ((Message)curStateObj).getToState();
                        } else if (curStateObj instanceof String) {
                            currState = curStateObj.toString();
                        }
                    }
                    if ((currState == null || !currState.equals(state)) && (currState != null || state != null)) continue;
                    currentPartitionCount.put(participant, (Integer)currentPartitionCount.get(participant) + 1);
                }
            }
        }
        return currentPartitionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("current state= ").append(this._currentStateMap);
        sb.append(", pending state= ").append(this._pendingStateMap);
        return sb.toString();
    }
}

