/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.api.config.StateTransitionTimeoutConfig;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.controller.stages.MessageGenerationOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageGenerationPhase
extends AbstractBaseStage {
    private static final String NO_DESIRED_STATE = "NoDesiredState";
    public static final long DEFAULT_OBSELETE_MSG_PURGE_DELAY = HelixUtil.getSystemPropertyAsLong("helix.controller.stages.MessageGenerationPhase.messagePurgeDelay", 60000L);
    private static Logger logger = LoggerFactory.getLogger(MessageGenerationPhase.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute(AttributeName.ClusterDataCache.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        HashMap<String, Map<String, Message>> pendingMessagesToCleanUp = new HashMap<String, Map<String, Message>>();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        IntermediateStateOutput intermediateStateOutput = (IntermediateStateOutput)event.getAttribute(AttributeName.INTERMEDIATE_STATE.name());
        if (manager == null || cache == null || resourceMap == null || currentStateOutput == null || intermediateStateOutput == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager|DataCache|RESOURCES|CURRENT_STATE|INTERMEDIATE_STATE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        HashMap<String, String> sessionIdMap = new HashMap<String, String>();
        for (LiveInstance liveInstance : liveInstances.values()) {
            sessionIdMap.put(liveInstance.getInstanceName(), liveInstance.getSessionId());
        }
        MessageGenerationOutput output = new MessageGenerationOutput();
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
            if (stateModelDef == null) {
                LogUtil.logError(logger, this._eventId, "State Model Definition null, skip generating messages for resource: " + resourceName);
                continue;
            }
            for (Partition partition : resource.getPartitions()) {
                HashMap<String, String> instanceStateMap = new HashMap<String, String>(intermediateStateOutput.getInstanceStateMap(resourceName, partition));
                Map<String, String> pendingStateMap = currentStateOutput.getPendingStateMap(resourceName, partition);
                for (String instance : pendingStateMap.keySet()) {
                    if (instanceStateMap.containsKey(instance)) continue;
                    instanceStateMap.put(instance, NO_DESIRED_STATE);
                }
                HashMap messageMap = new HashMap();
                for (String instanceName : instanceStateMap.keySet()) {
                    int timeout;
                    String desiredState = (String)instanceStateMap.get(instanceName);
                    String currentState = currentStateOutput.getCurrentState(resourceName, partition, instanceName);
                    if (currentState == null) {
                        currentState = stateModelDef.getInitialState();
                    }
                    Message pendingMessage = currentStateOutput.getPendingState(resourceName, partition, instanceName);
                    boolean isCancellationEnabled = cache.getClusterConfig().isStateTransitionCancelEnabled();
                    Message cancellationMessage = currentStateOutput.getCancellationState(resourceName, partition, instanceName);
                    String nextState = stateModelDef.getNextStateForTransition(currentState, desiredState);
                    Message message = null;
                    if (this.shouldCleanUpPendingMessage(pendingMessage, currentState, currentStateOutput.getEndTime(resourceName, partition, instanceName))) {
                        LogUtil.logInfo(logger, this._eventId, String.format("Adding pending message %s on instance %s to clean up. Msg: %s->%s, current state of resource %s:%s is %s", pendingMessage.getMsgId(), instanceName, pendingMessage.getFromState(), pendingMessage.getToState(), resourceName, partition, currentState));
                        if (!pendingMessagesToCleanUp.containsKey(instanceName)) {
                            pendingMessagesToCleanUp.put(instanceName, new HashMap());
                        }
                        ((Map)pendingMessagesToCleanUp.get(instanceName)).put(pendingMessage.getMsgId(), pendingMessage);
                    }
                    if (desiredState.equals(NO_DESIRED_STATE) || desiredState.equalsIgnoreCase(currentState)) {
                        if (desiredState.equals(NO_DESIRED_STATE) || pendingMessage != null && !currentState.equalsIgnoreCase(pendingMessage.getToState())) {
                            message = this.createStateTransitionCancellationMessage(manager, resource, partition.getPartitionName(), instanceName, (String)sessionIdMap.get(instanceName), stateModelDef.getId(), pendingMessage.getFromState(), pendingMessage.getToState(), null, cancellationMessage, isCancellationEnabled, currentState);
                        }
                    } else {
                        if (nextState == null) {
                            LogUtil.logError(logger, this._eventId, "Unable to find a next state for resource: " + resource.getResourceName() + " partition: " + partition.getPartitionName() + " from stateModelDefinition" + stateModelDef.getClass() + " from:" + currentState + " to:" + desiredState);
                            continue;
                        }
                        if (pendingMessage != null) {
                            String pendingState = pendingMessage.getToState();
                            if (nextState.equalsIgnoreCase(pendingState)) {
                                LogUtil.logDebug(logger, this._eventId, "Message already exists for " + instanceName + " to transit " + resource.getResourceName() + "." + partition.getPartitionName() + " from " + currentState + " to " + nextState);
                            } else if (currentState.equalsIgnoreCase(pendingState)) {
                                LogUtil.logInfo(logger, this._eventId, "Message hasn't been removed for " + instanceName + " to transit " + resource.getResourceName() + "." + partition.getPartitionName() + " to " + pendingState + ", desiredState: " + desiredState);
                            } else {
                                LogUtil.logInfo(logger, this._eventId, "IdealState changed before state transition completes for " + resource.getResourceName() + "." + partition.getPartitionName() + " on " + instanceName + ", pendingState: " + pendingState + ", currentState: " + currentState + ", nextState: " + nextState);
                                message = this.createStateTransitionCancellationMessage(manager, resource, partition.getPartitionName(), instanceName, (String)sessionIdMap.get(instanceName), stateModelDef.getId(), pendingMessage.getFromState(), pendingState, nextState, cancellationMessage, isCancellationEnabled, currentState);
                            }
                        } else {
                            message = this.createStateTransitionMessage(manager, resource, partition.getPartitionName(), instanceName, currentState, nextState, (String)sessionIdMap.get(instanceName), stateModelDef.getId());
                            if (logger.isDebugEnabled()) {
                                LogUtil.logDebug(logger, this._eventId, String.format("Resource %s partition %s for instance %s with currentState %s and nextState %s", resource, partition.getPartitionName(), instanceName, currentState, nextState));
                            }
                        }
                    }
                    if (message == null) continue;
                    IdealState idealState = cache.getIdealState(resourceName);
                    if (idealState != null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue") && idealState.getRecord().getMapField(partition.getPartitionName()) != null) {
                        message.getRecord().setMapField(Message.Attributes.INNER_MESSAGE.toString(), idealState.getRecord().getMapField(partition.getPartitionName()));
                    }
                    if ((timeout = this.getTimeOut(cache.getClusterConfig(), cache.getResourceConfig(resourceName), currentState, nextState, idealState, partition)) > 0) {
                        message.setExecutionTimeout(timeout);
                    }
                    message.setAttribute(Message.Attributes.ClusterEventName, event.getEventType().name());
                    if (!messageMap.containsKey(desiredState)) {
                        messageMap.put(desiredState, new ArrayList());
                    }
                    ((List)messageMap.get(desiredState)).add(message);
                }
                List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
                for (String state : statesPriorityList) {
                    if (!messageMap.containsKey(state)) continue;
                    for (Message message : (List)messageMap.get(state)) {
                        output.addMessage(resourceName, partition, message);
                    }
                }
            }
        }
        if (!pendingMessagesToCleanUp.isEmpty()) {
            this.schedulePendingMessageCleanUp(pendingMessagesToCleanUp, cache.getAsyncTasksThreadPool(), manager.getHelixDataAccessor());
        }
        event.addAttribute(AttributeName.MESSAGES_ALL.name(), output);
    }

    private void schedulePendingMessageCleanUp(final Map<String, Map<String, Message>> pendingMessagesToPurge, ExecutorService workerPool, final HelixDataAccessor accessor) {
        workerPool.submit(new Callable<Object>(){

            @Override
            public Object call() {
                for (Map.Entry entry : pendingMessagesToPurge.entrySet()) {
                    String instanceName = (String)entry.getKey();
                    for (Message msg : ((Map)entry.getValue()).values()) {
                        if (!accessor.removeProperty(msg.getKey(accessor.keyBuilder(), instanceName))) continue;
                        LogUtil.logInfo(logger, MessageGenerationPhase.this._eventId, String.format("Deleted message %s from instance %s", msg.getMsgId(), instanceName));
                    }
                }
                return null;
            }
        });
    }

    private boolean shouldCleanUpPendingMessage(Message pendingMsg, String currentState, Long currentStateTransitionEndTime) {
        if (pendingMsg == null) {
            return false;
        }
        if (currentState.equalsIgnoreCase(pendingMsg.getToState())) {
            return System.currentTimeMillis() - currentStateTransitionEndTime > DEFAULT_OBSELETE_MSG_PURGE_DELAY;
        }
        return !currentState.equalsIgnoreCase(pendingMsg.getFromState());
    }

    private Message createStateTransitionMessage(HelixManager manager, Resource resource, String partitionName, String instanceName, String currentState, String nextState, String sessionId, String stateModelDefName) {
        String uuid = UUID.randomUUID().toString();
        Message message = new Message(Message.MessageType.STATE_TRANSITION, uuid);
        message.setSrcName(manager.getInstanceName());
        message.setTgtName(instanceName);
        message.setMsgState(Message.MessageState.NEW);
        message.setPartitionName(partitionName);
        message.setResourceName(resource.getResourceName());
        message.setFromState(currentState);
        message.setToState(nextState);
        message.setTgtSessionId(sessionId);
        message.setSrcSessionId(manager.getSessionId());
        message.setStateModelDef(stateModelDefName);
        message.setStateModelFactoryName(resource.getStateModelFactoryname());
        message.setBucketSize(resource.getBucketSize());
        if (resource.getResourceGroupName() != null) {
            message.setResourceGroupName(resource.getResourceGroupName());
        }
        if (resource.getResourceTag() != null) {
            message.setResourceTag(resource.getResourceTag());
        }
        return message;
    }

    private Message createStateTransitionCancellationMessage(HelixManager manager, Resource resource, String partitionName, String instanceName, String sessionId, String stateModelDefName, String fromState, String toState, String nextState, Message cancellationMessage, boolean isCancellationEnabled, String currentState) {
        if (isCancellationEnabled && cancellationMessage == null) {
            LogUtil.logInfo(logger, this._eventId, "Send cancellation message of the state transition for " + resource.getResourceName() + "." + partitionName + " on " + instanceName + ", currentState: " + currentState + ", nextState: " + (nextState == null ? "N/A" : nextState));
            String uuid = UUID.randomUUID().toString();
            Message message = new Message(Message.MessageType.STATE_TRANSITION_CANCELLATION, uuid);
            message.setSrcName(manager.getInstanceName());
            message.setTgtName(instanceName);
            message.setMsgState(Message.MessageState.NEW);
            message.setPartitionName(partitionName);
            message.setResourceName(resource.getResourceName());
            message.setFromState(fromState);
            message.setToState(toState);
            message.setTgtSessionId(sessionId);
            message.setSrcSessionId(manager.getSessionId());
            message.setStateModelDef(stateModelDefName);
            message.setStateModelFactoryName(resource.getStateModelFactoryname());
            message.setBucketSize(resource.getBucketSize());
            return message;
        }
        return null;
    }

    private int getTimeOut(ClusterConfig clusterConfig, ResourceConfig resourceConfig, String currentState, String nextState, IdealState idealState, Partition partition) {
        int timeout = -1;
        StateTransitionTimeoutConfig stateTransitionTimeoutConfig = clusterConfig.getStateTransitionTimeoutConfig();
        timeout = stateTransitionTimeoutConfig != null ? stateTransitionTimeoutConfig.getStateTransitionTimeout(currentState, nextState) : -1;
        String timeOutStr = null;
        if (idealState != null) {
            String stateTransition = currentState + "-" + nextState + "_" + (Object)((Object)Message.Attributes.TIMEOUT);
            timeOutStr = idealState.getRecord().getSimpleField(stateTransition);
            if (timeOutStr == null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue") && idealState.getRecord().getMapField(partition.getPartitionName()) != null) {
                timeOutStr = idealState.getRecord().getMapField(partition.getPartitionName()).get(Message.Attributes.TIMEOUT.toString());
            }
        }
        if (timeOutStr != null) {
            try {
                timeout = Integer.parseInt(timeOutStr);
            }
            catch (Exception e) {
                LogUtil.logError(logger, this._eventId, "", e);
            }
        }
        if (resourceConfig != null) {
            stateTransitionTimeoutConfig = resourceConfig.getStateTransitionTimeoutConfig();
            timeout = stateTransitionTimeoutConfig != null ? stateTransitionTimeoutConfig.getStateTransitionTimeout(currentState, nextState) : -1;
        }
        return timeout;
    }
}

