/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceComputationStage
extends AbstractBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(ResourceComputationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        Map<String, LiveInstance> availableInstances;
        this._eventId = event.getEventId();
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute(AttributeName.ClusterDataCache.name());
        if (cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache");
        }
        Map<String, IdealState> idealStates = cache.getIdealStates();
        LinkedHashMap<String, Resource> resourceMap = new LinkedHashMap<String, Resource>();
        LinkedHashMap<String, Resource> resourceToRebalance = new LinkedHashMap<String, Resource>();
        if (idealStates != null && idealStates.size() > 0) {
            for (IdealState idealState : idealStates.values()) {
                if (idealState == null) continue;
                Set<String> partitionSet = idealState.getPartitionSet();
                String resourceName = idealState.getResourceName();
                if (!resourceMap.containsKey(resourceName)) {
                    Resource resource = new Resource(resourceName, cache.getClusterConfig(), cache.getResourceConfig(resourceName));
                    resourceMap.put(resourceName, resource);
                    if (!idealState.isValid() && !cache.isTaskCache() || idealState.getStateModelDefRef().equals("Task") && cache.isTaskCache() || !idealState.getStateModelDefRef().equals("Task") && !cache.isTaskCache()) {
                        resourceToRebalance.put(resourceName, resource);
                    }
                    resource.setStateModelDefRef(idealState.getStateModelDefRef());
                    resource.setStateModelFactoryName(idealState.getStateModelFactoryName());
                    resource.setBucketSize(idealState.getBucketSize());
                    boolean batchMessageMode = idealState.getBatchMessageMode();
                    ClusterConfig clusterConfig = cache.getClusterConfig();
                    if (clusterConfig != null) {
                        batchMessageMode |= clusterConfig.getBatchMessageMode();
                    }
                    resource.setBatchMessageMode(batchMessageMode);
                    resource.setResourceGroupName(idealState.getResourceGroupName());
                    resource.setResourceTag(idealState.getInstanceGroupTag());
                }
                for (String partition : partitionSet) {
                    this.addPartition(partition, resourceName, resourceMap);
                }
            }
        }
        if ((availableInstances = cache.getLiveInstances()) != null && availableInstances.size() > 0) {
            for (LiveInstance instance : availableInstances.values()) {
                String clientSessionId;
                String instanceName = instance.getInstanceName();
                Map<String, CurrentState> currentStateMap = cache.getCurrentState(instanceName, clientSessionId = instance.getSessionId());
                if (currentStateMap == null || currentStateMap.size() == 0) continue;
                for (CurrentState currentState : currentStateMap.values()) {
                    String resourceName = currentState.getResourceName();
                    Map<String, String> resourceStateMap = currentState.getPartitionStateMap();
                    if (resourceStateMap.keySet().isEmpty()) continue;
                    if (!resourceMap.containsKey(resourceName)) {
                        IdealState idealState;
                        this.addResource(resourceName, resourceMap);
                        Resource resource = (Resource)resourceMap.get(resourceName);
                        resource.setStateModelDefRef(currentState.getStateModelDefRef());
                        resource.setStateModelFactoryName(currentState.getStateModelFactoryName());
                        resource.setBucketSize(currentState.getBucketSize());
                        resource.setBatchMessageMode(currentState.getBatchMessageMode());
                        if (resource.getStateModelDefRef() == null && !cache.isTaskCache() || resource.getStateModelDefRef() != null && (resource.getStateModelDefRef().equals("Task") && cache.isTaskCache() || !resource.getStateModelDefRef().equals("Task") && !cache.isTaskCache())) {
                            resourceToRebalance.put(resourceName, resource);
                        }
                        if ((idealState = idealStates.get(resourceName)) != null) {
                            resource.setResourceGroupName(idealState.getResourceGroupName());
                            resource.setResourceTag(idealState.getInstanceGroupTag());
                        }
                    }
                    if (currentState.getStateModelDefRef() == null) {
                        LogUtil.logError(LOG, this._eventId, "state model def is null.resource:" + currentState.getResourceName() + ", partitions: " + currentState.getPartitionStateMap().keySet() + ", states: " + currentState.getPartitionStateMap().values());
                        throw new StageException("State model def is null for resource:" + currentState.getResourceName());
                    }
                    for (String partition : resourceStateMap.keySet()) {
                        this.addPartition(partition, resourceName, resourceMap);
                    }
                }
            }
        }
        event.addAttribute(AttributeName.RESOURCES.name(), resourceMap);
        event.addAttribute(AttributeName.RESOURCES_TO_REBALANCE.name(), resourceToRebalance);
    }

    private void addResource(String resource, Map<String, Resource> resourceMap) {
        if (resource == null || resourceMap == null) {
            return;
        }
        if (!resourceMap.containsKey(resource)) {
            resourceMap.put(resource, new Resource(resource));
        }
    }

    private void addPartition(String partition, String resourceName, Map<String, Resource> resourceMap) {
        if (resourceName == null || partition == null || resourceMap == null) {
            return;
        }
        if (!resourceMap.containsKey(resourceName)) {
            resourceMap.put(resourceName, new Resource(resourceName));
        }
        Resource resource = resourceMap.get(resourceName);
        resource.addPartition(partition);
    }
}

