/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.model.ClusterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTransitionThrottleController {
    private static Logger logger = LoggerFactory.getLogger(StateTransitionThrottleController.class);
    private Map<StateTransitionThrottleConfig.RebalanceType, Long> _pendingTransitionAllowedInCluster = new HashMap<StateTransitionThrottleConfig.RebalanceType, Long>();
    private Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerInstance = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    private Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerResource = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    private boolean _throttleEnabled = false;

    public StateTransitionThrottleController(Set<String> resources, ClusterConfig clusterConfig, Set<String> liveInstances) {
        if (clusterConfig == null) {
            logger.warn("Cluster config is not found, no throttle config set!");
            return;
        }
        List<StateTransitionThrottleConfig> throttleConfigs = clusterConfig.getStateTransitionThrottleConfigs();
        if (throttleConfigs == null || throttleConfigs.isEmpty()) {
            logger.info("No throttle config is set!");
            return;
        }
        for (StateTransitionThrottleConfig config : throttleConfigs) {
            switch (config.getThrottleScope()) {
                case CLUSTER: {
                    this._pendingTransitionAllowedInCluster.put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    this._throttleEnabled = true;
                    break;
                }
                case RESOURCE: {
                    for (String resource : resources) {
                        if (!this._pendingTransitionAllowedPerResource.containsKey(resource)) {
                            this._pendingTransitionAllowedPerResource.put(resource, new HashMap());
                        }
                        this._pendingTransitionAllowedPerResource.get(resource).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                    break;
                }
                case INSTANCE: {
                    for (String instance : liveInstances) {
                        if (!this._pendingTransitionAllowedPerInstance.containsKey(instance)) {
                            this._pendingTransitionAllowedPerInstance.put(instance, new HashMap());
                        }
                        this._pendingTransitionAllowedPerInstance.get(instance).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                }
            }
        }
    }

    protected boolean isThrottleEnabled() {
        return this._throttleEnabled;
    }

    protected boolean shouldThrottleForCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        if (this.shouldThrottleForANYType(this._pendingTransitionAllowedInCluster)) {
            return true;
        }
        Long clusterThrottle = this._pendingTransitionAllowedInCluster.get((Object)rebalanceType);
        return clusterThrottle != null && clusterThrottle <= 0L;
    }

    protected boolean shouldThrottleForResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resourceName) {
        if (this.shouldThrottleForCluster(rebalanceType)) {
            return true;
        }
        if (this._pendingTransitionAllowedPerResource.containsKey(resourceName)) {
            Long resourceThrottle = this._pendingTransitionAllowedPerResource.get(resourceName).get((Object)rebalanceType);
            if (this.shouldThrottleForANYType(this._pendingTransitionAllowedPerResource.get(resourceName)) || resourceThrottle != null && resourceThrottle <= 0L) {
                return true;
            }
        }
        return false;
    }

    protected boolean shouldThrottleForInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instanceName) {
        if (this.shouldThrottleForCluster(rebalanceType)) {
            return true;
        }
        if (this._pendingTransitionAllowedPerInstance.containsKey(instanceName)) {
            Long instanceThrottle = this._pendingTransitionAllowedPerInstance.get(instanceName).get((Object)rebalanceType);
            if (this.shouldThrottleForANYType(this._pendingTransitionAllowedPerInstance.get(instanceName)) || instanceThrottle != null && instanceThrottle <= 0L) {
                return true;
            }
        }
        return false;
    }

    protected void chargeCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        if (this._pendingTransitionAllowedInCluster.containsKey((Object)rebalanceType)) {
            Long clusterThrottle = this._pendingTransitionAllowedInCluster.get((Object)rebalanceType);
            this.chargeANYType(this._pendingTransitionAllowedInCluster);
            if (clusterThrottle > 0L) {
                this._pendingTransitionAllowedInCluster.put(rebalanceType, clusterThrottle - 1L);
            }
        }
    }

    protected void chargeResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resource) {
        if (this._pendingTransitionAllowedPerResource.containsKey(resource) && this._pendingTransitionAllowedPerResource.get(resource).containsKey((Object)rebalanceType)) {
            this.chargeANYType(this._pendingTransitionAllowedPerResource.get(resource));
            Long resourceThrottle = this._pendingTransitionAllowedPerResource.get(resource).get((Object)rebalanceType);
            if (resourceThrottle > 0L) {
                this._pendingTransitionAllowedPerResource.get(resource).put(rebalanceType, resourceThrottle - 1L);
            }
        }
    }

    protected void chargeInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instance) {
        if (this._pendingTransitionAllowedPerInstance.containsKey(instance) && this._pendingTransitionAllowedPerInstance.get(instance).containsKey((Object)rebalanceType)) {
            this.chargeANYType(this._pendingTransitionAllowedPerInstance.get(instance));
            Long instanceThrottle = this._pendingTransitionAllowedPerInstance.get(instance).get((Object)rebalanceType);
            if (instanceThrottle > 0L) {
                this._pendingTransitionAllowedPerInstance.get(instance).put(rebalanceType, instanceThrottle - 1L);
            }
        }
    }

    private boolean shouldThrottleForANYType(Map<StateTransitionThrottleConfig.RebalanceType, Long> pendingTransitionAllowed) {
        Long anyTypeThrottle;
        return pendingTransitionAllowed.containsKey((Object)StateTransitionThrottleConfig.RebalanceType.ANY) && (anyTypeThrottle = pendingTransitionAllowed.get((Object)StateTransitionThrottleConfig.RebalanceType.ANY)) != null && anyTypeThrottle <= 0L;
    }

    private void chargeANYType(Map<StateTransitionThrottleConfig.RebalanceType, Long> pendingTransitionAllowed) {
        Long anyTypeThrottle;
        if (pendingTransitionAllowed.containsKey((Object)StateTransitionThrottleConfig.RebalanceType.ANY) && (anyTypeThrottle = pendingTransitionAllowed.get((Object)StateTransitionThrottleConfig.RebalanceType.ANY)) > 0L) {
            pendingTransitionAllowed.put(StateTransitionThrottleConfig.RebalanceType.ANY, anyTypeThrottle - 1L);
        }
    }
}

