/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetExteralViewCalcStage
extends AbstractAsyncBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger(TargetExteralViewCalcStage.class);

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.TargetExternalViewCalcWorker;
    }

    @Override
    public void execute(ClusterEvent event) throws Exception {
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute(AttributeName.ClusterDataCache.name());
        ClusterConfig clusterConfig = cache.getClusterConfig();
        if (cache.isTaskCache() || !clusterConfig.isTargetExternalViewEnabled()) {
            return;
        }
        HelixManager helixManager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        HelixDataAccessor accessor = helixManager.getHelixDataAccessor();
        BestPossibleStateOutput bestPossibleAssignments = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        IntermediateStateOutput intermediateAssignments = (IntermediateStateOutput)event.getAttribute(AttributeName.INTERMEDIATE_STATE.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        if (!accessor.getBaseDataAccessor().exists(accessor.keyBuilder().targetExternalViews().getPath(), AccessOption.PERSISTENT)) {
            accessor.getBaseDataAccessor().create(accessor.keyBuilder().targetExternalViews().getPath(), null, AccessOption.PERSISTENT);
        }
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        ArrayList<ExternalView> targetExternalViews = new ArrayList<ExternalView>();
        for (String resourceName : bestPossibleAssignments.resourceSet()) {
            Resource resource;
            if (cache.getIdealState(resourceName) == null || cache.getIdealState(resourceName).isExternalViewDisabled() || (resource = (Resource)resourceMap.get(resourceName)) == null) continue;
            PartitionStateMap partitionStateMap = intermediateAssignments.getPartitionStateMap(resourceName);
            Map<String, Map<String, String>> intermediateAssignment = this.convertToMapFields(partitionStateMap.getStateMap());
            Map<String, List<String>> preferenceLists = bestPossibleAssignments.getPreferenceLists(resourceName);
            boolean needPersist = false;
            ExternalView targetExternalView = cache.getTargetExternalView(resourceName);
            if (targetExternalView == null) {
                targetExternalView = new ExternalView(resourceName);
                targetExternalView.getRecord().getSimpleFields().putAll(cache.getIdealState(resourceName).getRecord().getSimpleFields());
                needPersist = true;
            }
            if (preferenceLists != null && !targetExternalView.getRecord().getListFields().equals(preferenceLists)) {
                targetExternalView.getRecord().setListFields(preferenceLists);
                needPersist = true;
            }
            if (intermediateAssignment != null && !targetExternalView.getRecord().getMapFields().equals(intermediateAssignment)) {
                targetExternalView.getRecord().setMapFields(intermediateAssignment);
                needPersist = true;
            }
            if (!needPersist) continue;
            keys.add(accessor.keyBuilder().targetExternalView(resourceName));
            targetExternalViews.add(targetExternalView);
            cache.updateTargetExternalView(resourceName, targetExternalView);
        }
        accessor.setChildren(keys, targetExternalViews);
    }

    private Map<String, Map<String, String>> convertToMapFields(Map<Partition, Map<String, String>> partitionMapMap) {
        HashMap mapFields = Maps.newHashMap();
        for (Partition p : partitionMapMap.keySet()) {
            mapFields.put(p.getPartitionName(), new HashMap<String, String>(partitionMapMap.get(p)));
        }
        return mapFields;
    }
}

