/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncCallback {
    private static Logger _logger = LoggerFactory.getLogger(AsyncCallback.class);
    long _startTimeStamp = 0L;
    protected long _timeout = -1L;
    Timer _timer = null;
    List<Message> _messagesSent;
    protected final List<Message> _messageReplied = new ArrayList<Message>();
    boolean _timedOut = false;
    boolean _isInterrupted = false;

    public AsyncCallback(long timeout) {
        _logger.info("Setting time out to " + timeout + " ms");
        this._timeout = timeout;
    }

    public AsyncCallback() {
        this(-1L);
    }

    public final void setTimeout(long timeout) {
        _logger.info("Setting time out to " + timeout + " ms");
        this._timeout = timeout;
    }

    public List<Message> getMessageReplied() {
        return this._messageReplied;
    }

    public boolean isInterrupted() {
        return this._isInterrupted;
    }

    public void setInterrupted(boolean b) {
        this._isInterrupted = true;
    }

    public final synchronized void onReply(Message message) {
        _logger.info("OnReply msg " + message.getMsgId());
        if (!this.isDone()) {
            this._messageReplied.add(message);
            try {
                this.onReplyMessage(message);
            }
            catch (Exception e) {
                _logger.error(e.toString());
            }
        }
        if (this.isDone()) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            this.notifyAll();
        }
    }

    public boolean isDone() {
        return this._messageReplied.size() == this._messagesSent.size();
    }

    public boolean isTimedOut() {
        return this._timedOut;
    }

    final void setMessagesSent(List<Message> generatedMessage) {
        this._messagesSent = generatedMessage;
    }

    final synchronized void startTimer() {
        if (this._timer == null && this._timeout > 0L) {
            if (this._startTimeStamp == 0L) {
                this._startTimeStamp = new Date().getTime();
            }
            this._timer = new Timer(true);
            this._timer.schedule((TimerTask)new TimeoutTask(this), this._timeout);
        }
    }

    public abstract void onTimeOut();

    public abstract void onReplyMessage(Message var1);

    class TimeoutTask
    extends TimerTask {
        AsyncCallback _callback;

        public TimeoutTask(AsyncCallback asyncCallback2) {
            this._callback = asyncCallback2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AsyncCallback asyncCallback = this._callback;
                synchronized (asyncCallback) {
                    this._callback._timedOut = true;
                    this._callback.notifyAll();
                    this._callback.onTimeOut();
                }
            }
            catch (Exception e) {
                _logger.error(e.toString());
            }
            finally {
                if (AsyncCallback.this._timer != null) {
                    AsyncCallback.this._timer.cancel();
                }
            }
        }
    }
}

