/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRollbackException;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.ZNRecordBucketizer;
import org.apache.helix.ZNRecordDelta;
import org.apache.helix.messaging.handling.CurrentStateUpdate;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.util.StatusUpdateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixStateTransitionHandler
extends MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(HelixStateTransitionHandler.class);
    private final StateModel _stateModel;
    StatusUpdateUtil _statusUpdateUtil;
    private final StateModelParser _transitionMethodFinder;
    private final CurrentState _currentStateDelta;
    private final HelixManager _manager;
    private final StateModelFactory<? extends StateModel> _stateModelFactory;
    volatile boolean _isTimeout = false;

    public HelixStateTransitionHandler(StateModelFactory<? extends StateModel> stateModelFactory, StateModel stateModel, Message message, NotificationContext context, CurrentState currentStateDelta) {
        super(message, context);
        this._stateModel = stateModel;
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._transitionMethodFinder = new StateModelParser();
        this._currentStateDelta = currentStateDelta;
        this._manager = this._notificationContext.getManager();
        this._stateModelFactory = stateModelFactory;
    }

    void preHandleMessage() throws Exception {
        if (!this._message.isValid()) {
            String errorMessage = "Invalid Message, ensure that message: " + this._message + " has all the required fields: " + Arrays.toString((Object[])Message.Attributes.values());
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, errorMessage, this._manager);
            logger.error(errorMessage);
            throw new HelixException(errorMessage);
        }
        logger.info("handling message: " + this._message.getMsgId() + " transit " + this._message.getResourceName() + "." + this._message.getPartitionName() + "|" + this._message.getPartitionNames() + " from:" + this._message.getFromState() + " to:" + this._message.getToState() + ", relayedFrom: " + this._message.getRelaySrcHost());
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        String partitionName = this._message.getPartitionName();
        String fromState = this._message.getFromState();
        String toState = this._message.getToState();
        String state = this._stateModel.getCurrentState() != null ? this._stateModel.getCurrentState() : this._currentStateDelta.getState(partitionName);
        this._currentStateDelta.setStartTime(this._message.getPartitionName(), System.currentTimeMillis());
        Throwable err = null;
        if (toState.equalsIgnoreCase(state)) {
            err = new HelixDuplicatedStateTransitionException(String.format("Partition %s current state is same as toState (%s->%s) from message.", partitionName, fromState, toState));
        } else if (fromState != null && !fromState.equals("*") && !fromState.equalsIgnoreCase(state)) {
            err = new HelixStateMismatchException(String.format("Current state of stateModel does not match the fromState in Message, CurrentState: %s, Message: %s->%s, Partition: %s, from: %s, to: %s", state, fromState, toState, partitionName, this._message.getMsgSrc(), this._message.getTgtName()));
        }
        if (err != null) {
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, err.getMessage(), this._manager);
            logger.error(err.getMessage());
            throw err;
        }
        try {
            String instance = this._manager.getInstanceName();
            String sessionId = this._message.getTgtSessionId();
            String resource = this._message.getResourceName();
            ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(this._message.getBucketSize());
            PropertyKey key = accessor.keyBuilder().currentState(instance, sessionId, resource, bucketizer.getBucketName(partitionName));
            ZNRecord rec = new ZNRecord(resource);
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.put(CurrentState.CurrentStateProperty.REQUESTED_STATE.name(), null);
            rec.getMapFields().put(partitionName, map);
            ZNRecordDelta delta = new ZNRecordDelta(rec, ZNRecordDelta.MergeOperation.SUBTRACT);
            ArrayList<ZNRecordDelta> deltaList = new ArrayList<ZNRecordDelta>();
            deltaList.add(delta);
            CurrentState currStateUpdate = new CurrentState(resource);
            currStateUpdate.setDeltaList(deltaList);
            if (!accessor.updateProperty(key, currStateUpdate)) {
                logger.error("Fails to persist current state back to ZK for resource " + resource + " partition: " + partitionName);
            }
        }
        catch (Exception e) {
            logger.error("Error when removing " + CurrentState.CurrentStateProperty.REQUESTED_STATE.name() + " from current state.", (Throwable)e);
            StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.FRAMEWORK, MessageHandler.ErrorCode.ERROR, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, e, "Error when removing " + CurrentState.CurrentStateProperty.REQUESTED_STATE.name() + " from current state.", this._manager);
        }
    }

    void postHandleMessage() {
        HelixTaskResult taskResult = (HelixTaskResult)this._notificationContext.get(NotificationContext.MapKey.HELIX_TASK_RESULT.toString());
        Exception exception = taskResult.getException();
        String partitionKey = this._message.getPartitionName();
        String resource = this._message.getResourceName();
        String sessionId = this._message.getTgtSessionId();
        String instanceName = this._manager.getInstanceName();
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        int bucketSize = this._message.getBucketSize();
        ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(bucketSize);
        if (!this._message.getTgtSessionId().equals(this._manager.getSessionId())) {
            logger.warn("Session id has changed. Skip postExecutionMessage. Old session " + this._message.getExecutionSessionId() + " , new session : " + this._manager.getSessionId());
            return;
        }
        this._currentStateDelta.setInfo(partitionKey, taskResult.getInfo());
        this._currentStateDelta.setEndTime(partitionKey, taskResult.getCompleteTime());
        this._currentStateDelta.setPreviousState(partitionKey, this._message.getFromState());
        if (Message.MessageType.RELAYED_MESSAGE.name().equals(this._message.getMsgSubType())) {
            this._currentStateDelta.setTriggerHost(partitionKey, this._message.getRelaySrcHost());
        } else {
            this._currentStateDelta.setTriggerHost(partitionKey, this._message.getMsgSrc());
        }
        if (taskResult.isSuccess()) {
            String toState = this._message.getToState();
            this._currentStateDelta.setState(partitionKey, toState);
            if (toState.equalsIgnoreCase(HelixDefinedState.DROPPED.toString())) {
                ZNRecord rec = new ZNRecord(this._currentStateDelta.getId());
                rec.getMapFields().put(partitionKey, null);
                ZNRecordDelta delta = new ZNRecordDelta(rec, ZNRecordDelta.MergeOperation.SUBTRACT);
                ArrayList<ZNRecordDelta> deltaList = new ArrayList<ZNRecordDelta>();
                deltaList.add(delta);
                this._currentStateDelta.setDeltaList(deltaList);
                this._stateModelFactory.removeStateModel(resource, partitionKey);
            } else {
                this._stateModel.updateState(toState);
            }
        } else {
            if (taskResult.isCancelled()) {
                return;
            }
            if (exception instanceof HelixStateMismatchException) {
                logger.warn("Force CurrentState on Zk to be stateModel's CurrentState. partitionKey: " + partitionKey + ", currentState: " + this._stateModel.getCurrentState() + ", message: " + this._message);
                this._currentStateDelta.setState(partitionKey, this._stateModel.getCurrentState());
            } else {
                StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, MessageHandler.ErrorCode.ERROR, exception);
                if (exception instanceof InterruptedException) {
                    if (this._isTimeout) {
                        error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, MessageHandler.ErrorCode.TIMEOUT, exception);
                    } else {
                        logger.error("State transition interrupted but not timeout. Not updating state. Partition : " + this._message.getPartitionName() + " MsgId : " + this._message.getMsgId());
                        return;
                    }
                }
                this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
                this._currentStateDelta.setState(partitionKey, HelixDefinedState.ERROR.toString());
                this._stateModel.updateState(HelixDefinedState.ERROR.toString());
                if (this._message.getFromState().equalsIgnoreCase(HelixDefinedState.ERROR.toString())) {
                    this.disablePartition();
                }
            }
        }
        try {
            PropertyKey key = keyBuilder.currentState(instanceName, sessionId, resource, bucketizer.getBucketName(partitionKey));
            if (this._message.getAttribute(Message.Attributes.PARENT_MSG_ID) == null) {
                if (!accessor.updateProperty(key, this._currentStateDelta)) {
                    throw new HelixException("Fails to persist current state back to ZK for resource " + resource + " partition: " + this._message.getPartitionName());
                }
            } else {
                ConcurrentHashMap csUpdateMap = (ConcurrentHashMap)this._notificationContext.get(NotificationContext.MapKey.CURRENT_STATE_UPDATE.toString());
                csUpdateMap.put(partitionKey, new CurrentStateUpdate(key, this._currentStateDelta));
            }
        }
        catch (Exception e) {
            logger.error("Error when updating current-state ", (Throwable)e);
            StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.FRAMEWORK, MessageHandler.ErrorCode.ERROR, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, e, "Error when update current-state ", this._manager);
        }
    }

    void disablePartition() {
        String instanceName = this._manager.getInstanceName();
        String resourceName = this._message.getResourceName();
        String partitionName = this._message.getPartitionName();
        String clusterName = this._manager.getClusterName();
        HelixAdmin admin = this._manager.getClusterManagmentTool();
        admin.enablePartition(false, clusterName, instanceName, resourceName, Arrays.asList(partitionName));
        logger.info("error in transit from ERROR to " + this._message.getToState() + " for partition: " + partitionName + ". disable it on " + instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixTaskResult handleMessage() {
        NotificationContext context = this._notificationContext;
        Message message = this._message;
        StateModel stateModel = this._stateModel;
        synchronized (stateModel) {
            HelixTaskResult taskResult = new HelixTaskResult();
            HelixManager manager = context.getManager();
            this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling task begin execute", manager);
            message.setExecuteStartTimeStamp(new Date().getTime());
            try {
                this.preHandleMessage();
                this.invoke(manager, context, taskResult, message);
            }
            catch (HelixDuplicatedStateTransitionException e) {
                taskResult.setSuccess(true);
                taskResult.setMessage(e.toString());
                taskResult.setInfo(e.getMessage());
            }
            catch (HelixStateMismatchException e) {
                taskResult.setSuccess(false);
                taskResult.setMessage(e.toString());
                taskResult.setException(e);
            }
            catch (Exception e2) {
                InterruptedException e2;
                String errorMessage = "Exception while executing a state transition task " + message.getPartitionName();
                logger.error(errorMessage, (Throwable)e2);
                if (e2.getCause() != null && e2.getCause() instanceof InterruptedException) {
                    e2 = (InterruptedException)e2.getCause();
                }
                if (e2 instanceof HelixRollbackException || e2.getCause() != null && e2.getCause() instanceof HelixRollbackException) {
                    logger.info("Rollback happened of state transition on resource \"" + this._message.getResourceName() + "\" partition \"" + this._message.getPartitionName() + "\" from \"" + this._message.getFromState() + "\" to \"" + this._message.getToState() + "\"");
                    taskResult.setCancelled(true);
                }
                this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, (Exception)e2, errorMessage, manager);
                taskResult.setSuccess(false);
                taskResult.setMessage(e2.toString());
                taskResult.setException(e2);
                taskResult.setInterrupted(e2 instanceof InterruptedException);
            }
            taskResult.setCompleteTime(System.currentTimeMillis());
            context.add(NotificationContext.MapKey.HELIX_TASK_RESULT.toString(), taskResult);
            this.postHandleMessage();
            return taskResult;
        }
    }

    private void invoke(HelixManager manager, NotificationContext context, HelixTaskResult taskResult, Message message) throws IllegalAccessException, InvocationTargetException, InterruptedException, HelixRollbackException {
        this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling invoking", manager);
        Method methodToInvoke = null;
        String fromState = message.getFromState();
        String toState = message.getToState();
        methodToInvoke = this._transitionMethodFinder.getMethodForTransition(this._stateModel.getClass(), fromState, toState, new Class[]{Message.class, NotificationContext.class});
        if (methodToInvoke != null) {
            logger.info(String.format("Instance %s, partition %s received state transition from %s to %s on session %s, message id: %s", message.getTgtName(), message.getPartitionName(), message.getFromState(), message.getToState(), message.getTgtSessionId(), message.getMsgId()));
            if (this._cancelled) {
                throw new HelixRollbackException(String.format("Instance %s, partition %s state transition from %s to %s on session %s has been cancelled, message id: %s", message.getTgtName(), message.getPartitionName(), message.getFromState(), message.getToState(), message.getTgtSessionId(), message.getMsgId()));
            }
            if (this._cancelled) {
                throw new HelixRollbackException(String.format("Instance %s, partition %s state transition from %s to %s on session %s has been cancelled", message.getTgtName(), message.getPartitionName(), message.getFromState(), message.getToState(), message.getTgtSessionId()));
            }
            Object result = methodToInvoke.invoke((Object)this._stateModel, message, context);
            taskResult.setSuccess(true);
            String resultStr = result == null || result instanceof Void ? "" : result.toString();
            taskResult.setInfo(resultStr);
        } else {
            String errorMessage = "Unable to find method for transition from " + fromState + " to " + toState + " in " + this._stateModel.getClass();
            logger.error(errorMessage);
            taskResult.setSuccess(false);
            taskResult.setInfo(errorMessage);
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, errorMessage, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String instanceName = this._manager.getInstanceName();
        String resourceName = this._message.getResourceName();
        String partition = this._message.getPartitionName();
        if (type == MessageHandler.ErrorType.INTERNAL) {
            logger.error("Skip internal error. errCode: " + (Object)((Object)code) + ", errMsg: " + e.getMessage());
            return;
        }
        try {
            if (code == MessageHandler.ErrorCode.ERROR) {
                CurrentState currentStateDelta = new CurrentState(resourceName);
                currentStateDelta.setState(partition, HelixDefinedState.ERROR.toString());
                this._stateModel.updateState(HelixDefinedState.ERROR.toString());
                if (this._message.getFromState().equalsIgnoreCase(HelixDefinedState.ERROR.toString())) {
                    this.disablePartition();
                }
                if (!accessor.updateProperty(keyBuilder.currentState(instanceName, this._message.getTgtSessionId(), resourceName), currentStateDelta)) {
                    logger.error("Fails to persist ERROR current state to ZK for resource " + resourceName + " partition: " + partition);
                }
            }
        }
        finally {
            StateTransitionError error = new StateTransitionError(type, code, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
        }
    }

    @Override
    public void onTimeout() {
        this._isTimeout = true;
    }

    public static class HelixDuplicatedStateTransitionException
    extends Exception {
        public HelixDuplicatedStateTransitionException(String info) {
            super(info);
        }
    }

    public static class HelixStateMismatchException
    extends Exception {
        public HelixStateMismatchException(String info) {
            super(info);
        }
    }
}

