/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.Criteria;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.listeners.MessageListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.messaging.handling.HelixTask;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.messaging.handling.MessageTaskInfo;
import org.apache.helix.messaging.handling.MessageTimeoutTask;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.messaging.handling.TaskExecutor;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.monitoring.mbeans.MessageQueueMonitor;
import org.apache.helix.monitoring.mbeans.ParticipantMessageMonitor;
import org.apache.helix.monitoring.mbeans.ParticipantStatusMonitor;
import org.apache.helix.participant.HelixStateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.StatusUpdateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixTaskExecutor
implements MessageListener,
TaskExecutor {
    private static Logger LOG = LoggerFactory.getLogger(HelixTaskExecutor.class);
    public static final int DEFAULT_PARALLEL_TASKS = 40;
    protected final Map<String, MessageTaskInfo> _taskMap;
    private final Object _lock;
    private final StatusUpdateUtil _statusUpdateUtil;
    private final ParticipantStatusMonitor _monitor;
    public static final String MAX_THREADS = "maxThreads";
    private MessageQueueMonitor _messageQueueMonitor;
    private GenericHelixController _controller;
    private Long _lastSessionSyncTime;
    private static final int SESSION_SYNC_INTERVAL = 2000;
    private static final String SESSION_SYNC = "SESSION-SYNC";
    final ConcurrentHashMap<String, MsgHandlerFactoryRegistryItem> _hdlrFtyRegistry;
    final ConcurrentHashMap<String, ExecutorService> _executorMap;
    final ExecutorService _batchMessageExecutorService;
    final ConcurrentHashMap<String, String> _messageTaskMap;
    final Set<String> _knownMessageIds;
    final Set<String> _resourcesThreadpoolChecked;
    final Set<String> _transitionTypeThreadpoolChecked;
    final Timer _timer;
    private boolean _isShuttingDown;

    public HelixTaskExecutor() {
        this(new ParticipantStatusMonitor(false, null), null);
    }

    public HelixTaskExecutor(ParticipantStatusMonitor participantStatusMonitor) {
        this(participantStatusMonitor, null);
    }

    public HelixTaskExecutor(ParticipantStatusMonitor participantStatusMonitor, MessageQueueMonitor messageQueueMonitor) {
        this._monitor = participantStatusMonitor;
        this._messageQueueMonitor = messageQueueMonitor;
        this._taskMap = new ConcurrentHashMap<String, MessageTaskInfo>();
        this._hdlrFtyRegistry = new ConcurrentHashMap();
        this._executorMap = new ConcurrentHashMap();
        this._messageTaskMap = new ConcurrentHashMap();
        this._knownMessageIds = Collections.newSetFromMap(new ConcurrentHashMap());
        this._batchMessageExecutorService = Executors.newCachedThreadPool();
        this._monitor.createExecutorMonitor("BatchMessageExecutor", this._batchMessageExecutorService);
        this._resourcesThreadpoolChecked = Collections.newSetFromMap(new ConcurrentHashMap());
        this._transitionTypeThreadpoolChecked = Collections.newSetFromMap(new ConcurrentHashMap());
        this._lock = new Object();
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._timer = new Timer(true);
        this._isShuttingDown = false;
        this.startMonitorThread();
    }

    @Override
    public void registerMessageHandlerFactory(String type, MessageHandlerFactory factory) {
        this.registerMessageHandlerFactory(type, factory, 40);
    }

    @Override
    public void registerMessageHandlerFactory(String type, MessageHandlerFactory factory, int threadpoolSize) {
        if (factory instanceof MultiTypeMessageHandlerFactory) {
            if (!((MultiTypeMessageHandlerFactory)factory).getMessageTypes().contains(type)) {
                throw new HelixException("Message factory type mismatch. Type: " + type + ", factory: " + ((MultiTypeMessageHandlerFactory)factory).getMessageTypes());
            }
        } else if (!factory.getMessageType().equals(type)) {
            throw new HelixException("Message factory type mismatch. Type: " + type + ", factory: " + factory.getMessageType());
        }
        this._isShuttingDown = false;
        MsgHandlerFactoryRegistryItem newItem = new MsgHandlerFactoryRegistryItem(factory, threadpoolSize);
        MsgHandlerFactoryRegistryItem prevItem = this._hdlrFtyRegistry.putIfAbsent(type, newItem);
        if (prevItem == null) {
            ExecutorService newPool = Executors.newFixedThreadPool(threadpoolSize, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "HelixTaskExecutor-message_handle_thread");
                }
            });
            ExecutorService prevExecutor = this._executorMap.putIfAbsent(type, newPool);
            if (prevExecutor != null) {
                LOG.warn("Skip creating a new thread pool for type: " + type + ", already existing pool: " + prevExecutor + ", isShutdown: " + prevExecutor.isShutdown());
                newPool.shutdown();
                newPool = null;
            } else {
                this._monitor.createExecutorMonitor(type, newPool);
            }
            LOG.info("Registered message handler factory for type: " + type + ", poolSize: " + threadpoolSize + ", factory: " + factory + ", pool: " + this._executorMap.get(type));
        } else {
            LOG.info("Skip register message handler factory for type: " + type + ", poolSize: " + threadpoolSize + ", factory: " + factory + ", already existing factory: " + prevItem.factory());
            newItem = null;
        }
    }

    public void setController(GenericHelixController controller) {
        this._controller = controller;
    }

    public ParticipantStatusMonitor getParticipantMonitor() {
        return this._monitor;
    }

    private void startMonitorThread() {
    }

    private void updateStateTransitionMessageThreadPool(Message message, HelixManager manager) {
        if (!message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name())) {
            return;
        }
        String resourceName = message.getResourceName();
        String factoryName = message.getStateModelFactoryName();
        String stateModelName = message.getStateModelDef();
        if (factoryName == null) {
            factoryName = "DEFAULT";
        }
        StateModelFactory<? extends StateModel> stateModelFactory = manager.getStateMachineEngine().getStateModelFactory(stateModelName, factoryName);
        String perStateTransitionTypeKey = this.getStateTransitionType(this.getPerResourceStateTransitionPoolName(resourceName), message.getFromState(), message.getToState());
        if (perStateTransitionTypeKey != null && stateModelFactory != null && !this._transitionTypeThreadpoolChecked.contains(perStateTransitionTypeKey)) {
            ExecutorService perStateTransitionTypeExecutor = stateModelFactory.getExecutorService(resourceName, message.getFromState(), message.getToState());
            this._transitionTypeThreadpoolChecked.add(perStateTransitionTypeKey);
            if (perStateTransitionTypeExecutor != null) {
                this._executorMap.put(perStateTransitionTypeKey, perStateTransitionTypeExecutor);
                LOG.info(String.format("Added client specified dedicate threadpool for resource %s from %s to %s", this.getPerResourceStateTransitionPoolName(resourceName), message.getFromState(), message.getToState()));
                return;
            }
        }
        if (!this._resourcesThreadpoolChecked.contains(resourceName)) {
            int threadpoolSize = -1;
            ConfigAccessor configAccessor = manager.getConfigAccessor();
            if (configAccessor != null) {
                HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(manager.getClusterName()).forResource(resourceName).build();
                String threadpoolSizeStr = configAccessor.get(scope, MAX_THREADS);
                try {
                    if (threadpoolSizeStr != null) {
                        threadpoolSize = Integer.parseInt(threadpoolSizeStr);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to parse ThreadPoolSize from resourceConfig for resource" + resourceName, (Throwable)e);
                }
            }
            final String key = this.getPerResourceStateTransitionPoolName(resourceName);
            if (threadpoolSize > 0) {
                this._executorMap.put(key, Executors.newFixedThreadPool(threadpoolSize, new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "GerenricHelixController-message_handle_" + key);
                    }
                }));
                LOG.info("Added dedicate threadpool for resource: " + resourceName + " with size: " + threadpoolSize);
            } else if (stateModelFactory != null) {
                ExecutorService executor = stateModelFactory.getExecutorService(resourceName);
                if (executor != null) {
                    this._executorMap.put(key, executor);
                    LOG.info("Added client specified dedicate threadpool for resource: " + key);
                }
            } else {
                LOG.error(String.format("Fail to get dedicate threadpool defined in stateModelFactory %s: using factoryName: %s for resource %s. No stateModelFactory was found!", stateModelName, factoryName, resourceName));
            }
            this._resourcesThreadpoolChecked.add(resourceName);
        }
    }

    ExecutorService findExecutorServiceForMsg(Message message) {
        ExecutorService executorService = this._executorMap.get(message.getMsgType());
        if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name())) {
            if (message.getBatchMessageMode()) {
                executorService = this._batchMessageExecutorService;
            } else {
                String resourceName = message.getResourceName();
                if (resourceName != null) {
                    String key = this.getPerResourceStateTransitionPoolName(resourceName);
                    String perStateTransitionTypeKey = this.getStateTransitionType(key, message.getFromState(), message.getToState());
                    if (perStateTransitionTypeKey != null && this._executorMap.containsKey(perStateTransitionTypeKey)) {
                        LOG.info(String.format("Find per state transition type thread pool for resource %s from %s to %s", message.getResourceName(), message.getFromState(), message.getToState()));
                        executorService = this._executorMap.get(perStateTransitionTypeKey);
                    } else if (this._executorMap.containsKey(key)) {
                        LOG.info("Find per-resource thread pool with key: " + key);
                        executorService = this._executorMap.get(key);
                    }
                }
            }
        }
        return executorService;
    }

    @Override
    public List<Future<HelixTaskResult>> invokeAllTasks(List<MessageTask> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || tasks.size() == 0) {
            return null;
        }
        ExecutorService exeSvc = this.findExecutorServiceForMsg(tasks.get(0).getMessage());
        for (int i = 1; i < tasks.size(); ++i) {
            MessageTask task = tasks.get(i);
            ExecutorService curExeSvc = this.findExecutorServiceForMsg(task.getMessage());
            if (curExeSvc == exeSvc) continue;
            LOG.error("Fail to invoke all tasks because they are not using the same executor-service");
            return null;
        }
        List<Future<HelixTaskResult>> futures = exeSvc.invokeAll(tasks, timeout, unit);
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTimeoutTask(MessageTask task) {
        Object object = this._lock;
        synchronized (object) {
            String taskId = task.getTaskId();
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo info = this._taskMap.get(taskId);
                this.removeMessageFromTaskAndFutureMap(task.getMessage());
                if (info._timerTask != null) {
                    info._timerTask.cancel();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleTask(MessageTask task) {
        String taskId = task.getTaskId();
        Message message = task.getMessage();
        NotificationContext notificationContext = task.getNotificationContext();
        HelixManager manager = notificationContext.getManager();
        try {
            this.updateStateTransitionMessageThreadPool(message, manager);
            LOG.info("Scheduling message {}: {}:{}, {}->{}", new Object[]{taskId, message.getResourceName(), message.getPartitionName(), message.getFromState(), message.getToState()});
            this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Message handling task scheduled", manager);
            Object object = this._lock;
            synchronized (object) {
                if (!this._taskMap.containsKey(taskId)) {
                    ExecutorService exeSvc = this.findExecutorServiceForMsg(message);
                    if (exeSvc == null) {
                        LOG.warn(String.format("Threadpool is null for type %s of message %s", message.getMsgType(), message.getMsgId()));
                        return false;
                    }
                    LOG.info("Submit task: " + taskId + " to pool: " + exeSvc);
                    Future<HelixTaskResult> future = exeSvc.submit(task);
                    this._messageTaskMap.putIfAbsent(this.getMessageTarget(message.getResourceName(), message.getPartitionName()), taskId);
                    MessageTimeoutTask timerTask = null;
                    if (message.getExecutionTimeout() > 0) {
                        timerTask = new MessageTimeoutTask(this, task);
                        this._timer.schedule((TimerTask)timerTask, message.getExecutionTimeout());
                        LOG.info("Message starts with timeout " + message.getExecutionTimeout() + " MsgId: " + task.getTaskId());
                    } else {
                        LOG.debug("Message does not have timeout. MsgId: " + task.getTaskId());
                    }
                    this._taskMap.put(taskId, new MessageTaskInfo(task, future, timerTask));
                    LOG.info("Message: " + taskId + " handling task scheduled");
                    return true;
                }
                this._statusUpdateUtil.logWarning(message, HelixTaskExecutor.class, "Message handling task already sheduled for " + taskId, manager);
            }
        }
        catch (Exception e) {
            LOG.error("Error while executing task. " + message, (Throwable)e);
            this._statusUpdateUtil.logError(message, HelixTaskExecutor.class, e, "Error while executing task " + e, manager);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTask(MessageTask task) {
        Message message = task.getMessage();
        NotificationContext notificationContext = task.getNotificationContext();
        String taskId = task.getTaskId();
        Object object = this._lock;
        synchronized (object) {
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo taskInfo = this._taskMap.get(taskId);
                if (taskInfo._timerTask != null) {
                    taskInfo._timerTask.cancel();
                }
                Future<HelixTaskResult> future = taskInfo.getFuture();
                this.removeMessageFromTaskAndFutureMap(message);
                this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Canceling task: " + taskId, notificationContext.getManager());
                if (future.cancel(true)) {
                    this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Canceled task: " + taskId, notificationContext.getManager());
                    this._taskMap.remove(taskId);
                    return true;
                }
                this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "fail to cancel task: " + taskId, notificationContext.getManager());
            } else {
                this._statusUpdateUtil.logWarning(message, HelixTaskExecutor.class, "fail to cancel task: " + taskId + ", future not found", notificationContext.getManager());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishTask(MessageTask task) {
        Message message = task.getMessage();
        String taskId = task.getTaskId();
        LOG.info("message finished: " + taskId + ", took " + (new Date().getTime() - message.getExecuteStartTimeStamp()));
        Object object = this._lock;
        synchronized (object) {
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo info = this._taskMap.remove(taskId);
                this.removeMessageFromTaskAndFutureMap(message);
                if (info._timerTask != null) {
                    info._timerTask.cancel();
                }
            } else {
                LOG.warn("message " + taskId + " not found in task map");
            }
        }
    }

    private void updateMessageState(List<Message> readMsgs, HelixDataAccessor accessor, String instanceName) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        ArrayList<PropertyKey> readMsgKeys = new ArrayList<PropertyKey>();
        for (Message msg : readMsgs) {
            readMsgKeys.add(msg.getKey(keyBuilder, instanceName));
            this._knownMessageIds.add(msg.getId());
        }
        accessor.setChildren(readMsgKeys, readMsgs);
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        LOG.info("Shutting down pool: " + pool);
        pool.shutdown();
        try {
            if (!pool.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                List<Runnable> waitingTasks = pool.shutdownNow();
                LOG.info("Tasks that never commenced execution: " + waitingTasks);
                if (!pool.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                    LOG.error("Pool did not fully terminate in 200ms. pool: " + pool);
                }
            }
        }
        catch (InterruptedException ie) {
            LOG.error("Interruped when waiting for shutdown pool: " + pool, (Throwable)ie);
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    void unregisterMessageHandlerFactory(String type) {
        MsgHandlerFactoryRegistryItem item = this._hdlrFtyRegistry.remove(type);
        ExecutorService pool = this._executorMap.remove(type);
        this._monitor.removeExecutorMonitor(type);
        LOG.info("Unregistering message handler factory for type: " + type + ", factory: " + item.factory() + ", pool: " + pool);
        if (pool != null) {
            this.shutdownAndAwaitTermination(pool);
        }
        if (item != null) {
            item.factory().reset();
        }
        LOG.info("Unregistered message handler factory for type: " + type + ", factory: " + item.factory() + ", pool: " + pool);
    }

    void reset() {
        LOG.info("Reset HelixTaskExecutor");
        if (this._messageQueueMonitor != null) {
            this._messageQueueMonitor.reset();
        }
        for (String msgType : this._hdlrFtyRegistry.keySet()) {
            MsgHandlerFactoryRegistryItem item;
            ExecutorService pool = this._executorMap.remove(msgType);
            this._monitor.removeExecutorMonitor(msgType);
            if (pool != null) {
                LOG.info("Reset exectuor for msgType: " + msgType + ", pool: " + pool);
                this.shutdownAndAwaitTermination(pool);
            }
            if ((item = this._hdlrFtyRegistry.get(msgType)).factory() == null) continue;
            item.factory().reset();
        }
        StringBuilder sb = new StringBuilder();
        for (String taskId : this._taskMap.keySet()) {
            MessageTaskInfo info = this._taskMap.get(taskId);
            sb.append("Task: " + taskId + " fails to terminate. Message: " + info._task.getMessage() + "\n");
        }
        LOG.info(sb.toString());
        this._taskMap.clear();
        this._messageTaskMap.clear();
        this._knownMessageIds.clear();
        this._lastSessionSyncTime = null;
    }

    void init() {
        LOG.info("Init HelixTaskExecutor");
        if (this._messageQueueMonitor != null) {
            this._messageQueueMonitor.init();
        }
        this._isShuttingDown = false;
        for (final String msgType : this._hdlrFtyRegistry.keySet()) {
            MsgHandlerFactoryRegistryItem item;
            ExecutorService newPool;
            ExecutorService prevPool = this._executorMap.putIfAbsent(msgType, newPool = Executors.newFixedThreadPool((item = this._hdlrFtyRegistry.get(msgType)).threadPoolSize(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "HelixTaskExecutor-message_handle_" + msgType);
                }
            }));
            if (prevPool != null) {
                LOG.info("Skip init a new thread pool for type: " + msgType + ", already existing pool: " + prevPool + ", isShutdown: " + prevPool.isShutdown());
                newPool.shutdown();
                continue;
            }
            this._monitor.createExecutorMonitor(msgType, newPool);
        }
    }

    private void syncSessionToController(HelixManager manager) {
        PropertyKey key;
        HelixDataAccessor accessor;
        if ((this._lastSessionSyncTime == null || System.currentTimeMillis() - this._lastSessionSyncTime > 2000L) && (accessor = manager.getHelixDataAccessor()).getProperty(key = new PropertyKey.Builder(manager.getClusterName()).controllerMessage(SESSION_SYNC)) == null) {
            LOG.info(String.format("Participant %s syncs session with controller", manager.getInstanceName()));
            Message msg = new Message(Message.MessageType.PARTICIPANT_SESSION_CHANGE, SESSION_SYNC);
            msg.setSrcName(manager.getInstanceName());
            msg.setTgtSessionId("*");
            msg.setMsgState(Message.MessageState.NEW);
            msg.setMsgId(SESSION_SYNC);
            Criteria cr = new Criteria();
            cr.setRecipientInstanceType(InstanceType.CONTROLLER);
            cr.setSessionSpecific(false);
            manager.getMessagingService().send(cr, msg);
            this._lastSessionSyncTime = System.currentTimeMillis();
        }
    }

    private List<Message> readNewMessagesFromZK(HelixManager manager, String instanceName, HelixConstants.ChangeType changeType) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashSet<String> messageIds = new HashSet<String>();
        if (changeType.equals((Object)HelixConstants.ChangeType.MESSAGE)) {
            messageIds.addAll(accessor.getChildNames(keyBuilder.messages(instanceName)));
        } else if (changeType.equals((Object)HelixConstants.ChangeType.MESSAGES_CONTROLLER)) {
            messageIds.addAll(accessor.getChildNames(keyBuilder.controllerMessages()));
        } else {
            LOG.warn("Unexpected ChangeType for Message Change CallbackHandler: " + (Object)((Object)changeType));
            return Collections.emptyList();
        }
        this._knownMessageIds.retainAll(messageIds);
        messageIds.removeAll(this._knownMessageIds);
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        for (String messageId : messageIds) {
            if (changeType.equals((Object)HelixConstants.ChangeType.MESSAGE)) {
                keys.add(keyBuilder.message(instanceName, messageId));
                continue;
            }
            if (!changeType.equals((Object)HelixConstants.ChangeType.MESSAGES_CONTROLLER)) continue;
            keys.add(keyBuilder.controllerMessage(messageId));
        }
        List<Message> newMessages = accessor.getProperty(keys);
        Iterator messageIterator = newMessages.iterator();
        while (messageIterator.hasNext()) {
            if (messageIterator.next() != null) continue;
            messageIterator.remove();
        }
        return newMessages;
    }

    @Override
    @PreFetch(enabled=false)
    public void onMessage(String instanceName, List<Message> messages, NotificationContext changeContext) {
        HelixManager manager = changeContext.getManager();
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            this.reset();
            return;
        }
        if (changeContext.getType() == NotificationContext.Type.INIT) {
            this.init();
        }
        if (messages == null || messages.isEmpty()) {
            messages = this.readNewMessagesFromZK(manager, instanceName, changeContext.getChangeType());
        }
        if (this._isShuttingDown) {
            StringBuilder sb = new StringBuilder();
            for (Message message : messages) {
                sb.append(message.getMsgId() + ",");
            }
            LOG.info("Helix task executor is shutting down, discard unprocessed messages : " + sb.toString());
            return;
        }
        if (this._messageQueueMonitor != null) {
            this._messageQueueMonitor.setMessageQueueBacklog(messages.size());
        }
        if (messages.isEmpty()) {
            LOG.info("No Messages to process");
            return;
        }
        Collections.sort(messages, Message.CREATE_TIME_COMPARATOR);
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashMap<String, MessageHandler> stateTransitionHandlers = new HashMap<String, MessageHandler>();
        HashMap<String, NotificationContext> stateTransitionContexts = new HashMap<String, NotificationContext>();
        ArrayList<MessageHandler> nonStateTransitionHandlers = new ArrayList<MessageHandler>();
        ArrayList<NotificationContext> nonStateTransitionContexts = new ArrayList<NotificationContext>();
        ArrayList<Message> readMsgs = new ArrayList<Message>();
        String sessionId = manager.getSessionId();
        List<String> curResourceNames = accessor.getChildNames(keyBuilder.currentStates(instanceName, sessionId));
        ArrayList<PropertyKey> createCurStateKeys = new ArrayList<PropertyKey>();
        ArrayList<CurrentState> metaCurStates = new ArrayList<CurrentState>();
        HashSet<String> createCurStateNames = new HashSet<String>();
        for (Message message : messages) {
            String resourceName;
            boolean success;
            if (message.getMsgType().equalsIgnoreCase(Message.MessageType.NO_OP.toString())) {
                LOG.info("Dropping NO-OP message. mid: " + message.getId() + ", from: " + message.getMsgSrc());
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                continue;
            }
            if (message.isExpired()) {
                LOG.info("Dropping expired message. mid: " + message.getId() + ", from: " + message.getMsgSrc() + " relayed from: " + message.getRelaySrcHost());
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                continue;
            }
            String tgtSessionId = message.getTgtSessionId();
            if (!sessionId.equals(tgtSessionId) && !tgtSessionId.equals("*")) {
                String warningMessage = "SessionId does NOT match. expected sessionId: " + sessionId + ", tgtSessionId in message: " + tgtSessionId + ", messageId: " + message.getMsgId();
                LOG.warn(warningMessage);
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                this._statusUpdateUtil.logWarning(message, HelixStateMachineEngine.class, warningMessage, manager);
                if (manager.getInstanceType() != InstanceType.PARTICIPANT && manager.getInstanceType() != InstanceType.CONTROLLER_PARTICIPANT || message.getCreateTimeStamp() <= manager.getSessionStartTime()) continue;
                this.syncSessionToController(manager);
                continue;
            }
            if ((manager.getInstanceType() == InstanceType.CONTROLLER || manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) && Message.MessageType.PARTICIPANT_SESSION_CHANGE.name().equals(message.getMsgType())) {
                LOG.info(String.format("Controller received PARTICIPANT_SESSION_CHANGE msg from src: %s", message.getMsgSrc()));
                PropertyKey key = new PropertyKey.Builder(manager.getClusterName()).liveInstances();
                List<LiveInstance> liveInstances = manager.getHelixDataAccessor().getChildValues(key);
                this._controller.onLiveInstanceChange(liveInstances, changeContext);
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.COMPLETED);
                continue;
            }
            if (Message.MessageState.NEW != message.getMsgState()) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Message already read. msgId: " + message.getMsgId());
                continue;
            }
            if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION_CANCELLATION.name()) && (success = this.cancelNotStartedStateTransition(message, stateTransitionHandlers, accessor, instanceName))) continue;
            this._monitor.reportReceivedMessage(message);
            NotificationContext msgWorkingContext = changeContext.clone();
            try {
                MessageHandler createHandler = this.createMessageHandler(message, msgWorkingContext);
                if (createHandler == null) continue;
                if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) || message.getMsgType().equals(Message.MessageType.STATE_TRANSITION_CANCELLATION.name())) {
                    String messageTarget = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
                    if (stateTransitionHandlers.containsKey(messageTarget)) {
                        Message duplicatedMessage = ((MessageHandler)stateTransitionHandlers.get((Object)messageTarget))._message;
                        throw new HelixException(String.format("Duplicated state transition message: %s. Existing: %s->%s; New (Discarded): %s->%s", message.getMsgId(), duplicatedMessage.getFromState(), duplicatedMessage.getToState(), message.getFromState(), message.getToState()));
                    }
                    if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) && this.isStateTransitionInProgress(messageTarget)) {
                        throw new HelixException(String.format("Another state transition for %s:%s is in progress. Discarding %s->%s message", message.getResourceName(), message.getPartitionName(), message.getFromState(), message.getToState()));
                    }
                    stateTransitionHandlers.put(this.getMessageTarget(message.getResourceName(), message.getPartitionName()), createHandler);
                    stateTransitionContexts.put(this.getMessageTarget(message.getResourceName(), message.getPartitionName()), msgWorkingContext);
                } else {
                    nonStateTransitionHandlers.add(createHandler);
                    nonStateTransitionContexts.add(msgWorkingContext);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to create message handler for " + message.getMsgId(), (Throwable)e);
                String error = "Failed to create message handler for " + message.getMsgId() + ", exception: " + e;
                this._statusUpdateUtil.logError(message, HelixStateMachineEngine.class, e, error, manager);
                message.setMsgState(Message.MessageState.UNPROCESSABLE);
                this.removeMessageFromZK(accessor, message, instanceName);
                LOG.error("Message cannot be processed: " + message.getRecord(), (Throwable)e);
                this._monitor.reportProcessedMessage(message, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                continue;
            }
            this.markReadMessage(message, msgWorkingContext, manager);
            readMsgs.add(message);
            if (message.isControlerMsg() || !message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) || curResourceNames.contains(resourceName = message.getResourceName()) || createCurStateNames.contains(resourceName)) continue;
            createCurStateNames.add(resourceName);
            createCurStateKeys.add(keyBuilder.currentState(instanceName, sessionId, resourceName));
            CurrentState metaCurState = new CurrentState(resourceName);
            metaCurState.setBucketSize(message.getBucketSize());
            metaCurState.setStateModelDefRef(message.getStateModelDef());
            metaCurState.setSessionId(sessionId);
            metaCurState.setBatchMessageMode(message.getBatchMessageMode());
            String ftyName = message.getStateModelFactoryName();
            if (ftyName != null) {
                metaCurState.setStateModelFactoryName(ftyName);
            } else {
                metaCurState.setStateModelFactoryName("DEFAULT");
            }
            metaCurStates.add(metaCurState);
        }
        if (createCurStateKeys.size() > 0) {
            try {
                accessor.createChildren(createCurStateKeys, metaCurStates);
            }
            catch (Exception e) {
                LOG.error("fail to create cur-state znodes for messages: " + readMsgs, (Throwable)e);
            }
        }
        if (readMsgs.size() > 0) {
            this.updateMessageState(readMsgs, accessor, instanceName);
            for (Map.Entry entry : stateTransitionHandlers.entrySet()) {
                MessageHandler handler = (MessageHandler)entry.getValue();
                NotificationContext context = (NotificationContext)stateTransitionContexts.get(entry.getKey());
                Message msg = handler._message;
                this.scheduleTask(new HelixTask(msg, context, handler, this));
            }
            for (int i = 0; i < nonStateTransitionHandlers.size(); ++i) {
                MessageHandler messageHandler = (MessageHandler)nonStateTransitionHandlers.get(i);
                NotificationContext context = (NotificationContext)nonStateTransitionContexts.get(i);
                Message msg = messageHandler._message;
                this.scheduleTask(new HelixTask(msg, context, messageHandler, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStateTransitionInProgress(String messageTarget) {
        Object object = this._lock;
        synchronized (object) {
            if (this._messageTaskMap.containsKey(messageTarget)) {
                String taskId = this._messageTaskMap.get(messageTarget);
                boolean bl = !this._taskMap.get(taskId).getFuture().isDone();
                return bl;
            }
            return false;
        }
    }

    private boolean cancelNotStartedStateTransition(Message message, Map<String, MessageHandler> stateTransitionHandlers, HelixDataAccessor accessor, String instanceName) {
        ParticipantMessageMonitor.ProcessedMessageState messageState;
        Message targetStateTransitionMessage;
        String targetMessageName = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
        if (stateTransitionHandlers.containsKey(targetMessageName)) {
            targetStateTransitionMessage = stateTransitionHandlers.get(targetMessageName).getMessage();
            if (this.isCancelingSameStateTransition(targetStateTransitionMessage, message)) {
                stateTransitionHandlers.remove(targetMessageName);
                messageState = ParticipantMessageMonitor.ProcessedMessageState.COMPLETED;
            } else {
                messageState = ParticipantMessageMonitor.ProcessedMessageState.DISCARDED;
            }
        } else if (this._messageTaskMap.containsKey(targetMessageName)) {
            String taskId = this._messageTaskMap.get(targetMessageName);
            HelixTask task = (HelixTask)this._taskMap.get(taskId).getTask();
            Future<HelixTaskResult> future = this._taskMap.get(taskId).getFuture();
            targetStateTransitionMessage = task.getMessage();
            if (this.isCancelingSameStateTransition(task.getMessage(), message)) {
                boolean success = task.cancel();
                if (!success) {
                    return false;
                }
                future.cancel(false);
                this._messageTaskMap.remove(targetMessageName);
                this._taskMap.remove(taskId);
                messageState = ParticipantMessageMonitor.ProcessedMessageState.COMPLETED;
            } else {
                messageState = ParticipantMessageMonitor.ProcessedMessageState.DISCARDED;
            }
        } else {
            return false;
        }
        this.removeMessageFromZK(accessor, targetStateTransitionMessage, instanceName);
        this._monitor.reportProcessedMessage(targetStateTransitionMessage, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
        this.reportAndRemoveMessage(message, accessor, instanceName, messageState);
        return true;
    }

    private void reportAndRemoveMessage(Message message, HelixDataAccessor accessor, String instanceName, ParticipantMessageMonitor.ProcessedMessageState messageProcessState) {
        this._monitor.reportReceivedMessage(message);
        this._monitor.reportProcessedMessage(message, messageProcessState);
        this.removeMessageFromZK(accessor, message, instanceName);
    }

    private void markReadMessage(Message message, NotificationContext context, HelixManager manager) {
        message.setMsgState(Message.MessageState.READ);
        message.setReadTimeStamp(new Date().getTime());
        message.setExecuteSessionId(context.getManager().getSessionId());
        this._statusUpdateUtil.logInfo(message, HelixStateMachineEngine.class, "New Message", manager);
    }

    public MessageHandler createMessageHandler(Message message, NotificationContext changeContext) {
        String msgType = message.getMsgType().toString();
        MsgHandlerFactoryRegistryItem item = this._hdlrFtyRegistry.get(msgType);
        if (item == null) {
            LOG.warn("Fail to find message handler factory for type: " + msgType + " msgId: " + message.getMsgId());
            return null;
        }
        MessageHandlerFactory handlerFactory = item.factory();
        changeContext.add(NotificationContext.MapKey.TASK_EXECUTOR.toString(), this);
        return handlerFactory.createHandler(message, changeContext);
    }

    private void removeMessageFromTaskAndFutureMap(Message message) {
        this._knownMessageIds.remove(message.getId());
        String messageTarget = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
        if (this._messageTaskMap.containsKey(messageTarget)) {
            this._messageTaskMap.remove(messageTarget);
        }
    }

    private boolean isCancelingSameStateTransition(Message stateTranstionMessage, Message cancellationMessage) {
        return stateTranstionMessage.getFromState().equalsIgnoreCase(cancellationMessage.getFromState()) && stateTranstionMessage.getToState().equalsIgnoreCase(cancellationMessage.getToState());
    }

    private String getMessageTarget(String resourceName, String partitionName) {
        return String.format("%s_%s", resourceName, partitionName);
    }

    private String getStateTransitionType(String prefix, String fromState, String toState) {
        if (prefix == null || fromState == null || toState == null) {
            return null;
        }
        return String.format("%s.%s.%s", prefix, fromState, toState);
    }

    private String getPerResourceStateTransitionPoolName(String resourceName) {
        return Message.MessageType.STATE_TRANSITION.name() + "." + resourceName;
    }

    private void removeMessageFromZK(HelixDataAccessor accessor, Message message, String instanceName) {
        if (HelixUtil.removeMessageFromZK(accessor, message, instanceName)) {
            LOG.info("Successfully removed message {} from ZK.", (Object)message.getMsgId());
        } else {
            LOG.warn("Failed to remove message {} from ZK.", (Object)message.getMsgId());
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down HelixTaskExecutor");
        this._isShuttingDown = true;
        this._timer.cancel();
        this.reset();
        this._monitor.shutDown();
        LOG.info("Shutdown HelixTaskExecutor finished");
    }

    class MsgHandlerFactoryRegistryItem {
        private final MessageHandlerFactory _factory;
        private final int _threadPoolSize;

        public MsgHandlerFactoryRegistryItem(MessageHandlerFactory factory, int threadPoolSize) {
            if (factory == null) {
                throw new NullPointerException("Message handler factory is null");
            }
            if (threadPoolSize <= 0) {
                throw new IllegalArgumentException("Illegal thread pool size: " + threadPoolSize);
            }
            this._factory = factory;
            this._threadPoolSize = threadPoolSize;
        }

        int threadPoolSize() {
            return this._threadPoolSize;
        }

        MessageHandlerFactory factory() {
            return this._factory;
        }
    }
}

