/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import org.apache.helix.monitoring.mbeans.JobMonitorMBean;
import org.apache.helix.task.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMonitor
implements JobMonitorMBean {
    private static final String JOB_KEY = "Job";
    private static final Logger LOG = LoggerFactory.getLogger(JobMonitor.class);
    private static final long DEFAULT_RESET_INTERVAL_MS = 3600000L;
    private String _clusterName;
    private String _jobType;
    private long _successfullJobCount;
    private long _failedJobCount;
    private long _abortedJobCount;
    private long _existingJobGauge;
    private long _queuedJobGauge;
    private long _runningJobGauge;
    private long _maximumJobLatencyGauge;
    private long _jobLatencyCount;
    private long _lastResetTime;

    public JobMonitor(String clusterName, String jobType) {
        this._clusterName = clusterName;
        this._jobType = jobType;
        this._successfullJobCount = 0L;
        this._failedJobCount = 0L;
        this._abortedJobCount = 0L;
        this._existingJobGauge = 0L;
        this._queuedJobGauge = 0L;
        this._runningJobGauge = 0L;
        this._lastResetTime = System.currentTimeMillis();
        this._jobLatencyCount = 0L;
        this._maximumJobLatencyGauge = 0L;
    }

    @Override
    public long getSuccessfulJobCount() {
        return this._successfullJobCount;
    }

    @Override
    public long getFailedJobCount() {
        return this._failedJobCount;
    }

    @Override
    public long getAbortedJobCount() {
        return this._abortedJobCount;
    }

    @Override
    public long getExistingJobGauge() {
        return this._existingJobGauge;
    }

    @Override
    public long getQueuedJobGauge() {
        return this._queuedJobGauge;
    }

    @Override
    public long getRunningJobGauge() {
        return this._runningJobGauge;
    }

    @Override
    public long getMaximumJobLatencyGauge() {
        return this._maximumJobLatencyGauge;
    }

    @Override
    public long getJobLatencyCount() {
        return this._jobLatencyCount;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._clusterName, JOB_KEY, this._jobType);
    }

    public String getJobType() {
        return this._jobType;
    }

    public void updateJobCounters(TaskState to) {
        this.updateJobCounters(to, 0L);
    }

    public void updateJobCounters(TaskState to, long latency) {
        if (to.equals((Object)TaskState.FAILED) || to.equals((Object)TaskState.TIMED_OUT)) {
            ++this._failedJobCount;
        } else if (to.equals((Object)TaskState.COMPLETED)) {
            ++this._successfullJobCount;
            this._maximumJobLatencyGauge = Math.max(this._maximumJobLatencyGauge, latency);
            this._jobLatencyCount += latency > 0L ? latency : 0L;
        } else if (to.equals((Object)TaskState.ABORTED)) {
            ++this._abortedJobCount;
        }
    }

    public void resetJobGauge() {
        this._queuedJobGauge = 0L;
        this._existingJobGauge = 0L;
        this._runningJobGauge = 0L;
        if (this._lastResetTime + 3600000L < System.currentTimeMillis()) {
            this._lastResetTime = System.currentTimeMillis();
            this._maximumJobLatencyGauge = 0L;
        }
    }

    public void updateJobGauge(TaskState to) {
        ++this._existingJobGauge;
        if (to == null || to.equals((Object)TaskState.NOT_STARTED)) {
            ++this._queuedJobGauge;
        } else if (to.equals((Object)TaskState.IN_PROGRESS)) {
            ++this._runningJobGauge;
        }
    }
}

