/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistrar {
    private static Logger LOG = LoggerFactory.getLogger(MBeanRegistrar.class);
    public static final String DUPLICATE = "Duplicate";
    public static final int MAX_NUM_DUPLICATED_MONITORS = 1000;
    private static MBeanServer _beanServer = ManagementFactory.getPlatformMBeanServer();

    public static ObjectName register(Object object, ObjectName objectName) throws JMException {
        for (int num = 0; num < 1000; ++num) {
            ObjectName newObjectName = num > 0 ? new ObjectName(String.format("%s,%s=%s", objectName.toString(), DUPLICATE, String.valueOf(num))) : objectName;
            try {
                _beanServer.registerMBean(object, newObjectName);
            }
            catch (InstanceAlreadyExistsException e) {
                continue;
            }
            catch (JMException e) {
                LOG.error(String.format("Error in registering: %s", objectName.getCanonicalName()), (Throwable)e);
                return null;
            }
            return newObjectName;
        }
        LOG.error(String.format("There're already %d %s, no more will be registered.", 1000, objectName.getCanonicalName()));
        return null;
    }

    public static ObjectName register(Object object, String domain, String ... keyValuePairs) throws JMException {
        return MBeanRegistrar.register(object, MBeanRegistrar.buildObjectName(domain, keyValuePairs));
    }

    public static void unregister(ObjectName objectName) {
        if (objectName != null && _beanServer.isRegistered(objectName)) {
            try {
                _beanServer.unregisterMBean(objectName);
            }
            catch (JMException e) {
                LOG.warn("Error in un-registering: " + objectName.getCanonicalName(), (Throwable)e);
            }
        }
    }

    public static ObjectName buildObjectName(String domain, String ... keyValuePairs) throws MalformedObjectNameException {
        if (keyValuePairs.length < 2 || keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("key-value pairs for ObjectName must contain even number of String and at least 2 String");
        }
        StringBuilder objectNameStr = new StringBuilder();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            objectNameStr.append(String.format(i == 0 ? "%s=%s" : ",%s=%s", keyValuePairs[i], keyValuePairs[i + 1]));
        }
        return new ObjectName(String.format("%s:%s", domain, objectNameStr.toString()));
    }
}

