/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.zookeeper.ZkEventThread;
import org.apache.helix.monitoring.mbeans.MBeanRegistrar;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.ZkClientMonitorMBean;
import org.apache.helix.monitoring.mbeans.ZkClientPathMonitor;

public class ZkClientMonitor
implements ZkClientMonitorMBean {
    public static final String MONITOR_TYPE = "Type";
    public static final String MONITOR_KEY = "Key";
    private ObjectName _objectName;
    private String _sensorName;
    private long _stateChangeEventCounter;
    private long _dataChangeEventCounter;
    private ZkEventThread _zkEventThread;
    private Map<ZkClientPathMonitor.PredefinedPath, ZkClientPathMonitor> _zkClientPathMonitorMap = new ConcurrentHashMap<ZkClientPathMonitor.PredefinedPath, ZkClientPathMonitor>();

    public ZkClientMonitor(String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootPathOnly) throws JMException {
        if (monitorKey == null || monitorKey.isEmpty() || monitorType == null || monitorType.isEmpty()) {
            throw new HelixException("Cannot create ZkClientMonitor without monitor key and type.");
        }
        this._sensorName = String.format("%s.%s.%s", MonitorDomainNames.HelixZkClient.name(), monitorType, monitorKey);
        this._objectName = MBeanRegistrar.register(this, ZkClientMonitor.getObjectName(monitorType, monitorKey, monitorInstanceName));
        for (ZkClientPathMonitor.PredefinedPath path : ZkClientPathMonitor.PredefinedPath.values()) {
            if (monitorRootPathOnly && !path.equals((Object)ZkClientPathMonitor.PredefinedPath.Root)) continue;
            this._zkClientPathMonitorMap.put(path, new ZkClientPathMonitor(path, monitorType, monitorKey, monitorInstanceName).register());
        }
    }

    public void setZkEventThread(ZkEventThread zkEventThread) {
        this._zkEventThread = zkEventThread;
    }

    protected static ObjectName getObjectName(String monitorType, String monitorKey, String monitorInstanceName) throws MalformedObjectNameException {
        return MBeanRegistrar.buildObjectName(MonitorDomainNames.HelixZkClient.name(), MONITOR_TYPE, monitorType, MONITOR_KEY, monitorKey + (monitorInstanceName == null ? "" : "." + monitorInstanceName));
    }

    public void unregister() {
        MBeanRegistrar.unregister(this._objectName);
        for (ZkClientPathMonitor zkClientPathMonitor : this._zkClientPathMonitorMap.values()) {
            zkClientPathMonitor.unregister();
        }
    }

    @Override
    public String getSensorName() {
        return this._sensorName;
    }

    public void increaseStateChangeEventCounter() {
        ++this._stateChangeEventCounter;
    }

    @Override
    public long getStateChangeEventCounter() {
        return this._stateChangeEventCounter;
    }

    public void increaseDataChangeEventCounter() {
        ++this._dataChangeEventCounter;
    }

    @Override
    public long getDataChangeEventCounter() {
        return this._dataChangeEventCounter;
    }

    @Override
    public long getPendingCallbackGauge() {
        if (this._zkEventThread != null) {
            return this._zkEventThread.getPendingEventsCount();
        }
        return -1L;
    }

    @Override
    public long getTotalCallbackCounter() {
        if (this._zkEventThread != null) {
            return this._zkEventThread.getTotalEventCount();
        }
        return -1L;
    }

    @Override
    public long getTotalCallbackHandledCounter() {
        if (this._zkEventThread != null) {
            return this._zkEventThread.getTotalHandledEventCount();
        }
        return -1L;
    }

    private void record(String path, int bytes, long latencyMilliSec, boolean isFailure, boolean isRead) {
        for (ZkClientPathMonitor.PredefinedPath predefinedPath : ZkClientPathMonitor.PredefinedPath.values()) {
            ZkClientPathMonitor zkClientPathMonitor;
            if (!predefinedPath.match(path) || (zkClientPathMonitor = this._zkClientPathMonitorMap.get((Object)predefinedPath)) == null) continue;
            zkClientPathMonitor.record(bytes, latencyMilliSec, isFailure, isRead);
        }
    }

    public void record(String path, int dataSize, long startTimeMilliSec, AccessType accessType) {
        switch (accessType) {
            case READ: {
                this.record(path, dataSize, System.currentTimeMillis() - startTimeMilliSec, false, true);
                return;
            }
            case WRITE: {
                this.record(path, dataSize, System.currentTimeMillis() - startTimeMilliSec, false, false);
                return;
            }
        }
    }

    public void recordFailure(String path, AccessType accessType) {
        switch (accessType) {
            case READ: {
                this.record(path, 0, 0L, true, true);
                return;
            }
            case WRITE: {
                this.record(path, 0, 0L, true, false);
                return;
            }
        }
    }

    public static enum AccessType {
        READ,
        WRITE;

    }
}

