/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.AbstractHelixLeaderStandbyStateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StateModelInfo(initialState="OFFLINE", states={"LEADER", "STANDBY"})
public class DistClusterControllerStateModel
extends AbstractHelixLeaderStandbyStateModel {
    private static Logger logger = LoggerFactory.getLogger(DistClusterControllerStateModel.class);
    protected HelixManager _controller = null;

    public DistClusterControllerStateModel(String zkAddr) {
        super(zkAddr);
    }

    @Override
    public void onBecomeStandbyFromOffline(Message message, NotificationContext context) {
        this.logStateTransition("OFFLINE", "STANDBY", message.getPartitionName(), message.getTgtName());
    }

    @Override
    public void onBecomeLeaderFromStandby(Message message, NotificationContext context) throws Exception {
        String clusterName = message.getPartitionName();
        String controllerName = message.getTgtName();
        logger.info(controllerName + " becoming leader from standby for " + clusterName);
        if (this._controller == null) {
            this._controller = HelixManagerFactory.getZKHelixManager(clusterName, controllerName, InstanceType.CONTROLLER, this._zkAddr);
            this._controller.connect();
            this._controller.startTimerTasks();
            this.logStateTransition("STANDBY", "LEADER", clusterName, controllerName);
        } else {
            logger.error("controller already exists:" + this._controller.getInstanceName() + " for " + clusterName);
        }
    }

    @Override
    public void onBecomeStandbyFromLeader(Message message, NotificationContext context) {
        String clusterName = message.getPartitionName();
        String controllerName = message.getTgtName();
        logger.info(controllerName + " becoming standby from leader for " + clusterName);
        if (this._controller != null) {
            this.reset();
            this.logStateTransition("LEADER", "STANDBY", clusterName, controllerName);
        } else {
            logger.error("No controller exists for " + clusterName);
        }
    }

    @Override
    public void onBecomeOfflineFromStandby(Message message, NotificationContext context) {
        this.logStateTransition("STANDBY", "OFFLINE", message.getPartitionName(), message.getTgtName());
    }

    @Override
    public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
        this.reset();
        this.logStateTransition("OFFLINE", "DROPPED", message == null ? "" : message.getPartitionName(), message == null ? "" : message.getTgtName());
    }

    @Override
    public String getStateModeInstanceDescription(String partitionName, String instanceName) {
        return String.format("Controller for cluster %s on instance %s", partitionName, instanceName);
    }

    @Override
    public void reset() {
        if (this._controller != null) {
            this._controller.disconnect();
            this._controller = null;
        }
    }
}

