/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.assigner.AssignableInstance;
import org.apache.helix.task.assigner.TaskAssignResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedTargetTaskAssignmentCalculator
extends TaskAssignmentCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(FixedTargetTaskAssignmentCalculator.class);
    private AssignableInstanceManager _assignableInstanceManager;

    @Deprecated
    public FixedTargetTaskAssignmentCalculator() {
    }

    public FixedTargetTaskAssignmentCalculator(AssignableInstanceManager assignableInstanceManager) {
        this._assignableInstanceManager = assignableInstanceManager;
    }

    @Override
    public Set<Integer> getAllTaskPartitions(JobConfig jobCfg, JobContext jobCtx, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Map<String, IdealState> idealStateMap) {
        IdealState tgtIs = idealStateMap.get(jobCfg.getTargetResource());
        return FixedTargetTaskAssignmentCalculator.getAllTaskPartitions(tgtIs, jobCfg, jobCtx);
    }

    @Override
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, Map<String, IdealState> idealStateMap) {
        return this.computeAssignmentAndChargeResource(currStateOutput, prevAssignment, instances, workflowCfg, jobCfg, jobContext, partitionSet, idealStateMap);
    }

    private static Set<Integer> getAllTaskPartitions(IdealState tgtResourceIs, JobConfig jobCfg, JobContext taskCtx) {
        Map<String, List<Integer>> currentTargets = taskCtx.getPartitionsByTarget();
        TreeSet targetPartitions = Sets.newTreeSet();
        if (jobCfg.getTargetPartitions() != null) {
            targetPartitions.addAll(jobCfg.getTargetPartitions());
        } else if (tgtResourceIs != null) {
            targetPartitions.addAll(tgtResourceIs.getPartitionSet());
        } else {
            LOG.warn("Missing target resource for the scheduled job!");
        }
        TreeSet taskPartitions = Sets.newTreeSet();
        for (String targetPartition : targetPartitions) {
            taskPartitions.addAll(FixedTargetTaskAssignmentCalculator.getPartitionsForTargetPartition(targetPartition, currentTargets, taskCtx));
        }
        return taskPartitions;
    }

    private static List<Integer> getPartitionsForTargetPartition(String targetPartition, Map<String, List<Integer>> currentTargets, JobContext jobCtx) {
        if (!currentTargets.containsKey(targetPartition)) {
            int nextId = jobCtx.getPartitionSet().size();
            jobCtx.setPartitionTarget(nextId, targetPartition);
            return Lists.newArrayList((Object[])new Integer[]{nextId});
        }
        return currentTargets.get(targetPartition);
    }

    @Deprecated
    private static Map<String, SortedSet<Integer>> getTgtPartitionAssignment(CurrentStateOutput currStateOutput, Iterable<String> instances, IdealState tgtIs, Set<String> tgtStates, Set<Integer> includeSet, JobContext jobCtx) {
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : instances) {
            result.put(instance, new TreeSet());
        }
        Map<String, List<Integer>> partitionsByTarget = jobCtx.getPartitionsByTarget();
        for (String pName : tgtIs.getPartitionSet()) {
            int pId;
            List<Integer> partitions = partitionsByTarget.get(pName);
            if (partitions == null || partitions.size() < 1 || !includeSet.contains(pId = partitions.get(0).intValue())) continue;
            for (String instance : instances) {
                String s;
                Message pendingMessage = currStateOutput.getPendingState(tgtIs.getResourceName(), new Partition(pName), instance);
                if (pendingMessage != null || (s = currStateOutput.getCurrentState(tgtIs.getResourceName(), new Partition(pName), instance)) == null || tgtStates != null && !tgtStates.contains(s)) continue;
                ((SortedSet)result.get(instance)).add(pId);
            }
        }
        return result;
    }

    private Map<String, SortedSet<Integer>> computeAssignmentAndChargeResource(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> liveInstances, WorkflowConfig workflowCfg, JobConfig jobCfg, JobContext jobContext, Set<Integer> taskPartitionSet, Map<String, IdealState> idealStateMap) {
        Map<String, AssignableInstance> assignableInstanceMap = this._assignableInstanceManager.getAssignableInstanceMap();
        String quotaType = this.getQuotaType(workflowCfg, jobCfg);
        IdealState targetIdealState = idealStateMap.get(jobCfg.getTargetResource());
        if (targetIdealState == null) {
            LOG.warn("Missing target resource for the scheduled job!");
            return Collections.emptyMap();
        }
        Set<String> targetStates = jobCfg.getTargetPartitionStates();
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : liveInstances) {
            result.put(instance, new TreeSet());
        }
        Map<String, List<Integer>> partitionsByTarget = jobContext.getPartitionsByTarget();
        block1: for (String targetResourcePartitionName : targetIdealState.getPartitionSet()) {
            int targetPartitionId;
            List<Integer> taskPartitions = partitionsByTarget.get(targetResourcePartitionName);
            if (taskPartitions == null || taskPartitions.size() < 1 || !taskPartitionSet.contains(targetPartitionId = taskPartitions.get(0).intValue())) continue;
            for (String instance : liveInstances) {
                String currentState;
                Message pendingMessage = currStateOutput.getPendingState(targetIdealState.getResourceName(), new Partition(targetResourcePartitionName), instance);
                if (pendingMessage != null || (currentState = currStateOutput.getCurrentState(targetIdealState.getResourceName(), new Partition(targetResourcePartitionName), instance)) == null || targetStates != null && !targetStates.contains(currentState)) continue;
                String pName = String.format("%s_%s", jobCfg.getJobId(), targetPartitionId);
                if (!jobCfg.getTaskConfigMap().containsKey(pName)) {
                    jobCfg.getTaskConfigMap().put(pName, new TaskConfig(null, null, pName, targetResourcePartitionName));
                }
                TaskConfig taskConfig = jobCfg.getTaskConfigMap().get(pName);
                Map<String, String> instanceMap = prevAssignment.getReplicaMap(new Partition(pName));
                Iterator<String> itr = instanceMap.keySet().iterator();
                if (itr.hasNext()) {
                    String prevInstance = itr.next();
                    if (prevInstance.equals(instance)) continue block1;
                    if (assignableInstanceMap.containsKey(prevInstance)) {
                        assignableInstanceMap.get(prevInstance).release(taskConfig, quotaType);
                    } else {
                        LOG.warn("Task {} was reassigned from old instance: {} to new instance: {}. However, old instance: {} is not found in AssignableInstanceMap. The old instance is possibly no longer a LiveInstance. This task will not be released.", new Object[]{pName, prevAssignment, instance});
                    }
                }
                if (assignableInstanceMap.containsKey(instance)) {
                    AssignableInstance assignableInstance = assignableInstanceMap.get(instance);
                    TaskAssignResult taskAssignResult = assignableInstance.tryAssign(taskConfig, quotaType);
                    if (taskAssignResult.isSuccessful()) {
                        assignableInstance.assign(taskAssignResult);
                        ((SortedSet)result.get(instance)).add(targetPartitionId);
                        continue block1;
                    }
                    if (!taskAssignResult.isSuccessful() && taskAssignResult.getFailureReason() == TaskAssignResult.FailureReason.TASK_ALREADY_ASSIGNED) {
                        ((SortedSet)result.get(instance)).add(targetPartitionId);
                        continue block1;
                    }
                    LOG.warn("Unable to assign the task to this AssignableInstance. Skipping this instance. Task: {}, Instance: {}, TaskAssignResult: {}", new Object[]{pName, instance, taskAssignResult});
                    continue;
                }
                LOG.error("AssignableInstance does not exist for this LiveInstance: {}. This should never happen! Will not assign to this instance.", (Object)instance);
            }
        }
        return result;
    }
}

