/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskCallbackContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskFactory;
import org.apache.helix.task.TaskResult;
import org.apache.helix.task.TaskRunner;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.UserContentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StateModelInfo(states={"{'NOT USED BY HELIX'}"}, initialState="INIT")
public class TaskStateModel
extends StateModel {
    private static final Logger LOG = LoggerFactory.getLogger(TaskStateModel.class);
    private final HelixManager _manager;
    private final ScheduledExecutorService _taskExecutor;
    private final Map<String, TaskFactory> _taskFactoryRegistry;
    private ScheduledFuture timeout_task;
    private TaskRunner _taskRunner;
    private final ScheduledExecutorService _timeoutTaskExecutor;

    public TaskStateModel(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry, ScheduledExecutorService taskExecutor) {
        this(manager, taskFactoryRegistry, taskExecutor, taskExecutor);
    }

    public TaskStateModel(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry, ScheduledExecutorService taskExecutor, ScheduledExecutorService timerTaskExecutor) {
        this._manager = manager;
        this._taskFactoryRegistry = taskFactoryRegistry;
        this._taskExecutor = taskExecutor;
        this._timeoutTaskExecutor = timerTaskExecutor;
    }

    public boolean isShutdown() {
        return this._taskExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this._taskExecutor.isTerminated();
    }

    public void shutdown() {
        this.reset();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this._taskExecutor.awaitTermination(timeout, unit);
    }

    @Transition(to="RUNNING", from="INIT")
    public void onBecomeRunningFromInit(Message msg, NotificationContext context) {
        this.startTask(msg, msg.getPartitionName());
    }

    @Transition(to="STOPPED", from="RUNNING")
    public String onBecomeStoppedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        LOG.info(String.format("Task %s completed with result %s.", msg.getPartitionName(), r));
        this.timeout_task.cancel(false);
        return r.getInfo();
    }

    @Transition(to="COMPLETED", from="RUNNING")
    public String onBecomeCompletedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.COMPLETED) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
        this.timeout_task.cancel(false);
        return r.getInfo();
    }

    @Transition(to="TIMED_OUT", from="RUNNING")
    public String onBecomeTimedOutFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.CANCELED) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
        this.timeout_task.cancel(false);
        return r.getInfo();
    }

    @Transition(to="TASK_ERROR", from="RUNNING")
    public String onBecomeTaskErrorFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.ERROR && r.getStatus() != TaskResult.Status.FAILED) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
        this.timeout_task.cancel(false);
        return r.getInfo();
    }

    @Transition(to="TASK_ABORTED", from="RUNNING")
    public String onBecomeTaskAbortedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.FATAL_FAILED && r.getStatus() != TaskResult.Status.CANCELED) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
        this.timeout_task.cancel(false);
        return r.getInfo();
    }

    @Transition(to="RUNNING", from="STOPPED")
    public void onBecomeRunningFromStopped(Message msg, NotificationContext context) {
        this.startTask(msg, msg.getPartitionName());
    }

    @Transition(to="DROPPED", from="INIT")
    public void onBecomeDroppedFromInit(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="DROPPED", from="RUNNING")
    public void onBecomeDroppedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        LOG.info(String.format("Task partition %s returned result %s.", msg.getPartitionName(), r));
        this._taskRunner = null;
        this.timeout_task.cancel(false);
    }

    @Transition(to="DROPPED", from="COMPLETED")
    public void onBecomeDroppedFromCompleted(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="DROPPED", from="STOPPED")
    public void onBecomeDroppedFromStopped(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="DROPPED", from="TIMED_OUT")
    public void onBecomeDroppedFromTimedOut(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="DROPPED", from="TASK_ERROR")
    public void onBecomeDroppedFromTaskError(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="DROPPED", from="TASK_ABORTED")
    public void onBecomeDroppedFromTaskAborted(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="INIT", from="RUNNING")
    public void onBecomeInitFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        LOG.info(String.format("Task partition %s returned result %s.", msg.getPartitionName(), r));
        this._taskRunner = null;
    }

    @Transition(to="INIT", from="COMPLETED")
    public void onBecomeInitFromCompleted(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="INIT", from="STOPPED")
    public void onBecomeInitFromStopped(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="INIT", from="TIMED_OUT")
    public void onBecomeInitFromTimedOut(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="INIT", from="TASK_ERROR")
    public void onBecomeInitFromTaskError(Message msg, NotificationContext context) {
        this.reset();
    }

    @Transition(to="INIT", from="TASK_ABORTED")
    public void onBecomeInitFromTaskAborted(Message msg, NotificationContext context) {
        this.reset();
    }

    @Override
    public void reset() {
        if (this._taskRunner != null) {
            this._taskRunner.cancel();
            this._taskRunner = null;
        }
        if (this.timeout_task != null) {
            this.timeout_task.cancel(false);
            this.timeout_task = null;
        }
    }

    private void startTask(Message msg, String taskPartition) {
        int pId;
        JobConfig cfg = TaskUtil.getJobConfig(this._manager, msg.getResourceName());
        TaskConfig taskConfig = null;
        String command = cfg.getCommand();
        JobContext ctx = TaskUtil.getJobContext(this._manager, msg.getResourceName());
        if (ctx.getTaskIdForPartition(pId = Integer.parseInt(taskPartition.substring(taskPartition.lastIndexOf(95) + 1))) != null && (taskConfig = cfg.getTaskConfig(ctx.getTaskIdForPartition(pId))) != null && taskConfig.getCommand() != null) {
            command = taskConfig.getCommand();
        }
        String target = ctx.getTargetForPartition(pId);
        if (taskConfig == null && target != null) {
            taskConfig = TaskConfig.Builder.from(target);
        }
        TaskCallbackContext callbackContext = new TaskCallbackContext();
        callbackContext.setManager(this._manager);
        callbackContext.setJobConfig(cfg);
        callbackContext.setTaskConfig(taskConfig);
        if (command == null || this._taskFactoryRegistry == null || !this._taskFactoryRegistry.containsKey(command)) {
            throw new IllegalStateException("No callback implemented(or not registered) for task " + command);
        }
        TaskFactory taskFactory = this._taskFactoryRegistry.get(command);
        Task task = taskFactory.createNewTask(callbackContext);
        if (task instanceof UserContentStore) {
            ((UserContentStore)((Object)task)).init(this._manager, cfg.getWorkflow(), msg.getResourceName(), taskPartition);
        }
        this._taskRunner = new TaskRunner(task, msg.getResourceName(), taskPartition, msg.getTgtName(), this._manager, msg.getTgtSessionId());
        this._taskExecutor.submit(this._taskRunner);
        this._taskRunner.waitTillStarted();
        this.timeout_task = this._timeoutTaskExecutor.schedule(new TimerTask(){

            @Override
            public void run() {
                if (TaskStateModel.this._taskRunner != null) {
                    TaskStateModel.this._taskRunner.timeout();
                }
            }
        }, cfg.getTimeoutPerTask(), TimeUnit.MILLISECONDS);
    }
}

