/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.ScheduleConfig;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.beans.WorkflowBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowConfig
extends ResourceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowConfig.class);
    public static final long DEFAULT_EXPIRY = 86400000L;
    public static final int DEFAULT_FAILURE_THRESHOLD = 0;
    public static final int DEFAULT_PARALLEL_JOBS = 1;
    public static final int DEFAULT_CAPACITY = Integer.MAX_VALUE;
    public static final JobDag DEFAULT_JOB_DAG = JobDag.EMPTY_DAG;
    public static final TargetState DEFAULT_TARGET_STATE = TargetState.START;
    public static final boolean DEFAULT_TERMINABLE = true;
    public static final boolean DEFAULT_JOB_QUEUE = false;
    public static final boolean DEFAULT_MONITOR_DISABLE = true;
    public static final boolean DEFAULT_ALLOW_OVERLAP_JOB_ASSIGNMENT = false;
    protected static final long DEFAULT_JOB_PURGE_INTERVAL = 1800000L;
    private JobDag _jobDag;

    public WorkflowConfig(HelixProperty property) {
        super(property.getRecord());
    }

    public WorkflowConfig(WorkflowConfig cfg, String workflowId) {
        this(workflowId, cfg.getJobDag(), cfg.getParallelJobs(), cfg.getTargetState(), cfg.getExpiry(), cfg.getFailureThreshold(), cfg.isTerminable(), cfg.getScheduleConfig(), cfg.getCapacity(), cfg.getWorkflowType(), cfg.isJobQueue(), cfg.getJobTypes(), cfg.getJobPurgeInterval(), cfg.isAllowOverlapJobAssignment(), cfg.getTimeout());
    }

    protected WorkflowConfig(String workflowId, JobDag jobDag, int parallelJobs, TargetState targetState, long expiry, int failureThreshold, boolean terminable, ScheduleConfig scheduleConfig, int capacity, String workflowType, boolean isJobQueue, Map<String, String> jobTypes, long purgeInterval, boolean allowOverlapJobAssignment, long timeout) {
        super(workflowId);
        this.putSimpleConfig(WorkflowConfigProperty.WorkflowID.name(), workflowId);
        try {
            this.putSimpleConfig(WorkflowConfigProperty.Dag.name(), jobDag.toJson());
        }
        catch (IOException ex) {
            throw new HelixException("Invalid job dag configuration!", ex);
        }
        this.putSimpleConfig(WorkflowConfigProperty.ParallelJobs.name(), String.valueOf(parallelJobs));
        this.putSimpleConfig(WorkflowConfigProperty.Expiry.name(), String.valueOf(expiry));
        this.putSimpleConfig(WorkflowConfigProperty.TargetState.name(), targetState.name());
        this.putSimpleConfig(WorkflowConfigProperty.Terminable.name(), String.valueOf(terminable));
        this.putSimpleConfig(WorkflowConfigProperty.IsJobQueue.name(), String.valueOf(isJobQueue));
        this.putSimpleConfig(WorkflowConfigProperty.FailureThreshold.name(), String.valueOf(failureThreshold));
        this.putSimpleConfig(WorkflowConfigProperty.JobPurgeInterval.name(), String.valueOf(purgeInterval));
        this.putSimpleConfig(WorkflowConfigProperty.AllowOverlapJobAssignment.name(), String.valueOf(allowOverlapJobAssignment));
        if (capacity > 0) {
            this.putSimpleConfig(WorkflowConfigProperty.capacity.name(), String.valueOf(capacity));
        }
        if (timeout != -1L) {
            this.putSimpleConfig(WorkflowConfigProperty.Timeout.name(), String.valueOf(timeout));
        }
        if (scheduleConfig != null) {
            Date startTime = scheduleConfig.getStartTime();
            if (startTime != null) {
                String formattedTime = WorkflowConfig.getDefaultDateFormat().format(startTime);
                this.putSimpleConfig(WorkflowConfigProperty.StartTime.name(), formattedTime);
            }
            if (scheduleConfig.isRecurring()) {
                this.putSimpleConfig(WorkflowConfigProperty.RecurrenceUnit.name(), scheduleConfig.getRecurrenceUnit().toString());
                this.putSimpleConfig(WorkflowConfigProperty.RecurrenceInterval.name(), scheduleConfig.getRecurrenceInterval().toString());
            }
        }
        if (workflowType != null) {
            this.putSimpleConfig(WorkflowConfigProperty.WorkflowType.name(), workflowType);
        }
        if (jobTypes != null) {
            this.putMapConfig(WorkflowConfigProperty.JobTypes.name(), jobTypes);
        }
        this.putSimpleConfig(ResourceConfig.ResourceConfigProperty.MONITORING_DISABLED.toString(), String.valueOf(true));
    }

    public String getWorkflowId() {
        return this.getSimpleConfig(WorkflowConfigProperty.WorkflowID.name());
    }

    public JobDag getJobDag() {
        if (this._jobDag == null) {
            this._jobDag = this.simpleConfigContains(WorkflowConfigProperty.Dag.name()) ? JobDag.fromJson(this.getSimpleConfig(WorkflowConfigProperty.Dag.name())) : DEFAULT_JOB_DAG;
        }
        return this._jobDag;
    }

    protected void setJobDag(JobDag jobDag) {
        try {
            this.putSimpleConfig(WorkflowConfigProperty.Dag.name(), jobDag.toJson());
        }
        catch (IOException ex) {
            throw new HelixException("Invalid job dag configuration!", ex);
        }
    }

    public int getParallelJobs() {
        return this._record.getIntField(WorkflowConfigProperty.ParallelJobs.name(), 1);
    }

    public TargetState getTargetState() {
        return this.simpleConfigContains(WorkflowConfigProperty.TargetState.name()) ? TargetState.valueOf(this.getSimpleConfig(WorkflowConfigProperty.TargetState.name())) : DEFAULT_TARGET_STATE;
    }

    public long getExpiry() {
        return this._record.getLongField(WorkflowConfigProperty.Expiry.name(), 86400000L);
    }

    public long getJobPurgeInterval() {
        return this._record.getLongField(WorkflowConfigProperty.JobPurgeInterval.name(), 1800000L);
    }

    public int getFailureThreshold() {
        return this._record.getIntField(WorkflowConfigProperty.FailureThreshold.name(), 0);
    }

    public int getCapacity() {
        return this._record.getIntField(WorkflowConfigProperty.capacity.name(), Integer.MAX_VALUE);
    }

    public String getWorkflowType() {
        return this.simpleConfigContains(WorkflowConfigProperty.WorkflowType.name()) ? this.getSimpleConfig(WorkflowConfigProperty.WorkflowType.name()) : null;
    }

    public boolean isTerminable() {
        return this._record.getBooleanField(WorkflowConfigProperty.Terminable.name(), true);
    }

    public ScheduleConfig getScheduleConfig() {
        return WorkflowConfig.parseScheduleFromConfigMap(this.getSimpleConfigs());
    }

    public boolean isRecurring() {
        return this.simpleConfigContains(WorkflowConfigProperty.StartTime.name()) && this.simpleConfigContains(WorkflowConfigProperty.RecurrenceInterval.name()) && this.simpleConfigContains(WorkflowConfigProperty.RecurrenceUnit.name());
    }

    public boolean isJobQueue() {
        return this._record.getBooleanField(WorkflowConfigProperty.IsJobQueue.name(), false);
    }

    protected void setJobTypes(Map<String, String> jobTypes) {
        this.putMapConfig(WorkflowConfigProperty.JobTypes.name(), jobTypes);
    }

    public Map<String, String> getJobTypes() {
        return this.mapConfigContains(WorkflowConfigProperty.JobTypes.name()) ? this.getMapConfig(WorkflowConfigProperty.JobTypes.name()) : null;
    }

    public boolean isAllowOverlapJobAssignment() {
        return this._record.getBooleanField(WorkflowConfigProperty.AllowOverlapJobAssignment.name(), false);
    }

    public long getTimeout() {
        return this._record.getLongField(WorkflowConfigProperty.Timeout.name(), -1L);
    }

    public static SimpleDateFormat getDefaultDateFormat() {
        SimpleDateFormat defaultDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        defaultDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return defaultDateFormat;
    }

    public Date getStartTime() {
        try {
            return this.simpleConfigContains(WorkflowConfigProperty.StartTime.name()) ? WorkflowConfig.getDefaultDateFormat().parse(this.getSimpleConfig(WorkflowConfigProperty.StartTime.name())) : null;
        }
        catch (ParseException e) {
            LOG.error("Unparseable date " + this.getSimpleConfig(WorkflowConfigProperty.StartTime.name()), (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getResourceConfigMap() {
        return this.getSimpleConfigs();
    }

    public static ScheduleConfig parseScheduleFromConfigMap(Map<String, String> cfg) {
        Date startTime = null;
        if (cfg.containsKey(WorkflowConfigProperty.StartTime.name())) {
            try {
                startTime = WorkflowConfig.getDefaultDateFormat().parse(cfg.get(WorkflowConfigProperty.StartTime.name()));
            }
            catch (ParseException e) {
                LOG.error("Unparseable date " + cfg.get(WorkflowConfigProperty.StartTime.name()), (Throwable)e);
                return null;
            }
        }
        if (cfg.containsKey(WorkflowConfigProperty.RecurrenceUnit.name()) && cfg.containsKey(WorkflowConfigProperty.RecurrenceInterval.name())) {
            return ScheduleConfig.recurringFromDate(startTime, TimeUnit.valueOf(cfg.get(WorkflowConfigProperty.RecurrenceUnit.name())), Long.parseLong(cfg.get(WorkflowConfigProperty.RecurrenceInterval.name())));
        }
        if (startTime != null) {
            return ScheduleConfig.oneTimeDelayedStart(startTime);
        }
        return null;
    }

    public static WorkflowConfig fromHelixProperty(HelixProperty property) throws IllegalArgumentException {
        Map<String, String> configs = property.getRecord().getSimpleFields();
        if (!configs.containsKey(WorkflowConfigProperty.Dag.name())) {
            throw new IllegalArgumentException(String.format("%s is an invalid WorkflowConfig", property.getId()));
        }
        return Builder.fromMap(configs).setWorkflowId(property.getId()).build();
    }

    public static class Builder {
        private String _workflowId = null;
        private JobDag _taskDag = DEFAULT_JOB_DAG;
        private int _parallelJobs = 1;
        private TargetState _targetState = DEFAULT_TARGET_STATE;
        private long _expiry = 86400000L;
        private int _failureThreshold = 0;
        private boolean _isTerminable = true;
        private int _capacity = Integer.MAX_VALUE;
        private ScheduleConfig _scheduleConfig;
        private String _workflowType;
        private boolean _isJobQueue = false;
        private Map<String, String> _jobTypes;
        private long _jobPurgeInterval = 1800000L;
        private boolean _allowOverlapJobAssignment = false;
        private long _timeout = -1L;

        public WorkflowConfig build() {
            this.validate();
            return new WorkflowConfig(this._workflowId, this._taskDag, this._parallelJobs, this._targetState, this._expiry, this._failureThreshold, this._isTerminable, this._scheduleConfig, this._capacity, this._workflowType, this._isJobQueue, this._jobTypes, this._jobPurgeInterval, this._allowOverlapJobAssignment, this._timeout);
        }

        public Builder() {
        }

        public Builder(String workflowId) {
            this._workflowId = workflowId;
        }

        public Builder(WorkflowConfig workflowConfig) {
            this._workflowId = workflowConfig.getWorkflowId();
            this._taskDag = workflowConfig.getJobDag();
            this._parallelJobs = workflowConfig.getParallelJobs();
            this._targetState = workflowConfig.getTargetState();
            this._expiry = workflowConfig.getExpiry();
            this._isTerminable = workflowConfig.isTerminable();
            this._scheduleConfig = workflowConfig.getScheduleConfig();
            this._capacity = workflowConfig.getCapacity();
            this._failureThreshold = workflowConfig.getFailureThreshold();
            this._workflowType = workflowConfig.getWorkflowType();
            this._isJobQueue = workflowConfig.isJobQueue();
            this._jobTypes = workflowConfig.getJobTypes();
            this._jobPurgeInterval = workflowConfig.getJobPurgeInterval();
            this._allowOverlapJobAssignment = workflowConfig.isAllowOverlapJobAssignment();
            this._timeout = workflowConfig.getTimeout();
        }

        public Builder setWorkflowId(String v) {
            this._workflowId = v;
            return this;
        }

        protected Builder setJobDag(JobDag v) {
            this._taskDag = v;
            return this;
        }

        public Builder setParallelJobs(int parallelJobs) {
            this._parallelJobs = parallelJobs;
            return this;
        }

        public Builder setExpiry(long v, TimeUnit unit) {
            this._expiry = unit.toMillis(v);
            return this;
        }

        public Builder setExpiry(long v) {
            this._expiry = v;
            return this;
        }

        public Builder setJobPurgeInterval(long t) {
            this._jobPurgeInterval = t;
            return this;
        }

        public Builder setFailureThreshold(int failureThreshold) {
            this._failureThreshold = failureThreshold;
            return this;
        }

        public Builder setCapacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Builder setWorkFlowType(String workflowType) {
            this._workflowType = workflowType;
            return this;
        }

        protected Builder setTerminable(boolean isTerminable) {
            this._isTerminable = isTerminable;
            return this;
        }

        public Builder setTargetState(TargetState v) {
            this._targetState = v;
            return this;
        }

        public Builder setScheduleConfig(ScheduleConfig scheduleConfig) {
            this._scheduleConfig = scheduleConfig;
            return this;
        }

        protected Builder setJobQueue(boolean isJobQueue) {
            this._isJobQueue = isJobQueue;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this._timeout = timeout;
            return this;
        }

        public Builder setAllowOverlapJobAssignment(boolean allowOverlapJobAssignment) {
            this._allowOverlapJobAssignment = allowOverlapJobAssignment;
            return this;
        }

        @Deprecated
        public static Builder fromMap(Map<String, String> cfg) {
            Builder builder = new Builder();
            builder.setConfigMap(cfg);
            return builder;
        }

        public Builder setConfigMap(Map<String, String> cfg) {
            ScheduleConfig scheduleConfig;
            int threshold;
            long jobPurgeInterval;
            int capacity;
            if (cfg.containsKey(WorkflowConfigProperty.WorkflowID.name())) {
                this.setWorkflowId(cfg.get(WorkflowConfigProperty.WorkflowID.name()));
            }
            if (cfg.containsKey(WorkflowConfigProperty.Expiry.name())) {
                this.setExpiry(Long.parseLong(cfg.get(WorkflowConfigProperty.Expiry.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.FailureThreshold.name())) {
                this.setFailureThreshold(Integer.parseInt(cfg.get(WorkflowConfigProperty.FailureThreshold.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.Dag.name())) {
                this.setJobDag(JobDag.fromJson(cfg.get(WorkflowConfigProperty.Dag.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.TargetState.name())) {
                this.setTargetState(TargetState.valueOf(cfg.get(WorkflowConfigProperty.TargetState.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.Terminable.name())) {
                this.setTerminable(Boolean.parseBoolean(cfg.get(WorkflowConfigProperty.Terminable.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.ParallelJobs.name())) {
                String value = cfg.get(WorkflowConfigProperty.ParallelJobs.name());
                if (value == null) {
                    this.setParallelJobs(1);
                } else {
                    this.setParallelJobs(Integer.parseInt(value));
                }
            }
            if (cfg.containsKey(WorkflowConfigProperty.capacity.name()) && (capacity = Integer.valueOf(cfg.get(WorkflowConfigProperty.capacity.name())).intValue()) > 0) {
                this.setCapacity(capacity);
            }
            if (cfg.containsKey(WorkflowConfigProperty.JobPurgeInterval.name()) && (jobPurgeInterval = Long.valueOf(cfg.get(WorkflowConfigProperty.JobPurgeInterval.name())).longValue()) > 0L) {
                this.setJobPurgeInterval(jobPurgeInterval);
            }
            if (cfg.containsKey(WorkflowConfigProperty.FailureThreshold.name()) && (threshold = Integer.valueOf(cfg.get(WorkflowConfigProperty.FailureThreshold.name())).intValue()) >= 0) {
                this.setFailureThreshold(threshold);
            }
            if ((scheduleConfig = WorkflowConfig.parseScheduleFromConfigMap(cfg)) != null) {
                this.setScheduleConfig(scheduleConfig);
            }
            if (cfg.containsKey(WorkflowConfigProperty.WorkflowType.name())) {
                this.setWorkFlowType(cfg.get(WorkflowConfigProperty.WorkflowType.name()));
            }
            if (cfg.containsKey(WorkflowConfigProperty.IsJobQueue.name())) {
                this.setJobQueue(Boolean.parseBoolean(cfg.get(WorkflowConfigProperty.IsJobQueue.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.AllowOverlapJobAssignment.name())) {
                this.setAllowOverlapJobAssignment(Boolean.parseBoolean(cfg.get(WorkflowConfigProperty.AllowOverlapJobAssignment.name())));
            }
            if (cfg.containsKey(WorkflowConfigProperty.Timeout.name())) {
                this.setTimeout(Long.parseLong(cfg.get(WorkflowConfigProperty.Timeout.name())));
            }
            return this;
        }

        public int getParallelJobs() {
            return this._parallelJobs;
        }

        public TargetState getTargetState() {
            return this._targetState;
        }

        public long getExpiry() {
            return this._expiry;
        }

        public int getFailureThreshold() {
            return this._failureThreshold;
        }

        public boolean isTerminable() {
            return this._isTerminable;
        }

        public int getCapacity() {
            return this._capacity;
        }

        public ScheduleConfig getScheduleConfig() {
            return this._scheduleConfig;
        }

        public JobDag getJobDag() {
            return this._taskDag;
        }

        public boolean isJobQueue() {
            return this._isJobQueue;
        }

        public long getTimeout() {
            return this._timeout;
        }

        public static Builder from(WorkflowBean workflowBean) {
            Builder b = new Builder();
            if (workflowBean.schedule != null) {
                b.setScheduleConfig(ScheduleConfig.from(workflowBean.schedule));
            }
            b.setExpiry(workflowBean.expiry);
            return b;
        }

        private void validate() {
            this._taskDag.validate();
            if (this._expiry < 0L) {
                throw new HelixException(String.format("%s has invalid value %s", WorkflowConfigProperty.Expiry.name(), this._expiry));
            }
            if (this._scheduleConfig != null && !this._scheduleConfig.isValid()) {
                throw new HelixException("Scheduler configuration is invalid. The configuration must have a start time if it is one-time, and it must have a positive interval magnitude if it is recurring");
            }
        }
    }

    public static enum WorkflowConfigProperty {
        WorkflowID,
        Dag,
        ParallelJobs,
        TargetState,
        Expiry,
        StartTime,
        RecurrenceUnit,
        RecurrenceInterval,
        Terminable,
        FailureThreshold,
        capacity,
        WorkflowType,
        JobTypes,
        IsJobQueue,
        JobPurgeInterval,
        AllowOverlapJobAssignment,
        Timeout;

    }
}

