/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.session;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.session.FileSessionPropertyManagerConfig;
import com.facebook.presto.session.SessionMatchSpec;
import com.facebook.presto.spi.session.SessionConfigurationContext;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManager;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class FileSessionPropertyManager
implements SessionPropertyConfigurationManager {
    public static final JsonCodec<List<SessionMatchSpec>> CODEC = new JsonCodecFactory(() -> new ObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).listJsonCodec(SessionMatchSpec.class);
    private final List<SessionMatchSpec> sessionMatchSpecs;

    @Inject
    public FileSessionPropertyManager(FileSessionPropertyManagerConfig config) {
        Objects.requireNonNull(config, "config is null");
        Path configurationFile = config.getConfigFile().toPath();
        try {
            this.sessionMatchSpecs = (List)CODEC.fromJson(Files.readAllBytes(configurationFile));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException ex = (UnrecognizedPropertyException)cause;
                String message = String.format("Unknown property at line %s:%s: %s", ex.getLocation().getLineNr(), ex.getLocation().getColumnNr(), ex.getPropertyName());
                throw new IllegalArgumentException(message, e);
            }
            if (cause instanceof JsonMappingException) {
                if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new IllegalArgumentException(cause.getMessage(), e);
            }
            throw e;
        }
    }

    public Map<String, String> getSystemSessionProperties(SessionConfigurationContext context) {
        HashMap<String, String> combinedProperties = new HashMap<String, String>();
        for (SessionMatchSpec sessionMatchSpec : this.sessionMatchSpecs) {
            combinedProperties.putAll(sessionMatchSpec.match(context));
        }
        return ImmutableMap.copyOf(combinedProperties);
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties(SessionConfigurationContext context) {
        return ImmutableMap.of();
    }
}

