/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.base.CharMatcher;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.bson.types.ObjectId;

public class ObjectIdFunctions {
    private ObjectIdFunctions() {
    }

    @Description(value="mongodb ObjectId")
    @ScalarFunction(value="objectid")
    @SqlType(value="ObjectId")
    public static Slice ObjectId() {
        return Slices.wrappedBuffer((byte[])new ObjectId().toByteArray());
    }

    @Description(value="mongodb ObjectId from the given string")
    @ScalarFunction(value="objectid")
    @SqlType(value="ObjectId")
    public static Slice ObjectId(@SqlType(value="varchar") Slice value) {
        return Slices.wrappedBuffer((byte[])new ObjectId(CharMatcher.is((char)' ').removeFrom((CharSequence)value.toStringUtf8())).toByteArray());
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="ObjectId") Slice left, @SqlType(value="ObjectId") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="ObjectId") Slice left, @SqlType(value="ObjectId") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="ObjectId") Slice left, @SqlType(value="ObjectId") Slice right) {
        return ObjectIdFunctions.compareTo(left, right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="ObjectId") Slice left, @SqlType(value="ObjectId") Slice right) {
        return ObjectIdFunctions.compareTo(left, right) >= 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="ObjectId") Slice left, @SqlType(value="ObjectId") Slice right) {
        return ObjectIdFunctions.compareTo(left, right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="ObjectId") Slice left, @SqlType(value="ObjectId") Slice right) {
        return ObjectIdFunctions.compareTo(left, right) <= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="ObjectId") Slice value, @SqlType(value="ObjectId") Slice min, @SqlType(value="ObjectId") Slice max) {
        return ObjectIdFunctions.compareTo(value, min) >= 0 && ObjectIdFunctions.compareTo(value, max) <= 0;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="ObjectId") Slice value) {
        return new ObjectId(value.getBytes()).hashCode();
    }

    private static int compareTo(Slice left, Slice right) {
        return new ObjectId(left.getBytes()).compareTo(new ObjectId(right.getBytes()));
    }
}

