/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.Cleanable;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.SqlObjectContext;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public final class ConcreteStatementContext
implements StatementContext {
    private final Set<Cleanable> cleanables = new LinkedHashSet<Cleanable>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final MappingRegistry mappingRegistry;
    private String rawSql;
    private String rewrittenSql;
    private String locatedSql;
    private PreparedStatement statement;
    private Connection connection;
    private Binding binding;
    private Class<?> sqlObjectType;
    private Method sqlObjectMethod;
    private boolean returningGeneratedKeys;
    private boolean concurrentUpdatable;
    private String[] generatedKeysColumnNames;
    private Foreman foreman;

    ConcreteStatementContext() {
        this(new HashMap<String, Object>(), new MappingRegistry(), new SqlObjectContext());
    }

    ConcreteStatementContext(Map<String, Object> globalAttributes, MappingRegistry mappingRegistry, SqlObjectContext sqlObjectContext) {
        this.attributes.putAll(globalAttributes);
        this.mappingRegistry = mappingRegistry;
        this.sqlObjectType = sqlObjectContext.type;
        this.sqlObjectMethod = sqlObjectContext.method;
    }

    @Override
    public Object setAttribute(String key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public ResultColumnMapper columnMapperFor(Class type) {
        return this.mappingRegistry.columnMapperFor(type, this);
    }

    void setRawSql(String rawSql) {
        this.rawSql = rawSql;
    }

    @Override
    public String getRawSql() {
        return this.rawSql;
    }

    void setLocatedSql(String locatedSql) {
        this.locatedSql = locatedSql;
    }

    void setRewrittenSql(String rewrittenSql) {
        this.rewrittenSql = rewrittenSql;
    }

    @Override
    public String getRewrittenSql() {
        return this.rewrittenSql;
    }

    @Override
    public String getLocatedSql() {
        return this.locatedSql;
    }

    void setStatement(PreparedStatement stmt) {
        this.statement = stmt;
    }

    @Override
    public PreparedStatement getStatement() {
        return this.statement;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void setBinding(Binding b) {
        this.binding = b;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public void setSqlObjectType(Class<?> sqlObjectType) {
        this.sqlObjectType = sqlObjectType;
    }

    @Override
    public Class<?> getSqlObjectType() {
        return this.sqlObjectType;
    }

    public void setSqlObjectMethod(Method sqlObjectMethod) {
        this.sqlObjectMethod = sqlObjectMethod;
    }

    @Override
    public Method getSqlObjectMethod() {
        return this.sqlObjectMethod;
    }

    public void setReturningGeneratedKeys(boolean b) {
        if (this.isConcurrentUpdatable() && b) {
            throw new IllegalArgumentException("Cannot create a result set that is concurrent updatable and is returning generated keys.");
        }
        this.returningGeneratedKeys = b;
    }

    @Override
    public boolean isReturningGeneratedKeys() {
        return this.returningGeneratedKeys || this.generatedKeysColumnNames != null && this.generatedKeysColumnNames.length > 0;
    }

    @Override
    public String[] getGeneratedKeysColumnNames() {
        if (this.generatedKeysColumnNames == null) {
            return new String[0];
        }
        return Arrays.copyOf(this.generatedKeysColumnNames, this.generatedKeysColumnNames.length);
    }

    public void setGeneratedKeysColumnNames(String[] generatedKeysColumnNames) {
        this.generatedKeysColumnNames = Arrays.copyOf(generatedKeysColumnNames, generatedKeysColumnNames.length);
    }

    @Override
    public void addCleanable(Cleanable cleanable) {
        this.cleanables.add(cleanable);
    }

    @Override
    public boolean isConcurrentUpdatable() {
        return this.concurrentUpdatable;
    }

    @Override
    public Foreman getForeman() {
        return this.foreman;
    }

    public void setConcurrentUpdatable(boolean concurrentUpdatable) {
        if (concurrentUpdatable && this.isReturningGeneratedKeys()) {
            throw new IllegalArgumentException("Cannot create a result set that is concurrent updatable and is returning generated keys.");
        }
        this.concurrentUpdatable = concurrentUpdatable;
    }

    public Collection<Cleanable> getCleanables() {
        return this.cleanables;
    }

    void setForeman(Foreman foreman) {
        this.foreman = foreman;
    }
}

