/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.atop;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.atop.AtopConnector;
import com.facebook.presto.atop.AtopConnectorConfig;
import com.facebook.presto.atop.AtopConnectorId;
import com.facebook.presto.atop.AtopFactory;
import com.facebook.presto.atop.AtopMetadata;
import com.facebook.presto.atop.AtopPageSourceProvider;
import com.facebook.presto.atop.AtopSplitManager;
import com.facebook.presto.atop.Environment;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.type.TypeManager;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;

public class AtopModule
implements Module {
    private final Class<? extends AtopFactory> atopFactoryClass;
    private final TypeManager typeManager;
    private final NodeManager nodeManager;
    private final String environment;
    private final String connectorId;

    public AtopModule(Class<? extends AtopFactory> atopFactoryClass, TypeManager typeManager, NodeManager nodeManager, String environment, String connectorId) {
        this.atopFactoryClass = Objects.requireNonNull(atopFactoryClass, "atopFactoryClass is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(Environment.class).toInstance((Object)new Environment(this.environment));
        binder.bind(AtopConnectorId.class).toInstance((Object)new AtopConnectorId(this.connectorId));
        binder.bind(AtopConnector.class).in(Scopes.SINGLETON);
        binder.bind(AtopMetadata.class).in(Scopes.SINGLETON);
        binder.bind(AtopSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(AtopFactory.class).to(this.atopFactoryClass).in(Scopes.SINGLETON);
        binder.bind(AtopPageSourceProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(AtopConnectorConfig.class);
    }
}

