/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.atop;

import com.facebook.presto.atop.AtopColumnHandle;
import com.facebook.presto.atop.AtopConnectorConfig;
import com.facebook.presto.atop.AtopFactory;
import com.facebook.presto.atop.AtopPageSource;
import com.facebook.presto.atop.AtopSplit;
import com.facebook.presto.atop.AtopTable;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import javax.inject.Inject;

public final class AtopPageSourceProvider
implements ConnectorPageSourceProvider {
    private final Semaphore readerPermits;
    private final AtopFactory atopFactory;
    private final TypeManager typeManager;

    @Inject
    public AtopPageSourceProvider(AtopConnectorConfig config, AtopFactory atopFactory, TypeManager typeManager) {
        this.readerPermits = new Semaphore(Objects.requireNonNull(config, "config is null").getConcurrentReadersPerNode());
        this.atopFactory = Objects.requireNonNull(atopFactory, "atopFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        AtopSplit atopSplit = (AtopSplit)split;
        ImmutableList.Builder types = ImmutableList.builder();
        ImmutableList.Builder atopColumns = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            AtopColumnHandle atopColumnHandle = (AtopColumnHandle)column;
            AtopTable.AtopColumn atopColumn = atopSplit.getTable().getColumn(atopColumnHandle.getName());
            atopColumns.add((Object)atopColumn);
            types.add((Object)this.typeManager.getType(atopColumn.getType()));
        }
        ZonedDateTime date = atopSplit.getDate();
        Preconditions.checkArgument((boolean)date.equals(date.withHour(0).withMinute(0).withSecond(0).withNano(0)), (Object)"Expected date to be at beginning of day");
        return new AtopPageSource(this.readerPermits, this.atopFactory, session, Slices.utf8Slice((String)atopSplit.getHost().getHostText()), atopSplit.getTable(), date, (List<AtopTable.AtopColumn>)atopColumns.build(), (List<Type>)types.build());
    }
}

