/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceGroupIdTemplate {
    private final List<ResourceGroupNameTemplate> segments;

    @JsonCreator
    public ResourceGroupIdTemplate(String fullId) {
        List segments = Splitter.on((String)".").splitToList((CharSequence)Objects.requireNonNull(fullId, "fullId is null"));
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Resource group id is empty");
        this.segments = segments.stream().map(ResourceGroupNameTemplate::new).collect(Collectors.toList());
    }

    public static ResourceGroupIdTemplate forSubGroupNamed(ResourceGroupIdTemplate parent, String name) {
        return new ResourceGroupIdTemplate(String.format("%s.%s", Objects.requireNonNull(parent, "parent is null"), Objects.requireNonNull(name, "name is null")));
    }

    public static ResourceGroupIdTemplate fromSegments(List<ResourceGroupNameTemplate> segments) {
        return new ResourceGroupIdTemplate(String.join((CharSequence)".", segments.stream().map(ResourceGroupNameTemplate::toString).collect(Collectors.toList())));
    }

    public ResourceGroupId expandTemplate(VariableMap context) {
        ResourceGroupId id = null;
        for (ResourceGroupNameTemplate segment : this.segments) {
            String expanded = segment.expandTemplate(context);
            if (id == null) {
                id = new ResourceGroupId(expanded);
                continue;
            }
            id = new ResourceGroupId(id, expanded);
        }
        return id;
    }

    public List<ResourceGroupNameTemplate> getSegments() {
        return ImmutableList.copyOf(this.segments);
    }

    public Set<String> getVariableNames() {
        return (Set)this.segments.stream().flatMap(s -> s.getVariableNames().stream()).collect(ImmutableSet.toImmutableSet());
    }

    public String toString() {
        return Joiner.on((String)".").join(this.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupIdTemplate that = (ResourceGroupIdTemplate)o;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }
}

