/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardSSLNettyHttpServerTransport
extends Netty4HttpServerTransport {
    private final SearchGuardKeyStore sgks;
    private final ThreadContext threadContext;
    private final SslExceptionHandler errorHandler;

    public SearchGuardSSLNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, SearchGuardKeyStore sgks, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher, SslExceptionHandler errorHandler) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, (HttpServerTransport.Dispatcher)dispatcher);
        this.sgks = sgks;
        this.threadContext = threadPool.getThreadContext();
        this.errorHandler = errorHandler;
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHttpChannelHandler(this, this.sgks);
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.lifecycle.started()) {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            this.errorHandler.logError(cause, true);
            if (cause instanceof NotSslRecordException) {
                this.logger.warn("Someone ({}) speaks http plaintext instead of ssl, will close the channel", (Object)ctx.channel().remoteAddress());
                ctx.channel().close();
                return;
            }
            if (cause instanceof SSLException) {
                this.logger.error("SSL Problem " + cause.getMessage(), cause);
                ctx.channel().close();
                return;
            }
            if (cause instanceof SSLHandshakeException) {
                this.logger.error("Problem during handshake " + cause.getMessage());
                ctx.channel().close();
                return;
            }
        }
        super.exceptionCaught(ctx, cause);
    }

    protected class SSLHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SSLHttpChannelHandler(Netty4HttpServerTransport transport, SearchGuardKeyStore sgks) {
            super(transport, SearchGuardSSLNettyHttpServerTransport.this.detailedErrorsEnabled, SearchGuardSSLNettyHttpServerTransport.this.threadContext);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyHttpServerTransport.this.sgks.createHTTPSSLEngine());
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

