/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.store;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.store.Entry;
import com.facebook.airlift.discovery.store.LocalStore;
import com.facebook.airlift.discovery.store.StoreConfig;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import io.airlift.units.Duration;
import java.io.EOFException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class Replicator {
    private static final Logger log = Logger.get(Replicator.class);
    private final String name;
    private final NodeInfo node;
    private final ServiceSelector selector;
    private final HttpClient httpClient;
    private final LocalStore localStore;
    private final Duration replicationInterval;
    private ScheduledFuture<?> future;
    private ScheduledExecutorService executor;
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
    private final AtomicLong lastReplicationTimestamp = new AtomicLong();

    @Inject
    public Replicator(String name, NodeInfo node, ServiceSelector selector, HttpClient httpClient, LocalStore localStore, StoreConfig config) {
        this.name = name;
        this.node = node;
        this.selector = selector;
        this.httpClient = httpClient;
        this.localStore = localStore;
        this.replicationInterval = config.getReplicationInterval();
    }

    @PostConstruct
    public synchronized void start() {
        if (this.future == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)("replicator-" + this.name)));
            this.future = this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        Replicator.this.synchronize();
                    }
                    catch (Throwable t) {
                        log.warn(t, "Error replicating state");
                    }
                }
            }, 0L, this.replicationInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @PreDestroy
    public synchronized void shutdown() {
        if (this.future != null) {
            this.future.cancel(true);
            this.executor.shutdownNow();
            this.executor = null;
            this.future = null;
        }
    }

    @Managed
    public long getLastReplicationTimestamp() {
        return this.lastReplicationTimestamp.get();
    }

    private void synchronize() {
        for (ServiceDescriptor descriptor : this.selector.selectAllServices()) {
            if (descriptor.getNodeId().equals(this.node.getNodeId())) continue;
            String uri = (String)descriptor.getProperties().get("http");
            if (uri == null) {
                log.error("service descriptor for node %s is missing http uri", new Object[]{descriptor.getNodeId()});
                continue;
            }
            Request request = Request.Builder.prepareGet().setUri(URI.create(uri + "/v1/store/" + this.name)).build();
            try {
                this.httpClient.execute(request, (ResponseHandler)new ResponseHandler<Void, Exception>(){

                    public Void handleException(Request request, Exception exception) throws Exception {
                        throw exception;
                    }

                    public Void handle(Request request, Response response) throws Exception {
                        if (response.getStatusCode() == 200) {
                            try {
                                List entries = (List)Replicator.this.mapper.readValue(response.getInputStream(), (TypeReference)new TypeReference<List<Entry>>(){});
                                for (Entry entry : entries) {
                                    Replicator.this.localStore.put(entry);
                                }
                            }
                            catch (EOFException eOFException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {}
        }
        this.lastReplicationTimestamp.set(System.currentTimeMillis());
    }
}

