/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ClosingBlockLease
implements BlockLease {
    private final Block block;
    private final List<Closer> closers;
    private boolean closed;
    private boolean retrieved;

    public ClosingBlockLease(Block block, Closer ... closers) {
        Objects.requireNonNull(block, "block is null");
        Objects.requireNonNull(closers, "closers is null");
        this.block = block;
        this.closers = closers.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList((Object[])closers.clone()));
    }

    public static BlockLease newLease(Block block, Closer ... closers) {
        return new ClosingBlockLease(block, closers);
    }

    @Override
    public Block get() {
        ClosingBlockLease.checkState(!this.closed, "block lease is closed");
        ClosingBlockLease.checkState(!this.retrieved, "block lease already retrieved");
        this.retrieved = true;
        return this.block;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Throwable innerException = null;
        for (Closer closer : this.closers) {
            try {
                closer.close();
            }
            catch (Throwable t) {
                if (innerException == null) {
                    innerException = t;
                    continue;
                }
                if (innerException == t) continue;
                innerException.addSuppressed(t);
            }
        }
        if (innerException != null) {
            throw new RuntimeException(innerException);
        }
    }

    private static void checkState(boolean state, String message) {
        if (!state) {
            throw new IllegalStateException(message);
        }
    }

    public static interface Closer
    extends AutoCloseable {
        @Override
        public void close();
    }
}

