/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockUtil;
import com.facebook.presto.spi.block.IntArrayBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class IntArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntArrayBlockBuilder.class).instanceSize();
    private static final Block NULL_VALUE_BLOCK = new IntArrayBlock(0, 1, new boolean[]{true}, new int[1]);
    @Nullable
    private BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;

    public IntArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedBlock(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new IntArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        return new IntArrayBlockBuilder(blockBuilderStatus, BlockUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        return 5L * (long)BlockUtil.countUsedPositions(positions);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 4L;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((int[])this.values));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getInt(int position) {
        this.checkReadablePosition(position);
        return this.values[position];
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull[position];
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeInt(this.values[position]);
        blockBuilder.closeEntry();
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            output.writeInt(this.values[position]);
        }
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        boolean isNull;
        boolean bl = isNull = input.readByte() == 0;
        if (isNull) {
            this.appendNull();
        } else {
            this.writeInt(input.readInt());
            this.closeEntry();
        }
        return this;
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        if (this.valueIsNull[position]) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new IntArrayBlock(0, 1, blArray, new int[]{this.values[position]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedBlock(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = new boolean[length];
        }
        int[] newValues = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.checkReadablePosition(position);
            if (this.hasNullValue) {
                newValueIsNull[i] = this.valueIsNull[position];
            }
            newValues[i] = this.values[position];
        }
        return new IntArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedBlock(NULL_VALUE_BLOCK, length);
        }
        return new IntArrayBlock(positionOffset, length, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedBlock(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        }
        int[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new IntArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "INT_ARRAY";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.values[internalPosition];
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }
}

